/*
 * Decompiled with CFR 0.152.
 */
package com.orion.office.excel.convert.adapter;

import com.orion.lang.able.Adaptable;
import com.orion.lang.able.SafeCloseable;
import com.orion.lang.utils.io.Streams;
import com.orion.office.csv.writer.CsvArrayWriter;
import com.orion.office.excel.Excels;
import java.util.ArrayList;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;

public class CsvAdapter
implements Adaptable<CsvAdapter>,
SafeCloseable {
    private final Sheet sheet;
    private final CsvArrayWriter writer;
    private int skip;
    private String[] header;

    public CsvAdapter(Sheet sheet, CsvArrayWriter writer) {
        this.sheet = sheet;
        this.writer = writer;
    }

    public CsvAdapter skip() {
        ++this.skip;
        return this;
    }

    public CsvAdapter skip(int i) {
        this.skip += i;
        return this;
    }

    public CsvAdapter header(String ... header) {
        this.header = header == null || header.length == 0 ? null : header;
        return this;
    }

    public CsvAdapter forNew() {
        if (this.header != null) {
            this.writer.headers(this.header);
        }
        int i = 0;
        for (Row cells : this.sheet) {
            if (i++ < this.skip) continue;
            ArrayList<String> row = new ArrayList<String>();
            for (Cell cell : cells) {
                String value = Excels.getCellValue(cell);
                row.add(value);
            }
            this.writer.addRow(row.toArray(new String[0]));
        }
        this.writer.flush();
        this.writer.close();
        return this;
    }

    public void close() {
        try {
            Streams.close((AutoCloseable)this.sheet.getWorkbook());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Sheet getSheet() {
        return this.sheet;
    }

    public CsvArrayWriter getWriter() {
        return this.writer;
    }
}

