/*
 * Decompiled with CFR 0.152.
 */
package com.orion.office.excel.copy;

import com.orion.lang.utils.Valid;
import com.orion.office.excel.Excels;
import org.apache.poi.hssf.usermodel.HSSFPalette;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.PrintSetup;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;

public class SheetCopier {
    private final Workbook sourceWorkbook;
    private final Workbook targetWorkbook;
    private final Sheet sourceSheet;
    private final Sheet targetSheet;
    private int column;

    public SheetCopier(Workbook sourceWorkbook, Workbook targetWorkbook, Sheet sourceSheet, Sheet targetSheet) {
        Valid.notNull((Object)sourceWorkbook, (String)"sourceWorkbook is null", (Object[])new Object[0]);
        Valid.notNull((Object)targetWorkbook, (String)"targetWorkbook is null", (Object[])new Object[0]);
        Valid.notNull((Object)sourceSheet, (String)"sourceSheet is null", (Object[])new Object[0]);
        Valid.notNull((Object)targetSheet, (String)"targetSheet is null", (Object[])new Object[0]);
        Valid.isTrue((sourceSheet.getClass() == targetSheet.getClass() ? 1 : 0) != 0, (String)"sourceSheet class not equal targetSheet class", (Object[])new Object[0]);
        this.sourceWorkbook = sourceWorkbook;
        this.targetWorkbook = targetWorkbook;
        this.sourceSheet = sourceSheet;
        this.targetSheet = targetSheet;
        this.column = 32;
    }

    public void copy() {
        this.copyWorkbookColor();
        this.copySheetStyle();
        this.copyMargin();
        this.copyPrint();
        for (Row source : this.sourceSheet) {
            Row target = this.targetSheet.createRow(source.getRowNum());
            this.copyRow(source, target);
        }
        this.copyRegion(this.sourceSheet, this.targetSheet);
    }

    public SheetCopier column(int column) {
        this.column = column;
        return this;
    }

    private void copySheetStyle() {
        this.targetSheet.setDefaultColumnWidth(this.sourceSheet.getDefaultColumnWidth());
        this.targetSheet.setDefaultRowHeight(this.sourceSheet.getDefaultRowHeight());
        this.targetSheet.setFitToPage(this.sourceSheet.getFitToPage());
        this.targetSheet.setAutobreaks(this.sourceSheet.getAutobreaks());
        for (int i = 0; i < this.column; ++i) {
            this.targetSheet.setColumnWidth(i, this.sourceSheet.getColumnWidth(i));
        }
    }

    private void copyWorkbookColor() {
        if (this.sourceWorkbook instanceof HSSFWorkbook && this.targetWorkbook instanceof HSSFWorkbook) {
            HSSFPalette sourcePalette = ((HSSFWorkbook)this.sourceWorkbook).getCustomPalette();
            HSSFPalette targetPalette = ((HSSFWorkbook)this.targetWorkbook).getCustomPalette();
            for (int i = 8; i < 64; ++i) {
                short[] cs = sourcePalette.getColor(i).getTriplet();
                targetPalette.setColorAtIndex((short)i, (byte)cs[0], (byte)cs[1], (byte)cs[2]);
            }
        }
    }

    private void copyRow(Row source, Row target) {
        target.setHeight(source.getHeight());
        CellStyle sourceStyle = source.getRowStyle();
        if (sourceStyle != null) {
            CellStyle targetStyle = this.targetWorkbook.createCellStyle();
            targetStyle.cloneStyleFrom(sourceStyle);
            target.setRowStyle(targetStyle);
        }
        target.setZeroHeight(source.getZeroHeight());
        for (Cell cell : source) {
            this.copyCell(cell, target.createCell(cell.getColumnIndex()));
        }
    }

    private void copyRegion(Sheet source, Sheet target) {
        int sheetMergerCount = source.getNumMergedRegions();
        for (int i = 0; i < sheetMergerCount; ++i) {
            CellRangeAddress address = source.getMergedRegion(i);
            if (address == null) continue;
            target.addMergedRegion(address);
        }
    }

    private void copyCell(Cell source, Cell target) {
        Comment comment;
        CellStyle resStyle = source.getCellStyle();
        if (resStyle != null) {
            CellStyle style = this.targetWorkbook.createCellStyle();
            style.cloneStyleFrom(resStyle);
            target.setCellStyle(style);
        }
        if ((comment = source.getCellComment()) != null) {
            target.setCellComment(comment);
        }
        Excels.copyCellValue(source, target);
    }

    private void copyCellStyle(CellStyle source, CellStyle target) {
        target.setBorderBottom(source.getBorderBottom());
        target.setBorderLeft(source.getBorderLeft());
        target.setBorderRight(source.getBorderRight());
        target.setBorderTop(source.getBorderTop());
        target.setTopBorderColor(source.getTopBorderColor());
        target.setBottomBorderColor(source.getBottomBorderColor());
        target.setRightBorderColor(source.getRightBorderColor());
        target.setLeftBorderColor(source.getLeftBorderColor());
        target.setFillPattern(source.getFillPattern());
        if (source instanceof XSSFCellStyle && target instanceof XSSFCellStyle) {
            ((XSSFCellStyle)target).setFillBackgroundColor(((XSSFCellStyle)source).getFillBackgroundColorColor());
            ((XSSFCellStyle)target).setFillForegroundColor(((XSSFCellStyle)source).getFillForegroundColorColor());
        } else {
            target.setFillBackgroundColor(source.getFillBackgroundColor());
            target.setFillForegroundColor(source.getFillForegroundColor());
        }
        target.setDataFormat(source.getDataFormat());
        target.setFillPattern(source.getFillPattern());
        target.setHidden(source.getHidden());
        target.setIndention(source.getIndention());
        target.setLocked(source.getLocked());
        target.setRotation(source.getRotation());
        target.setVerticalAlignment(source.getVerticalAlignment());
        target.setWrapText(source.getWrapText());
        target.setAlignment(source.getAlignment());
        target.setShrinkToFit(source.getShrinkToFit());
        target.setQuotePrefixed(source.getQuotePrefixed());
        Font sourceFont = this.sourceWorkbook.getFontAt(source.getFontIndexAsInt());
        if (sourceFont != null) {
            Font targetFont = this.targetWorkbook.createFont();
            this.copyFont(sourceFont, targetFont);
            target.setFont(targetFont);
        }
    }

    private void copyFont(Font source, Font target) {
        if (source instanceof XSSFFont && target instanceof XSSFFont) {
            ((XSSFFont)target).setColor(((XSSFFont)source).getXSSFColor());
            ((XSSFFont)target).setFamily(((XSSFFont)source).getFamily());
            ((XSSFFont)target).setScheme(((XSSFFont)source).getScheme());
        } else {
            target.setColor(source.getColor());
        }
        target.setUnderline(source.getUnderline());
        target.setItalic(source.getItalic());
        target.setBold(source.getBold());
        target.setFontName(source.getFontName());
        target.setFontHeight(source.getFontHeight());
        target.setCharSet(source.getCharSet());
        target.setTypeOffset(source.getTypeOffset());
        target.setStrikeout(source.getStrikeout());
    }

    private void copyPrint() {
        PrintSetup source = this.sourceSheet.getPrintSetup();
        PrintSetup target = this.targetSheet.getPrintSetup();
        target.setUsePage(source.getUsePage());
        target.setScale(source.getScale());
        target.setPaperSize(source.getPaperSize());
        target.setPageStart(source.getPageStart());
        target.setNotes(source.getNotes());
        if (source.getNoOrientation()) {
            target.setNoOrientation(true);
        } else {
            target.setNoOrientation(false);
            target.setLandscape(source.getLandscape());
        }
        target.setNoColor(source.getNoColor());
        target.setLeftToRight(source.getLeftToRight());
        target.setHResolution(source.getHResolution());
        target.setVResolution(source.getVResolution());
        target.setHeaderMargin(source.getHeaderMargin());
        target.setFooterMargin(source.getFooterMargin());
        target.setCopies(source.getCopies());
        target.setDraft(source.getDraft());
        target.setFitWidth(source.getFitWidth());
        target.setFitHeight(source.getFitHeight());
        target.setValidSettings(source.getValidSettings());
    }

    private void copyMargin() {
        for (short i = 0; i < 5; i = (short)(i + 1)) {
            this.targetSheet.setMargin(i, this.sourceSheet.getMargin(i));
        }
    }

    public Workbook getSourceWorkbook() {
        return this.sourceWorkbook;
    }

    public Workbook getTargetWorkbook() {
        return this.targetWorkbook;
    }

    public Sheet getSourceSheet() {
        return this.sourceSheet;
    }

    public Sheet getTargetSheet() {
        return this.targetSheet;
    }
}

