/*
 * Decompiled with CFR 0.152.
 */
package com.orion.office.excel.merge;

import com.orion.lang.utils.Valid;
import com.orion.office.excel.Excels;
import com.orion.office.excel.writer.BaseExcelWriteable;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class ExcelMerge
extends BaseExcelWriteable {
    private final Workbook sourceWorkbook;
    private final Sheet sourceSheet;
    private int rowIndex;
    private int skipRows;
    private int height;

    public ExcelMerge() {
        this((Workbook)new SXSSFWorkbook(), null);
    }

    public ExcelMerge(Workbook sourceWorkbook, Sheet sourceSheet) {
        super(sourceWorkbook);
        Valid.isFalse((boolean)Excels.isStreamingSheet(sourceSheet), (String)"origin is not be streaming", (Object[])new Object[0]);
        this.sourceWorkbook = sourceWorkbook;
        if (sourceSheet == null) {
            sourceSheet = sourceWorkbook.createSheet();
        }
        this.sourceSheet = sourceSheet;
        this.rowIndex = sourceSheet.getLastRowNum() + 1;
    }

    public ExcelMerge skip() {
        ++this.rowIndex;
        return this;
    }

    public ExcelMerge skip(int skip) {
        this.rowIndex += skip;
        return this;
    }

    public ExcelMerge skipRows() {
        ++this.skipRows;
        return this;
    }

    public ExcelMerge skipRows(int skip) {
        this.skipRows += skip;
        return this;
    }

    public ExcelMerge width(int column, int width) {
        this.sourceSheet.setColumnWidth(column, Excels.getWidth(width));
        return this;
    }

    public ExcelMerge width(int width) {
        this.sourceSheet.setDefaultColumnWidth(width);
        return this;
    }

    public ExcelMerge height(int height) {
        this.height = height;
        this.sourceSheet.setDefaultRowHeightInPoints((float)height);
        return this;
    }

    public ExcelMerge merge(Sheet sheet) {
        boolean streaming = Excels.isStreamingSheet(sheet);
        int i = 0;
        for (Row sheetRow : sheet) {
            if (i++ < this.skipRows) continue;
            Row originRow = this.sourceSheet.createRow(this.rowIndex++);
            if (!streaming && this.height != 0) {
                originRow.setHeightInPoints((float)this.height);
            }
            int cellIndex = 0;
            for (Cell cell : sheetRow) {
                Cell originCell = originRow.createCell(cellIndex++);
                if (!streaming) {
                    CellStyle originStyle = this.sourceWorkbook.createCellStyle();
                    originStyle.cloneStyleFrom(cell.getCellStyle());
                    originCell.setCellStyle(originStyle);
                }
                Excels.copyCellValue(cell, originCell);
            }
        }
        this.skipRows = 0;
        return this;
    }

    public ExcelMerge protect(String password) {
        this.sourceSheet.protectSheet(password);
        return this;
    }

    public Workbook getSourceWorkbook() {
        return this.sourceWorkbook;
    }

    public Sheet getSourceSheet() {
        return this.sourceSheet;
    }
}

