/*
 * Decompiled with CFR 0.152.
 */
package com.orion.office.excel.picture;

import com.orion.lang.able.Analysable;
import com.orion.lang.define.collect.MultiHashMap;
import com.orion.lang.utils.collect.Lists;
import java.util.Collection;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFPicture;
import org.apache.poi.hssf.usermodel.HSSFShape;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ooxml.POIXMLDocumentPart;
import org.apache.poi.ss.usermodel.PictureData;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFDrawing;
import org.apache.poi.xssf.usermodel.XSSFPicture;
import org.apache.poi.xssf.usermodel.XSSFShape;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.openxmlformats.schemas.drawingml.x2006.spreadsheetDrawing.CTMarker;

public class PictureParser
implements Analysable {
    private final MultiHashMap<Integer, Integer, PictureData> picturePosition;
    private final Workbook workbook;
    private final Sheet sheet;

    public PictureParser(Workbook workbook, Sheet sheet) {
        this.workbook = workbook;
        this.sheet = sheet;
        this.picturePosition = new MultiHashMap();
    }

    public void analysis() {
        block5: {
            block4: {
                List pictures = this.workbook.getAllPictures();
                if (Lists.isEmpty((Collection)pictures)) {
                    return;
                }
                if (!(this.workbook instanceof HSSFWorkbook)) break block4;
                HSSFSheet s = (HSSFSheet)this.sheet;
                for (HSSFShape shape : s.getDrawingPatriarch().getChildren()) {
                    HSSFClientAnchor anchor = (HSSFClientAnchor)shape.getAnchor();
                    if (!(shape instanceof HSSFPicture)) continue;
                    PictureData pictureData = (PictureData)pictures.get(((HSSFPicture)shape).getPictureIndex() - 1);
                    this.picturePosition.put((Object)anchor.getRow1(), (Object)anchor.getCol1(), (Object)pictureData);
                }
                break block5;
            }
            if (!(this.workbook instanceof XSSFWorkbook)) break block5;
            XSSFSheet s = (XSSFSheet)this.sheet;
            for (POIXMLDocumentPart part : s.getRelations()) {
                if (!(part instanceof XSSFDrawing)) continue;
                XSSFDrawing drawing = (XSSFDrawing)part;
                List shapes = drawing.getShapes();
                for (XSSFShape shape : shapes) {
                    if (!(shape instanceof XSSFPicture)) continue;
                    XSSFClientAnchor anchor = ((XSSFPicture)shape).getPreferredSize();
                    CTMarker ctMarker = anchor.getFrom();
                    this.picturePosition.put((Object)ctMarker.getRow(), (Object)ctMarker.getCol(), (Object)((XSSFPicture)shape).getPictureData());
                }
            }
        }
    }

    public PictureData getPicture(int row, int col) {
        return (PictureData)this.picturePosition.get((Object)row, (Object)col);
    }
}

