/*
 * Decompiled with CFR 0.152.
 */
package com.orion.office.excel.reader;

import com.orion.lang.utils.Arrays1;
import com.orion.lang.utils.Exceptions;
import com.orion.office.excel.Excels;
import com.orion.office.excel.reader.BaseExcelReader;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class ExcelArrayReader
extends BaseExcelReader<Integer, String[]> {
    protected int[] columns;
    protected int columnSize;
    private String columnEmpty;
    private String[] emptyArray;

    public ExcelArrayReader(Workbook workbook, Sheet sheet) {
        this(workbook, sheet, (List<String[]>)new ArrayList<String[]>(), (Consumer<String[]>)null);
    }

    public ExcelArrayReader(Workbook workbook, Sheet sheet, List<String[]> store) {
        this(workbook, sheet, store, (Consumer<String[]>)null);
    }

    public ExcelArrayReader(Workbook workbook, Sheet sheet, Consumer<String[]> consumer) {
        this(workbook, sheet, (List<String[]>)null, consumer);
    }

    private ExcelArrayReader(Workbook workbook, Sheet sheet, List<String[]> store, Consumer<String[]> consumer) {
        super(workbook, sheet, store, consumer);
    }

    public static ExcelArrayReader create(Workbook workbook, Sheet sheet) {
        return new ExcelArrayReader(workbook, sheet);
    }

    public static ExcelArrayReader create(Workbook workbook, Sheet sheet, List<String[]> store) {
        return new ExcelArrayReader(workbook, sheet, store);
    }

    public static ExcelArrayReader create(Workbook workbook, Sheet sheet, Consumer<String[]> consumer) {
        return new ExcelArrayReader(workbook, sheet, consumer);
    }

    public ExcelArrayReader columnOfNull(String text) {
        this.columnEmpty = text;
        return this;
    }

    public ExcelArrayReader columnOfNullToEmpty() {
        this.columnEmpty = "";
        return this;
    }

    public ExcelArrayReader rowOfNullToEmpty() {
        this.emptyArray = new String[0];
        return this;
    }

    public ExcelArrayReader rowOfNullToEmpty(int length) {
        this.emptyArray = new String[length];
        return this;
    }

    public ExcelArrayReader rowOfNullToEmpty(String[] emptyArray) {
        this.emptyArray = emptyArray;
        return this;
    }

    public ExcelArrayReader columns(int ... columns) {
        this.columns = columns;
        this.columnSize = Arrays1.length((int[])columns);
        return this;
    }

    public ExcelArrayReader capacity(int capacity) {
        if (!Arrays1.isEmpty((int[])this.columns)) {
            throw Exceptions.unsupported((String)"if the column is set the capacity is not supported");
        }
        this.columnSize = capacity;
        return this;
    }

    @Override
    protected String[] parserRow(Row row) {
        if (row == null) {
            return this.emptyArray;
        }
        if (this.columnSize == 0) {
            this.columnSize = row.getLastCellNum();
        }
        String[] array = new String[this.columnSize];
        for (int i = 0; i < this.columnSize; ++i) {
            Cell cell = Arrays1.isEmpty((int[])this.columns) ? row.getCell(i) : row.getCell(this.columns[i]);
            if (cell == null) {
                array[i] = this.columnEmpty;
                continue;
            }
            String value = Excels.getCellValue(cell);
            array[i] = this.trim ? value.trim() : value;
        }
        return array;
    }

    public int getColumnSize() {
        return this.columnSize;
    }
}

