/*
 * Decompiled with CFR 0.152.
 */
package com.orion.office.excel.split;

import com.orion.lang.utils.Strings;
import com.orion.lang.utils.Valid;
import com.orion.lang.utils.io.Streams;
import com.orion.office.excel.Excels;
import com.orion.office.excel.split.ExcelColumnSplitSupport;
import com.orion.office.excel.writer.BaseExcelWriteable;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class ExcelColumnMultiSheetSplit
extends BaseExcelWriteable {
    private final Workbook sourceWorkbook;
    private Sheet sourceSheet;
    private int skip;
    private int sheetNum;

    public ExcelColumnMultiSheetSplit(Workbook sourceWorkbook, int sourceSheetIndex) {
        this(sourceWorkbook);
        Valid.gte((Comparable)Integer.valueOf(sourceSheetIndex), (Comparable)Integer.valueOf(0), (String)"split sheet index must >= 0", (Object[])new Object[0]);
        this.sourceSheet = sourceWorkbook.getSheetAt(sourceSheetIndex);
    }

    public ExcelColumnMultiSheetSplit(Workbook sourceWorkbook, String sourceSheetName) {
        this(sourceWorkbook);
        Valid.notBlank((String)sourceSheetName, (String)"split sheet name is null", (Object[])new Object[0]);
        this.sourceSheet = sourceWorkbook.getSheet(sourceSheetName);
    }

    public ExcelColumnMultiSheetSplit(Workbook sourceWorkbook, Sheet sourceSheet) {
        this(sourceWorkbook);
        this.sourceSheet = (Sheet)Valid.notNull((Object)sourceSheet, (String)"split sheet is null", (Object[])new Object[0]);
    }

    private ExcelColumnMultiSheetSplit(Workbook sourceWorkbook) {
        super((Workbook)new SXSSFWorkbook());
        this.sourceWorkbook = (Workbook)Valid.notNull((Object)sourceWorkbook, (String)"split workbook is null", (Object[])new Object[0]);
        Valid.isTrue((!Excels.isStreamingWorkbook(sourceWorkbook) ? 1 : 0) != 0, (String)"unsupported streaming reading, please use ExcelColumnSingleSplit", (Object[])new Object[0]);
    }

    public ExcelColumnMultiSheetSplit skip() {
        ++this.skip;
        return this;
    }

    public ExcelColumnMultiSheetSplit skip(int skip) {
        this.skip += skip;
        return this;
    }

    public ExcelColumnMultiSheetSplit split(int ... columns) {
        return this.split(columns, null, null);
    }

    public ExcelColumnMultiSheetSplit split(int[] columns, String[] headers) {
        return this.split(columns, headers, null);
    }

    public ExcelColumnMultiSheetSplit split(int[] columns, String password) {
        return this.split(columns, null, password);
    }

    public ExcelColumnMultiSheetSplit split(int[] columns, String[] headers, String password) {
        Sheet targetSheet = this.workbook.createSheet(this.sourceSheet.getSheetName() + ++this.sheetNum);
        ExcelColumnSplitSupport.split(this.sourceSheet, this.workbook, targetSheet, columns, headers, this.skip, false);
        if (!Strings.isBlank((String)password)) {
            targetSheet.protectSheet(password);
        }
        return this;
    }

    @Override
    public void close() {
        super.close();
        Streams.close((AutoCloseable)this.sourceWorkbook);
    }

    public Workbook getSourceWorkbook() {
        return this.sourceWorkbook;
    }

    public Sheet getSourceSheet() {
        return this.sourceSheet;
    }

    public Workbook getTargetWorkbook() {
        return this.workbook;
    }

    public int getSheetNum() {
        return this.sheetNum;
    }
}

