/*
 * Decompiled with CFR 0.152.
 */
package com.orion.office.excel.split;

import com.orion.lang.utils.Arrays1;
import com.orion.lang.utils.Valid;
import com.orion.lang.utils.io.Streams;
import com.orion.office.excel.Excels;
import com.orion.office.excel.split.ExcelColumnSplitSupport;
import com.orion.office.excel.writer.BaseExcelWriteable;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class ExcelColumnSingleSplit
extends BaseExcelWriteable {
    private final Workbook sourceWorkbook;
    public Sheet sourceSheet;
    public Sheet targetSheet;
    private int skip;
    private String[] headers;
    private final int[] columns;
    private final boolean streaming;

    public ExcelColumnSingleSplit(Workbook sourceWorkbook, Sheet sourceSheet, int ... columns) {
        super((Workbook)new SXSSFWorkbook());
        this.sourceWorkbook = (Workbook)Valid.notNull((Object)sourceWorkbook, (String)"split workbook is null", (Object[])new Object[0]);
        this.sourceSheet = (Sheet)Valid.notNull((Object)sourceSheet, (String)"split sheet is null", (Object[])new Object[0]);
        Valid.isTrue((!Arrays1.isEmpty((int[])columns) ? 1 : 0) != 0, (String)"split columns is empty", (Object[])new Object[0]);
        this.targetSheet = this.workbook.createSheet(sourceSheet.getSheetName());
        this.columns = columns;
        this.streaming = Excels.isStreamingSheet(sourceSheet);
    }

    public ExcelColumnSingleSplit skip() {
        ++this.skip;
        return this;
    }

    public ExcelColumnSingleSplit skip(int skip) {
        this.skip += skip;
        return this;
    }

    public ExcelColumnSingleSplit header(String ... headers) {
        this.headers = headers;
        return this;
    }

    public ExcelColumnSingleSplit split() {
        ExcelColumnSplitSupport.split(this.sourceSheet, this.workbook, this.targetSheet, this.columns, this.headers, this.skip, this.streaming);
        return this;
    }

    public ExcelColumnSingleSplit protect(String password) {
        this.targetSheet.protectSheet(password);
        return this;
    }

    @Override
    public void close() {
        super.close();
        Streams.close((AutoCloseable)this.sourceWorkbook);
    }

    public Workbook getSourceWorkbook() {
        return this.sourceWorkbook;
    }

    public Sheet getSourceSheet() {
        return this.sourceSheet;
    }

    public Workbook getTargetWorkbook() {
        return this.workbook;
    }

    public Sheet getTargetSheet() {
        return this.targetSheet;
    }

    public int[] getColumns() {
        return this.columns;
    }
}

