/*
 * Decompiled with CFR 0.152.
 */
package com.orion.office.excel.split;

import com.orion.lang.utils.Arrays1;
import com.orion.lang.utils.Exceptions;
import com.orion.lang.utils.Valid;
import com.orion.lang.utils.io.Streams;
import com.orion.office.excel.Excels;
import com.orion.office.support.SplitTargetGenerator;
import java.util.Iterator;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class ExcelRowSplit
extends SplitTargetGenerator {
    public Sheet sheet;
    private final int limit;
    private int skip;
    private final boolean streaming;
    private String[] header;
    private int[] columns;
    private int columnSize;
    private String password;
    private Workbook currentWorkbook;
    private Sheet currentSheet;
    private int currentIndex;
    private boolean end;

    public ExcelRowSplit(Sheet sheet, int limit) {
        this.sheet = (Sheet)Valid.notNull((Object)sheet, (String)"split sheet is null", (Object[])new Object[0]);
        Valid.lte((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(limit), (String)"limit not be lte 0", (Object[])new Object[0]);
        this.columnSize = 32;
        this.limit = limit;
        this.streaming = Excels.isStreamingSheet(sheet);
        this.suffix = "xlsx";
    }

    public ExcelRowSplit protect(String password) {
        this.password = password;
        return this;
    }

    public ExcelRowSplit skip() {
        ++this.skip;
        return this;
    }

    public ExcelRowSplit skip(int skip) {
        this.skip += skip;
        return this;
    }

    public ExcelRowSplit columns(int ... columns) {
        if (!Arrays1.isEmpty((int[])columns)) {
            this.columns = columns;
            this.columnSize = Arrays1.max((int[])columns) + 1;
        }
        return this;
    }

    public ExcelRowSplit columnSize(int columnSize) {
        if (Arrays1.isEmpty((int[])this.columns)) {
            this.columnSize = columnSize;
        }
        return this;
    }

    public ExcelRowSplit header(String ... header) {
        this.header = header;
        return this;
    }

    public ExcelRowSplit split() {
        Iterator iterator = this.sheet.iterator();
        for (int j = 0; j < this.skip; ++j) {
            if (!iterator.hasNext()) {
                this.end = true;
                return this;
            }
            iterator.next();
        }
        do {
            if (!super.hasNext()) {
                this.end = true;
                return this;
            }
            this.nextWorkbook();
            int border = this.limit;
            if (!Arrays1.isEmpty((Object[])this.header)) {
                border = this.limit + 1;
            }
            while (iterator.hasNext()) {
                this.addRow(this.currentIndex++, (Row)iterator.next());
                if (this.currentIndex != border) continue;
            }
            if (this.currentIndex == 0) {
                this.end = true;
                break;
            }
            super.next();
            if (this.currentIndex < border) {
                this.end = true;
            }
            this.write();
        } while (!this.end);
        return this;
    }

    private void addRow(int rowIndex, Row row) {
        Row target = this.currentSheet.createRow(rowIndex);
        if (!this.streaming) {
            target.setHeightInPoints(this.sheet.getDefaultRowHeightInPoints());
        }
        int i = 0;
        if (Arrays1.isEmpty((int[])this.columns)) {
            for (Cell cell : row) {
                this.setCellValue(cell, target.createCell(i++));
            }
        } else {
            for (int col : this.columns) {
                this.setCellValue(row.getCell(col), target.createCell(i++));
            }
        }
    }

    private void setCellValue(Cell sourceCell, Cell targetCell) {
        if (!this.streaming) {
            CellStyle targetStyle = this.currentWorkbook.createCellStyle();
            targetStyle.cloneStyleFrom(sourceCell.getCellStyle());
            targetCell.setCellStyle(targetStyle);
        }
        Excels.copyCellValue(sourceCell, targetCell);
    }

    private void nextWorkbook() {
        this.currentIndex = 0;
        this.currentWorkbook = new SXSSFWorkbook();
        this.currentSheet = this.currentWorkbook.createSheet(this.sheet.getSheetName());
        if (!this.streaming) {
            for (int i = 0; i < this.columnSize; ++i) {
                this.currentSheet.setColumnWidth(i, this.sheet.getColumnWidth(i));
                this.currentSheet.setDefaultColumnStyle(i, this.sheet.getColumnStyle(i));
            }
            this.currentSheet.setDefaultColumnWidth(this.sheet.getDefaultColumnWidth());
            this.currentSheet.setDefaultRowHeightInPoints(this.sheet.getDefaultRowHeightInPoints());
        }
        if (!Arrays1.isEmpty((Object[])this.header)) {
            Row headerRow = this.currentSheet.createRow(0);
            for (int headerIndex = 0; headerIndex < this.header.length; ++headerIndex) {
                Cell headerRowCell = headerRow.createCell(headerIndex);
                headerRowCell.setCellValue(this.header[headerIndex]);
            }
            this.currentIndex = 1;
        }
    }

    private void write() {
        try {
            if (this.password != null && !this.streaming) {
                this.currentSheet.protectSheet(this.password);
            }
            Excels.setDefaultProperties(this.currentWorkbook);
            this.currentWorkbook.write(this.currentOutputStream);
            Streams.close((AutoCloseable)this.currentWorkbook);
            if (this.autoClose) {
                Streams.close((AutoCloseable)this.currentOutputStream);
            }
        }
        catch (Exception e) {
            throw Exceptions.ioRuntime((Throwable)e);
        }
    }

    public Sheet getSheet() {
        return this.sheet;
    }

    public int getLimit() {
        return this.limit;
    }
}

