/*
 * Decompiled with CFR 0.152.
 */
package com.orion.office.excel.style;

import com.orion.office.excel.option.PrintOption;
import com.orion.office.excel.type.ExcelMarginType;
import com.orion.office.excel.type.ExcelPaperType;
import org.apache.poi.ss.usermodel.PaperSize;
import org.apache.poi.ss.usermodel.PrintSetup;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;

public class PrintStream {
    private final Sheet sheet;
    private final PrintSetup printSetup;

    public PrintStream(Sheet sheet) {
        this.sheet = sheet;
        this.printSetup = sheet.getPrintSetup();
    }

    public static PrintStream stream(Sheet sheet) {
        return new PrintStream(sheet);
    }

    public static PrintSetup parsePrint(Sheet sheet, PrintOption option) {
        int[] repeat;
        Integer limit;
        Integer copies;
        Integer pageStart;
        Double footerMargin;
        Double headerMargin;
        Double bottomMargin;
        Double topMargin;
        Double rightMargin;
        Double leftMargin;
        Integer height;
        Integer width;
        Integer verticalResolution;
        Integer horizontalResolution;
        PrintStream stream = new PrintStream(sheet).printGridLines(option.isPrintGridLines()).printRowHeading(option.isPrintRowHeading()).autoLimit(option.isAutoLimit()).fit(option.isFit()).color(option.isColor()).landScapePrint(option.isLandScapePrint()).printOrientation(option.isSetPrintOrientation()).scale(option.getScale()).notes(option.isNotes()).usePage(option.isUsePage()).draft(option.isDraft()).topToBottomOrder(option.isTopToBottom()).horizontallyCenter(option.isHorizontallyCenter()).verticallyCenter(option.isVerticallyCenter());
        ExcelPaperType paper = option.getPaper();
        if (paper != null) {
            stream.paper(paper.getCode());
        }
        if ((horizontalResolution = option.getHorizontalResolution()) != null) {
            stream.horizontalResolution(horizontalResolution);
        }
        if ((verticalResolution = option.getVerticalResolution()) != null) {
            stream.verticalResolution(verticalResolution);
        }
        if ((width = option.getWidth()) != null) {
            stream.width(width);
        }
        if ((height = option.getHeight()) != null) {
            stream.height(height);
        }
        if ((leftMargin = option.getLeftMargin()) != null) {
            stream.margin(ExcelMarginType.LEFT, (double)leftMargin);
        }
        if ((rightMargin = option.getRightMargin()) != null) {
            stream.margin(ExcelMarginType.RIGHT, (double)rightMargin);
        }
        if ((topMargin = option.getTopMargin()) != null) {
            stream.margin(ExcelMarginType.TOP, (double)topMargin);
        }
        if ((bottomMargin = option.getBottomMargin()) != null) {
            stream.margin(ExcelMarginType.BOTTOM, (double)bottomMargin);
        }
        if ((headerMargin = option.getHeaderMargin()) != null) {
            stream.margin(ExcelMarginType.HEADER, (double)headerMargin);
        }
        if ((footerMargin = option.getFooterMargin()) != null) {
            stream.margin(ExcelMarginType.FOOTER, (double)footerMargin);
        }
        if ((pageStart = option.getPageStart()) != null) {
            stream.pageStart(pageStart);
        }
        if ((copies = option.getCopies()) != null) {
            stream.copies(copies);
        }
        if ((limit = option.getLimit()) != null) {
            stream.autoLimit(true);
            stream.limit(limit);
        }
        if ((repeat = option.getRepeat()) != null) {
            stream.repeat(repeat);
        }
        return stream.getPrintSetup();
    }

    public PrintStream printGridLines() {
        this.sheet.setPrintGridlines(true);
        return this;
    }

    public PrintStream printGridLines(boolean print) {
        this.sheet.setPrintGridlines(print);
        return this;
    }

    public PrintStream unPrintGridLines() {
        this.sheet.setPrintGridlines(false);
        return this;
    }

    public PrintStream printRowHeading() {
        this.sheet.setPrintRowAndColumnHeadings(true);
        return this;
    }

    public PrintStream printRowHeading(boolean print) {
        this.sheet.setPrintRowAndColumnHeadings(print);
        return this;
    }

    public PrintStream unPrintHeading() {
        this.sheet.setPrintRowAndColumnHeadings(false);
        return this;
    }

    public PrintStream fit() {
        this.sheet.setFitToPage(true);
        return this;
    }

    public PrintStream fit(boolean fit) {
        this.sheet.setFitToPage(fit);
        return this;
    }

    public PrintStream unFit() {
        this.sheet.setFitToPage(false);
        return this;
    }

    public PrintStream autoLimit() {
        this.sheet.setAutobreaks(true);
        return this;
    }

    public PrintStream autoLimit(boolean auto) {
        this.sheet.setAutobreaks(auto);
        return this;
    }

    public PrintStream unAutoLimit() {
        this.sheet.setAutobreaks(false);
        return this;
    }

    public PrintStream limit(int limit) {
        this.sheet.setRowBreak(limit);
        return this;
    }

    public PrintStream horizontallyCenter() {
        this.sheet.setHorizontallyCenter(true);
        return this;
    }

    public PrintStream horizontallyCenter(boolean center) {
        this.sheet.setHorizontallyCenter(center);
        return this;
    }

    public PrintStream unHorizontallyCenter() {
        this.sheet.setHorizontallyCenter(false);
        return this;
    }

    public PrintStream verticallyCenter() {
        this.sheet.setVerticallyCenter(true);
        return this;
    }

    public PrintStream verticallyCenter(boolean center) {
        this.sheet.setVerticallyCenter(center);
        return this;
    }

    public PrintStream unVerticallyCenter() {
        this.sheet.setVerticallyCenter(false);
        return this;
    }

    public PrintStream repeat(int[] repeat) {
        if (repeat == null) {
            return this;
        }
        if (repeat.length == 2) {
            return this.repeat(repeat[0], repeat[1]);
        }
        if (repeat.length == 4) {
            return this.repeat(repeat[0], repeat[1], repeat[2], repeat[3]);
        }
        return this;
    }

    public PrintStream repeat(int rowEndIndex, int columnEndIndex) {
        this.sheet.setRepeatingRows(new CellRangeAddress(0, rowEndIndex, 0, 0));
        this.sheet.setRepeatingColumns(new CellRangeAddress(0, 0, 0, columnEndIndex));
        return this;
    }

    public PrintStream repeat(int rowStartIndex, int rowEndIndex, int columnStartIndex, int columnEndIndex) {
        this.sheet.setRepeatingRows(new CellRangeAddress(rowStartIndex, rowEndIndex, 0, 0));
        this.sheet.setRepeatingColumns(new CellRangeAddress(0, 0, columnStartIndex, columnEndIndex));
        return this;
    }

    public PrintStream paper(int i) {
        this.printSetup.setPaperSize((short)i);
        return this;
    }

    public PrintStream paper(PaperSize s) {
        this.printSetup.setPaperSize((short)(s.ordinal() + 1));
        return this;
    }

    public PrintStream paper(ExcelPaperType type) {
        this.printSetup.setPaperSize((short)type.getCode());
        return this;
    }

    public PrintStream color() {
        this.printSetup.setNoColor(false);
        return this;
    }

    public PrintStream color(boolean color) {
        this.printSetup.setNoColor(!color);
        return this;
    }

    public PrintStream noColor() {
        this.printSetup.setNoColor(true);
        return this;
    }

    public PrintStream landScapePrint() {
        this.printSetup.setLandscape(true);
        return this;
    }

    public PrintStream landScapePrint(boolean landScape) {
        this.printSetup.setLandscape(landScape);
        return this;
    }

    public PrintStream portraitPrint() {
        this.printSetup.setLandscape(false);
        return this;
    }

    public PrintStream portraitPrint(boolean portrait) {
        this.printSetup.setLandscape(portrait);
        return this;
    }

    public PrintStream printOrientation(boolean set) {
        this.printSetup.setNoOrientation(!set);
        return this;
    }

    public PrintStream setPrintOrientation() {
        this.printSetup.setNoOrientation(false);
        return this;
    }

    public PrintStream unsetPrintOrientation() {
        this.printSetup.setNoOrientation(true);
        return this;
    }

    public PrintStream scale(int scale) {
        this.printSetup.setScale((short)scale);
        return this;
    }

    public PrintStream notes() {
        this.printSetup.setNotes(true);
        return this;
    }

    public PrintStream unNotes() {
        this.printSetup.setNotes(false);
        return this;
    }

    public PrintStream notes(boolean print) {
        this.printSetup.setNotes(print);
        return this;
    }

    public PrintStream horizontalResolution(int dpi) {
        this.printSetup.setHResolution((short)dpi);
        return this;
    }

    public PrintStream verticalResolution(int dpi) {
        this.printSetup.setVResolution((short)dpi);
        return this;
    }

    public PrintStream width(int width) {
        this.printSetup.setFitWidth((short)width);
        return this;
    }

    public PrintStream height(int height) {
        this.printSetup.setFitHeight((short)height);
        return this;
    }

    public PrintStream leftMargin(double margin) {
        return this.margin(ExcelMarginType.LEFT, margin);
    }

    public PrintStream rightMargin(double margin) {
        return this.margin(ExcelMarginType.RIGHT, margin);
    }

    public PrintStream topMargin(double margin) {
        return this.margin(ExcelMarginType.TOP, margin);
    }

    public PrintStream bottomMargin(double margin) {
        return this.margin(ExcelMarginType.BOTTOM, margin);
    }

    public PrintStream headerMargin(double margin) {
        return this.margin(ExcelMarginType.HEADER, margin);
    }

    public PrintStream footerMargin(double margin) {
        return this.margin(ExcelMarginType.FOOTER, margin);
    }

    public PrintStream margin(ExcelMarginType type, double margin) {
        this.sheet.setMargin(type.getCode(), margin);
        return this;
    }

    public PrintStream margin(short type, double margin) {
        this.sheet.setMargin(type, margin);
        return this;
    }

    public PrintStream usePage() {
        this.printSetup.setUsePage(true);
        return this;
    }

    public PrintStream usePage(boolean use) {
        this.printSetup.setUsePage(use);
        return this;
    }

    public PrintStream unUsePage() {
        this.printSetup.setUsePage(false);
        return this;
    }

    public PrintStream pageStart(int page) {
        this.printSetup.setUsePage(true);
        this.printSetup.setPageStart((short)page);
        return this;
    }

    public PrintStream copies(int i) {
        this.printSetup.setCopies((short)i);
        return this;
    }

    public PrintStream draft() {
        this.printSetup.setDraft(true);
        return this;
    }

    public PrintStream draft(boolean use) {
        this.printSetup.setDraft(use);
        return this;
    }

    public PrintStream unsetDraft() {
        this.printSetup.setDraft(false);
        return this;
    }

    public PrintStream leftToRightOrder() {
        this.printSetup.setLeftToRight(true);
        return this;
    }

    public PrintStream leftToRightOrder(boolean left) {
        this.printSetup.setLeftToRight(left);
        return this;
    }

    public PrintStream topToBottomOrder() {
        this.printSetup.setLeftToRight(false);
        return this;
    }

    public PrintStream topToBottomOrder(boolean top) {
        this.printSetup.setLeftToRight(top);
        return this;
    }

    public int getPaper() {
        return this.printSetup.getPaperSize();
    }

    public boolean isColor() {
        return !this.printSetup.getNoColor();
    }

    public boolean isNoColor() {
        return this.printSetup.getNoColor();
    }

    public int getOrientation() {
        return this.printSetup.getNoOrientation() ? 1 : (this.printSetup.getLandscape() ? 3 : 2);
    }

    public int getScale() {
        return this.printSetup.getScale();
    }

    public boolean isPrintNotes() {
        return this.printSetup.getNotes();
    }

    public int getHorizontalResolution() {
        return this.printSetup.getHResolution();
    }

    public int getVerticalResolution() {
        return this.printSetup.getVResolution();
    }

    public int getWidth() {
        return this.printSetup.getFitWidth();
    }

    public int getHeight() {
        return this.printSetup.getFitHeight();
    }

    public double getLeftMargin() {
        return this.getMargin(ExcelMarginType.LEFT);
    }

    public double getRightMargin() {
        return this.getMargin(ExcelMarginType.RIGHT);
    }

    public double getTopMargin() {
        return this.getMargin(ExcelMarginType.TOP);
    }

    public double getBottomMargin() {
        return this.getMargin(ExcelMarginType.BOTTOM);
    }

    public double getMargin(ExcelMarginType type) {
        return this.sheet.getMargin(type.getCode());
    }

    public double getMargin(int type) {
        return this.sheet.getMargin((short)type);
    }

    public boolean getUsePage() {
        return this.printSetup.getUsePage();
    }

    public int getPageStart() {
        return this.printSetup.getPageStart();
    }

    public int getCopies() {
        return this.printSetup.getCopies();
    }

    public boolean isDraft() {
        return this.printSetup.getDraft();
    }

    public int getPrintOrder() {
        return this.printSetup.getLeftToRight() ? 0 : 1;
    }

    public boolean isValid() {
        return this.printSetup.getValidSettings();
    }

    public boolean isAutoLimit() {
        return this.sheet.getAutobreaks();
    }

    public boolean isFit() {
        return this.sheet.getFitToPage();
    }

    public boolean isHorizontallyCenter() {
        return this.sheet.getHorizontallyCenter();
    }

    public boolean isVerticallyCenter() {
        return this.sheet.getVerticallyCenter();
    }

    public int[] getRepeat() {
        CellRangeAddress columns;
        int[] r = new int[4];
        CellRangeAddress rows = this.sheet.getRepeatingRows();
        if (rows != null) {
            r[0] = rows.getFirstRow();
            r[1] = rows.getLastRow();
        }
        if ((columns = this.sheet.getRepeatingColumns()) != null) {
            r[2] = columns.getFirstColumn();
            r[3] = columns.getLastColumn();
        }
        return r;
    }

    public boolean isPrintGridLines() {
        return this.sheet.isPrintGridlines();
    }

    public boolean isPrintHeadings() {
        return this.sheet.isPrintRowAndColumnHeadings();
    }

    public Sheet getSheet() {
        return this.sheet;
    }

    public PrintSetup getPrintSetup() {
        return this.printSetup;
    }
}

