/*
 * Decompiled with CFR 0.152.
 */
package com.orion.office.excel.style;

import com.orion.lang.utils.Colors;
import com.orion.lang.utils.Strings;
import com.orion.office.excel.Excels;
import com.orion.office.excel.option.ExportFieldOption;
import com.orion.office.excel.option.TitleOption;
import com.orion.office.excel.style.FontStream;
import com.orion.office.excel.type.ExcelAlignType;
import com.orion.office.excel.type.ExcelVerticalAlignType;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.ReadingOrder;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class StyleStream {
    private final Workbook workbook;
    private final CellStyle style;

    public StyleStream(Workbook workbook) {
        this.workbook = workbook;
        this.style = workbook.createCellStyle();
    }

    public StyleStream(Workbook workbook, CellStyle style) {
        this.workbook = workbook;
        this.style = style;
    }

    public static StyleStream styleStream(Workbook workbook) {
        return new StyleStream(workbook);
    }

    public static StyleStream styleStream(Workbook workbook, CellStyle style) {
        return new StyleStream(workbook, style);
    }

    public static CellStyle parseStyle(Workbook workbook, ExportFieldOption option) {
        if (option == null) {
            return null;
        }
        StyleStream stream = new StyleStream(workbook);
        if (option.getAlign() != null && !option.getAlign().equals((Object)ExcelAlignType.DEFAULT)) {
            stream.alignment(option.getAlign().getCode());
        }
        if (option.getVerticalAlign() != null && !option.getVerticalAlign().equals((Object)ExcelVerticalAlignType.DEFAULT)) {
            stream.verticalAlignment(option.getVerticalAlign().getCode());
        }
        stream.wrapText(option.isWrapText());
        stream.lock(option.isLock());
        stream.autoResize(option.isAutoResize());
        String backgroundColor = option.getBackgroundColor();
        if (!Strings.isEmpty((CharSequence)backgroundColor)) {
            stream.texture(FillPatternType.SOLID_FOREGROUND.getCode());
            if (workbook instanceof XSSFWorkbook || workbook instanceof SXSSFWorkbook) {
                stream.textureColor(backgroundColor);
            } else if (workbook instanceof HSSFWorkbook) {
                short paletteColorIndex = option.getPaletteColorIndex();
                short usePaletteColorIndex = Excels.paletteColor(workbook, paletteColorIndex, Colors.toRgb((String)backgroundColor));
                stream.textureColor(usePaletteColorIndex);
                if (paletteColorIndex == usePaletteColorIndex) {
                    paletteColorIndex = (short)(paletteColorIndex + 1);
                    option.setPaletteColorIndex(paletteColorIndex);
                }
            }
        }
        if (option.getBorder() != null) {
            stream.border(option.getBorder().getCode());
            String borderColor = option.getBorderColor();
            if (!Strings.isEmpty((CharSequence)borderColor)) {
                if (workbook instanceof XSSFWorkbook || workbook instanceof SXSSFWorkbook) {
                    stream.borderColor(borderColor);
                } else if (workbook instanceof HSSFWorkbook) {
                    short paletteColorIndex = option.getPaletteColorIndex();
                    short usePaletteColorIndex = Excels.paletteColor(workbook, paletteColorIndex, Colors.toRgb((String)borderColor));
                    stream.borderColor(usePaletteColorIndex);
                    if (paletteColorIndex == usePaletteColorIndex) {
                        paletteColorIndex = (short)(paletteColorIndex + 1);
                        option.setPaletteColorIndex(paletteColorIndex);
                    }
                }
            }
        }
        return stream.getStyle();
    }

    public static CellStyle parseColumnStyle(Workbook workbook, ExportFieldOption option) {
        CellStyle style = StyleStream.parseStyle(workbook, option);
        if (style == null) {
            return null;
        }
        if (!Strings.isEmpty((CharSequence)option.getFormat())) {
            style.setDataFormat(workbook.createDataFormat().getFormat(option.getFormat()));
        }
        if (option.getIndent() != null) {
            style.setIndention(option.getIndent().shortValue());
        }
        if (option.isQuotePrefixed()) {
            style.setQuotePrefixed(true);
        }
        return style;
    }

    public static CellStyle parseTitleStyle(Workbook workbook, TitleOption option) {
        if (option == null) {
            return null;
        }
        ExportFieldOption exportFieldOption = new ExportFieldOption();
        exportFieldOption.setAlign(option.getAlign());
        exportFieldOption.setVerticalAlign(option.getVerticalAlign());
        exportFieldOption.setBackgroundColor(option.getBackgroundColor());
        exportFieldOption.setBorder(option.getBorder());
        exportFieldOption.setBorderColor(option.getBorderColor());
        exportFieldOption.setPaletteColorIndex(option.getPaletteColorIndex());
        CellStyle cellStyle = StyleStream.parseStyle(workbook, exportFieldOption);
        option.setPaletteColorIndex(exportFieldOption.getPaletteColorIndex());
        return cellStyle;
    }

    public StyleStream font(Font font) {
        this.style.setFont(font);
        return this;
    }

    public StyleStream font(FontStream font) {
        this.style.setFont(font.getFont());
        return this;
    }

    public StyleStream wrapText() {
        this.style.setWrapText(true);
        return this;
    }

    public StyleStream unsetWrapText() {
        this.style.setWrapText(false);
        return this;
    }

    public StyleStream wrapText(boolean wrap) {
        this.style.setWrapText(wrap);
        return this;
    }

    public StyleStream alignment(int code) {
        this.style.setAlignment(HorizontalAlignment.forInt((int)code));
        return this;
    }

    public StyleStream defaultAlignment() {
        this.style.setAlignment(HorizontalAlignment.forInt((int)0));
        return this;
    }

    public StyleStream leftAlignment() {
        this.style.setAlignment(HorizontalAlignment.forInt((int)1));
        return this;
    }

    public StyleStream centerAlignment() {
        this.style.setAlignment(HorizontalAlignment.forInt((int)2));
        return this;
    }

    public StyleStream rightAlignment() {
        this.style.setAlignment(HorizontalAlignment.forInt((int)3));
        return this;
    }

    public StyleStream fillAlignment() {
        this.style.setAlignment(HorizontalAlignment.forInt((int)5));
        return this;
    }

    public StyleStream verticalAlignment(int code) {
        this.style.setVerticalAlignment(VerticalAlignment.forInt((int)code));
        return this;
    }

    public StyleStream topVerticalAlignment() {
        this.style.setVerticalAlignment(VerticalAlignment.forInt((int)0));
        return this;
    }

    public StyleStream centerVerticalAlignment() {
        this.style.setVerticalAlignment(VerticalAlignment.forInt((int)1));
        return this;
    }

    public StyleStream bottomVerticalAlignment() {
        this.style.setVerticalAlignment(VerticalAlignment.forInt((int)2));
        return this;
    }

    public StyleStream lock() {
        this.style.setLocked(true);
        return this;
    }

    public StyleStream unlock() {
        this.style.setLocked(false);
        return this;
    }

    public StyleStream lock(boolean lock) {
        this.style.setLocked(lock);
        return this;
    }

    public StyleStream hidden() {
        this.style.setHidden(true);
        return this;
    }

    public StyleStream hidden(boolean hidden) {
        this.style.setHidden(hidden);
        return this;
    }

    public StyleStream show() {
        this.style.setHidden(false);
        return this;
    }

    public StyleStream show(boolean show) {
        this.style.setHidden(show);
        return this;
    }

    public StyleStream indention(int i) {
        this.style.setIndention((short)i);
        return this;
    }

    public StyleStream rotation(int i) {
        this.style.setRotation((short)i);
        return this;
    }

    public StyleStream quotePrefixed() {
        this.style.setQuotePrefixed(true);
        return this;
    }

    public StyleStream unsetQuotePrefixed() {
        this.style.setQuotePrefixed(false);
        return this;
    }

    public StyleStream quotePrefixed(boolean set) {
        this.style.setQuotePrefixed(set);
        return this;
    }

    public StyleStream autoResize() {
        this.style.setShrinkToFit(true);
        return this;
    }

    public StyleStream unsetAutoResize() {
        this.style.setShrinkToFit(false);
        return this;
    }

    public StyleStream autoResize(boolean set) {
        this.style.setShrinkToFit(set);
        return this;
    }

    public StyleStream dataFormat(int index) {
        this.style.setDataFormat((short)index);
        return this;
    }

    public StyleStream dataFormat(String format) {
        this.style.setDataFormat(this.workbook.createDataFormat().getFormat(format));
        return this;
    }

    public StyleStream unsetReadingOrder() {
        if (this.style instanceof XSSFCellStyle) {
            ((XSSFCellStyle)this.style).setReadingOrder(ReadingOrder.CONTEXT);
        }
        return this;
    }

    public StyleStream leftReading() {
        if (this.style instanceof XSSFCellStyle) {
            ((XSSFCellStyle)this.style).setReadingOrder(ReadingOrder.LEFT_TO_RIGHT);
        }
        return this;
    }

    public StyleStream rightReading() {
        if (this.style instanceof XSSFCellStyle) {
            ((XSSFCellStyle)this.style).setReadingOrder(ReadingOrder.RIGHT_TO_LEFT);
        }
        return this;
    }

    public StyleStream unsetTexture() {
        this.style.setFillPattern(FillPatternType.forInt((int)0));
        return this;
    }

    public StyleStream texture(int i) {
        this.style.setFillPattern(FillPatternType.forInt((int)i));
        return this;
    }

    public StyleStream textureColor(int i) {
        this.style.setFillForegroundColor((short)i);
        return this;
    }

    public StyleStream textureColor(byte[] rgb) {
        if (this.style instanceof XSSFCellStyle) {
            ((XSSFCellStyle)this.style).setFillForegroundColor(new XSSFColor(rgb, null));
        }
        return this;
    }

    public StyleStream textureColor(String c) {
        if (this.style instanceof XSSFCellStyle) {
            ((XSSFCellStyle)this.style).setFillForegroundColor(new XSSFColor(Colors.toRgb((String)c), null));
        }
        return this;
    }

    public StyleStream textureColor(short index, byte[] rgb) {
        if (this.workbook instanceof HSSFWorkbook) {
            this.style.setFillForegroundColor(Excels.paletteColor(this.workbook, index, rgb));
        }
        return this;
    }

    public StyleStream textureColor(short index, String c) {
        if (this.workbook instanceof HSSFWorkbook) {
            this.style.setFillForegroundColor(Excels.paletteColor(this.workbook, index, c));
        }
        return this;
    }

    public StyleStream blueTextureColor() {
        this.style.setFillForegroundColor(HSSFColor.HSSFColorPredefined.BLUE.getIndex());
        return this;
    }

    public StyleStream blackTextureColor() {
        this.style.setFillForegroundColor(HSSFColor.HSSFColorPredefined.BLACK.getIndex());
        return this;
    }

    public StyleStream redTextureColor() {
        this.style.setFillForegroundColor(HSSFColor.HSSFColorPredefined.RED.getIndex());
        return this;
    }

    public StyleStream pinkTextureColor() {
        this.style.setFillForegroundColor(HSSFColor.HSSFColorPredefined.PINK.getIndex());
        return this;
    }

    public StyleStream indigoTextureColor() {
        this.style.setFillForegroundColor(HSSFColor.HSSFColorPredefined.INDIGO.getIndex());
        return this;
    }

    public StyleStream textureBackgroundColor(int i) {
        this.style.setFillBackgroundColor((short)i);
        return this;
    }

    public StyleStream textureBackgroundColor(byte[] rgb) {
        if (this.style instanceof XSSFCellStyle) {
            ((XSSFCellStyle)this.style).setFillBackgroundColor(new XSSFColor(rgb, null));
        }
        return this;
    }

    public StyleStream textureBackgroundColor(String c) {
        if (this.style instanceof XSSFCellStyle) {
            ((XSSFCellStyle)this.style).setFillBackgroundColor(new XSSFColor(Colors.toRgb((String)c), null));
        }
        return this;
    }

    public StyleStream textureBackgroundColor(short index, byte[] rgb) {
        if (this.workbook instanceof HSSFWorkbook) {
            this.style.setFillBackgroundColor(Excels.paletteColor(this.workbook, index, rgb));
        }
        return this;
    }

    public StyleStream textureBackgroundColor(short index, String c) {
        if (this.workbook instanceof HSSFWorkbook) {
            this.style.setFillBackgroundColor(Excels.paletteColor(this.workbook, index, c));
        }
        return this;
    }

    public StyleStream blueTextureBackgroundColor() {
        this.style.setFillBackgroundColor(HSSFColor.HSSFColorPredefined.BLUE.getIndex());
        return this;
    }

    public StyleStream blackTextureBackgroundColor() {
        this.style.setFillBackgroundColor(HSSFColor.HSSFColorPredefined.BLACK.getIndex());
        return this;
    }

    public StyleStream redTextureBackgroundColor() {
        this.style.setFillBackgroundColor(HSSFColor.HSSFColorPredefined.RED.getIndex());
        return this;
    }

    public StyleStream pinkTextureBackgroundColor() {
        this.style.setFillBackgroundColor(HSSFColor.HSSFColorPredefined.PINK.getIndex());
        return this;
    }

    public StyleStream indigoTextureBackgroundColor() {
        this.style.setFillBackgroundColor(HSSFColor.HSSFColorPredefined.INDIGO.getIndex());
        return this;
    }

    public StyleStream unsetBorder() {
        return this.border(0);
    }

    public StyleStream solidBorder() {
        return this.border(1);
    }

    public StyleStream dashedBorder() {
        return this.border(3);
    }

    public StyleStream border(int i) {
        this.style.setBorderTop(BorderStyle.valueOf((short)((short)i)));
        this.style.setBorderLeft(BorderStyle.valueOf((short)((short)i)));
        this.style.setBorderBottom(BorderStyle.valueOf((short)((short)i)));
        this.style.setBorderRight(BorderStyle.valueOf((short)((short)i)));
        return this;
    }

    public StyleStream borderColor(int i) {
        this.style.setTopBorderColor((short)i);
        this.style.setLeftBorderColor((short)i);
        this.style.setBottomBorderColor((short)i);
        this.style.setRightBorderColor((short)i);
        return this;
    }

    public StyleStream borderColor(byte[] rgb) {
        if (this.style instanceof XSSFCellStyle) {
            XSSFColor color = new XSSFColor(rgb, null);
            ((XSSFCellStyle)this.style).setTopBorderColor(color);
            ((XSSFCellStyle)this.style).setLeftBorderColor(color);
            ((XSSFCellStyle)this.style).setBottomBorderColor(color);
            ((XSSFCellStyle)this.style).setRightBorderColor(color);
        }
        return this;
    }

    public StyleStream borderColor(String c) {
        if (this.style instanceof XSSFCellStyle) {
            XSSFColor color = new XSSFColor(Colors.toColor((String)c), null);
            ((XSSFCellStyle)this.style).setTopBorderColor(color);
            ((XSSFCellStyle)this.style).setLeftBorderColor(color);
            ((XSSFCellStyle)this.style).setBottomBorderColor(color);
            ((XSSFCellStyle)this.style).setRightBorderColor(color);
        }
        return this;
    }

    public StyleStream borderColor(short index, byte[] rgb) {
        if (this.workbook instanceof HSSFWorkbook) {
            short ci = Excels.paletteColor(this.workbook, index, rgb);
            this.style.setTopBorderColor(ci);
            this.style.setLeftBorderColor(ci);
            this.style.setBottomBorderColor(ci);
            this.style.setRightBorderColor(ci);
        }
        return this;
    }

    public StyleStream borderColor(short index, String c) {
        if (this.workbook instanceof HSSFWorkbook) {
            short ci = Excels.paletteColor(this.workbook, index, c);
            this.style.setTopBorderColor(ci);
            this.style.setLeftBorderColor(ci);
            this.style.setBottomBorderColor(ci);
            this.style.setRightBorderColor(ci);
        }
        return this;
    }

    public StyleStream blueBorderColor() {
        return this.borderColor(HSSFColor.HSSFColorPredefined.BLUE.getIndex());
    }

    public StyleStream blackBorderColor() {
        return this.borderColor(HSSFColor.HSSFColorPredefined.BLACK.getIndex());
    }

    public StyleStream redBorderColor() {
        return this.borderColor(HSSFColor.HSSFColorPredefined.RED.getIndex());
    }

    public StyleStream pinkBorderColor() {
        return this.borderColor(HSSFColor.HSSFColorPredefined.PINK.getIndex());
    }

    public StyleStream indigoBorderColor() {
        return this.borderColor(HSSFColor.HSSFColorPredefined.INDIGO.getIndex());
    }

    public StyleStream unsetTopBorder() {
        return this.topBorder(0);
    }

    public StyleStream solidTopBorder() {
        return this.topBorder(1);
    }

    public StyleStream dashedTopBorder() {
        return this.topBorder(3);
    }

    public StyleStream topBorder(int i) {
        this.style.setBorderTop(BorderStyle.valueOf((short)((short)i)));
        return this;
    }

    public StyleStream topBorderColor(int i) {
        this.style.setTopBorderColor((short)i);
        return this;
    }

    public StyleStream topBorderColor(byte[] rgb) {
        if (this.style instanceof XSSFCellStyle) {
            ((XSSFCellStyle)this.style).setTopBorderColor(new XSSFColor(rgb, null));
        }
        return this;
    }

    public StyleStream topBorderColor(String c) {
        if (this.style instanceof XSSFCellStyle) {
            ((XSSFCellStyle)this.style).setTopBorderColor(new XSSFColor(Colors.toRgb((String)c), null));
        }
        return this;
    }

    public StyleStream topBorderColor(short index, byte[] rgb) {
        if (this.workbook instanceof HSSFWorkbook) {
            this.style.setTopBorderColor(Excels.paletteColor(this.workbook, index, rgb));
        }
        return this;
    }

    public StyleStream topBorderColor(short index, String c) {
        if (this.workbook instanceof HSSFWorkbook) {
            this.style.setTopBorderColor(Excels.paletteColor(this.workbook, index, c));
        }
        return this;
    }

    public StyleStream blueTopBorderColor() {
        return this.topBorderColor(HSSFColor.HSSFColorPredefined.BLUE.getIndex());
    }

    public StyleStream blackTopBorderColor() {
        return this.topBorderColor(HSSFColor.HSSFColorPredefined.BLACK.getIndex());
    }

    public StyleStream redTopBorderColor() {
        return this.topBorderColor(HSSFColor.HSSFColorPredefined.RED.getIndex());
    }

    public StyleStream pinkTopBorderColor() {
        return this.topBorderColor(HSSFColor.HSSFColorPredefined.PINK.getIndex());
    }

    public StyleStream indigoTopBorderColor() {
        return this.topBorderColor(HSSFColor.HSSFColorPredefined.INDIGO.getIndex());
    }

    public StyleStream unsetBottomBorder() {
        return this.bottomBorder(0);
    }

    public StyleStream solidBottomBorder() {
        return this.bottomBorder(1);
    }

    public StyleStream dashedBottomBorder() {
        return this.bottomBorder(3);
    }

    public StyleStream bottomBorder(int i) {
        this.style.setBorderBottom(BorderStyle.valueOf((short)((short)i)));
        return this;
    }

    public StyleStream bottomBorderColor(int i) {
        this.style.setBottomBorderColor((short)i);
        return this;
    }

    public StyleStream bottomBorderColor(byte[] rgb) {
        if (this.style instanceof XSSFCellStyle) {
            ((XSSFCellStyle)this.style).setBottomBorderColor(new XSSFColor(rgb, null));
        }
        return this;
    }

    public StyleStream bottomBorderColor(String c) {
        if (this.style instanceof XSSFCellStyle) {
            ((XSSFCellStyle)this.style).setBottomBorderColor(new XSSFColor(Colors.toRgb((String)c), null));
        }
        return this;
    }

    public StyleStream bottomBorderColor(short index, byte[] rgb) {
        if (this.workbook instanceof HSSFWorkbook) {
            this.style.setBottomBorderColor(Excels.paletteColor(this.workbook, index, rgb));
        }
        return this;
    }

    public StyleStream bottomBorderColor(short index, String c) {
        if (this.workbook instanceof HSSFWorkbook) {
            this.style.setBottomBorderColor(Excels.paletteColor(this.workbook, index, c));
        }
        return this;
    }

    public StyleStream blueBottomBorderColor() {
        return this.bottomBorderColor(HSSFColor.HSSFColorPredefined.BLUE.getIndex());
    }

    public StyleStream blackBottomBorderColor() {
        return this.bottomBorderColor(HSSFColor.HSSFColorPredefined.BLACK.getIndex());
    }

    public StyleStream redBottomBorderColor() {
        return this.bottomBorderColor(HSSFColor.HSSFColorPredefined.RED.getIndex());
    }

    public StyleStream pinkBottomBorderColor() {
        return this.bottomBorderColor(HSSFColor.HSSFColorPredefined.PINK.getIndex());
    }

    public StyleStream indigoBottomBorderColor() {
        return this.bottomBorderColor(HSSFColor.HSSFColorPredefined.INDIGO.getIndex());
    }

    public StyleStream unsetLeftBorder() {
        return this.leftBorder(0);
    }

    public StyleStream solidLeftBorder() {
        return this.leftBorder(1);
    }

    public StyleStream dashedLeftBorder() {
        return this.leftBorder(3);
    }

    public StyleStream leftBorder(int i) {
        this.style.setBorderLeft(BorderStyle.valueOf((short)((short)i)));
        return this;
    }

    public StyleStream leftBorderColor(int i) {
        this.style.setLeftBorderColor((short)i);
        return this;
    }

    public StyleStream leftBorderColor(byte[] rgb) {
        if (this.style instanceof XSSFCellStyle) {
            ((XSSFCellStyle)this.style).setLeftBorderColor(new XSSFColor(rgb, null));
        }
        return this;
    }

    public StyleStream leftBorderColor(String c) {
        if (this.style instanceof XSSFCellStyle) {
            ((XSSFCellStyle)this.style).setLeftBorderColor(new XSSFColor(Colors.toRgb((String)c), null));
        }
        return this;
    }

    public StyleStream leftBorderColor(short index, byte[] rgb) {
        if (this.workbook instanceof HSSFWorkbook) {
            this.style.setLeftBorderColor(Excels.paletteColor(this.workbook, index, rgb));
        }
        return this;
    }

    public StyleStream leftBorderColor(short index, String c) {
        if (this.workbook instanceof HSSFWorkbook) {
            this.style.setLeftBorderColor(Excels.paletteColor(this.workbook, index, c));
        }
        return this;
    }

    public StyleStream blueLeftBorderColor() {
        return this.leftBorderColor(HSSFColor.HSSFColorPredefined.BLUE.getIndex());
    }

    public StyleStream blackLeftBorderColor() {
        return this.leftBorderColor(HSSFColor.HSSFColorPredefined.BLACK.getIndex());
    }

    public StyleStream redLeftBorderColor() {
        return this.leftBorderColor(HSSFColor.HSSFColorPredefined.RED.getIndex());
    }

    public StyleStream pinkLeftBorderColor() {
        return this.leftBorderColor(HSSFColor.HSSFColorPredefined.PINK.getIndex());
    }

    public StyleStream indigoLeftBorderColor() {
        return this.leftBorderColor(HSSFColor.HSSFColorPredefined.INDIGO.getIndex());
    }

    public StyleStream unsetRightBorder() {
        return this.rightBorder(0);
    }

    public StyleStream solidRightBorder() {
        return this.rightBorder(1);
    }

    public StyleStream dashedRightBorder() {
        return this.rightBorder(3);
    }

    public StyleStream rightBorder(int i) {
        this.style.setBorderRight(BorderStyle.valueOf((short)((short)i)));
        return this;
    }

    public StyleStream rightBorderColor(int i) {
        this.style.setRightBorderColor((short)i);
        return this;
    }

    public StyleStream rightBorderColor(byte[] rgb) {
        if (this.style instanceof XSSFCellStyle) {
            ((XSSFCellStyle)this.style).setRightBorderColor(new XSSFColor(rgb, null));
        }
        return this;
    }

    public StyleStream rightBorderColor(String c) {
        if (this.style instanceof XSSFCellStyle) {
            ((XSSFCellStyle)this.style).setRightBorderColor(new XSSFColor(Colors.toRgb((String)c), null));
        }
        return this;
    }

    public StyleStream rightBorderColor(short index, byte[] rgb) {
        if (this.workbook instanceof HSSFWorkbook) {
            this.style.setRightBorderColor(Excels.paletteColor(this.workbook, index, rgb));
        }
        return this;
    }

    public StyleStream rightBorderColor(short index, String c) {
        if (this.workbook instanceof HSSFWorkbook) {
            this.style.setRightBorderColor(Excels.paletteColor(this.workbook, index, c));
        }
        return this;
    }

    public StyleStream blueRightBorderColor() {
        return this.rightBorderColor(HSSFColor.HSSFColorPredefined.BLUE.getIndex());
    }

    public StyleStream blackRightBorderColor() {
        return this.rightBorderColor(HSSFColor.HSSFColorPredefined.BLACK.getIndex());
    }

    public StyleStream redRightBorderColor() {
        return this.rightBorderColor(HSSFColor.HSSFColorPredefined.RED.getIndex());
    }

    public StyleStream pinkRightBorderColor() {
        return this.rightBorderColor(HSSFColor.HSSFColorPredefined.PINK.getIndex());
    }

    public StyleStream indigoRightBorderColor() {
        return this.rightBorderColor(HSSFColor.HSSFColorPredefined.INDIGO.getIndex());
    }

    public Workbook getWorkbook() {
        return this.workbook;
    }

    public CellStyle getStyle() {
        return this.style;
    }

    public boolean isWrapText() {
        return this.style.getWrapText();
    }

    public int getVerticalAlignmentType() {
        return this.style.getVerticalAlignment().getCode();
    }

    public int getAlignment() {
        return this.style.getAlignment().getCode();
    }

    public int getRotation() {
        return this.style.getRotation();
    }

    public short getIndex() {
        return this.style.getIndex();
    }

    public int getDataFormat() {
        return this.style.getDataFormat();
    }

    public int getIndention() {
        return this.style.getIndention();
    }

    public boolean isLocked() {
        return this.style.getLocked();
    }

    public int getFillPattern() {
        return this.style.getFillPattern().getCode();
    }

    public int getFillForegroundColor() {
        return this.style.getFillForegroundColor();
    }

    public int getFillBackgroundColor() {
        return this.style.getFillBackgroundColor();
    }

    public int getBorderLeftType() {
        return this.style.getBorderLeft().getCode();
    }

    public int getBorderRightType() {
        return this.style.getBorderRight().getCode();
    }

    public int getBorderTopType() {
        return this.style.getBorderTop().getCode();
    }

    public int getBorderBottomType() {
        return this.style.getBorderBottom().getCode();
    }

    public short getBorderLeftColor() {
        return this.style.getLeftBorderColor();
    }

    public short getBorderRightColor() {
        return this.style.getRightBorderColor();
    }

    public short getBorderTopColor() {
        return this.style.getTopBorderColor();
    }

    public short getBorderBottomColor() {
        return this.style.getBottomBorderColor();
    }

    public boolean isQuotePrefixed() {
        return this.style.getQuotePrefixed();
    }

    public boolean isAutoResize() {
        return this.style.getShrinkToFit();
    }

    public short getDataFormatIndex() {
        return this.style.getDataFormat();
    }

    public String getDataFormatString() {
        return this.style.getDataFormatString();
    }

    public int getReadingOrder() {
        if (this.style instanceof XSSFCellStyle) {
            return ((XSSFCellStyle)this.style).getReadingOrder().getCode();
        }
        return -1;
    }
}

