/*
 * Decompiled with CFR 0.152.
 */
package com.orion.office.excel.type;

import com.orion.lang.utils.Strings;

public enum ExcelPictureType {
    AUTO(0, 0, ""),
    EMF(2, 2, "emf"),
    WMF(3, 3, "wmf"),
    PICT(4, 4, "pict"),
    JPG(5, 5, "jpg"),
    JPEG(5, 5, "jpeg"),
    PNG(6, 6, "png"),
    BIT_MAT(7, 7, "bid"),
    GIF(-1, 8, "gif"),
    TIFF(-1, 9, "tiff"),
    EPS(-1, 10, "eps"),
    BMP(-1, 11, "bmp"),
    WPG(-1, 12, "wpg");

    private final int type1;
    private final int type2;
    private final String suffix;

    private ExcelPictureType(int type1, int type2, String suffix) {
        this.type1 = type1;
        this.type2 = type2;
        this.suffix = suffix;
    }

    public int getType1() {
        return this.type1;
    }

    public int getType2() {
        return this.type2;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public static ExcelPictureType of(String suffix) {
        if (Strings.isEmpty((CharSequence)suffix)) {
            return PNG;
        }
        for (ExcelPictureType value : ExcelPictureType.values()) {
            if (!value.getSuffix().equals(suffix)) continue;
            return value;
        }
        return PNG;
    }
}

