/*
 * Decompiled with CFR 0.152.
 */
package com.orion.office.excel.writer;

import com.orion.lang.able.SafeCloseable;
import com.orion.lang.utils.Valid;
import com.orion.lang.utils.io.Files1;
import com.orion.lang.utils.io.Streams;
import com.orion.office.excel.Excels;
import java.io.File;
import java.io.OutputStream;
import org.apache.poi.ss.usermodel.Workbook;

public class BaseExcelWriteable
implements SafeCloseable {
    protected Workbook workbook;

    public BaseExcelWriteable(Workbook workbook) {
        Valid.notNull((Object)workbook, (String)"workbook is null", (Object[])new Object[0]);
        this.workbook = workbook;
    }

    public BaseExcelWriteable write(String file) {
        Valid.notNull((Object)file, (String)"file is null", (Object[])new Object[0]);
        return this.write(Files1.openOutputStreamSafe((String)file), null, true);
    }

    public BaseExcelWriteable write(File file) {
        Valid.notNull((Object)file, (String)"file is null", (Object[])new Object[0]);
        return this.write(Files1.openOutputStreamSafe((File)file), null, true);
    }

    public BaseExcelWriteable write(OutputStream out) {
        Valid.notNull((Object)out, (String)"stream is null", (Object[])new Object[0]);
        return this.write(out, null, false);
    }

    public BaseExcelWriteable write(String file, String password) {
        Valid.notNull((Object)file, (String)"file is null", (Object[])new Object[0]);
        return this.write(Files1.openOutputStreamSafe((String)file), password, true);
    }

    public BaseExcelWriteable write(File file, String password) {
        Valid.notNull((Object)file, (String)"file is null", (Object[])new Object[0]);
        return this.write(Files1.openOutputStreamSafe((File)file), password, true);
    }

    public BaseExcelWriteable write(OutputStream out, String password) {
        Valid.notNull((Object)out, (String)"stream is null", (Object[])new Object[0]);
        return this.write(out, password, false);
    }

    protected BaseExcelWriteable write(OutputStream out, String password, boolean close) {
        Excels.setDefaultProperties(this.workbook);
        Excels.write(this.workbook, out, password, close);
        return this;
    }

    public Workbook getWorkbook() {
        return this.workbook;
    }

    public void close() {
        Streams.close((AutoCloseable)this.workbook);
    }
}

