/*
 * Decompiled with CFR 0.152.
 */
package com.orion.office.excel.writer.exporting;

import com.orion.lang.utils.Arrays1;
import com.orion.lang.utils.Exceptions;
import com.orion.lang.utils.Objects1;
import com.orion.lang.utils.Strings;
import com.orion.lang.utils.collect.Sets;
import com.orion.office.excel.Excels;
import com.orion.office.excel.option.CommentOption;
import com.orion.office.excel.option.ExportFieldOption;
import com.orion.office.excel.option.FontOption;
import com.orion.office.excel.option.FooterOption;
import com.orion.office.excel.option.HeaderOption;
import com.orion.office.excel.option.PrintOption;
import com.orion.office.excel.option.PropertiesOption;
import com.orion.office.excel.option.TitleOption;
import com.orion.office.excel.writer.exporting.SheetAnalysis;
import com.orion.office.excel.writer.exporting.SheetColumnAnalysis;
import com.orion.office.excel.writer.exporting.SheetConfig;
import java.util.Optional;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;

public class ExportInitializer<T> {
    protected final Workbook workbook;
    protected Sheet sheet;
    private final Class<T> targetClass;
    private final SheetConfig<T> sheetConfig;
    protected int rowIndex;
    private boolean init;

    protected ExportInitializer(Workbook workbook, Sheet sheet, Class<T> targetClass, SheetConfig<T> sheetConfig) {
        this.workbook = workbook;
        this.targetClass = targetClass;
        this.sheetConfig = sheetConfig;
        this.sheet = sheet;
        this.setup();
    }

    private void setup() {
        SheetAnalysis<T> sheetAnalysis = new SheetAnalysis<T>(this.targetClass, this.sheetConfig);
        sheetAnalysis.analysis();
        SheetColumnAnalysis<T> sheetColumnAnalysis = new SheetColumnAnalysis<T>(this.targetClass, this.sheetConfig);
        sheetColumnAnalysis.analysis();
        if (this.sheet == null) {
            this.sheet = this.sheetConfig.sheetOption.getName() != null ? this.workbook.createSheet(this.sheetConfig.sheetOption.getName()) : this.workbook.createSheet();
        } else if (this.sheetConfig.sheetOption.getName() != null) {
            this.workbook.setSheetName(this.workbook.getSheetIndex(this.sheet), this.sheetConfig.sheetOption.getName());
        }
        this.addColumnStyle();
    }

    protected void checkInit() {
        if (!this.init) {
            throw Exceptions.init((String)"excel export uninitialized");
        }
    }

    protected void init() {
        this.init = true;
        this.setSheetOption();
        this.setPageHeader();
        this.setPageFooter();
        this.addTitle();
        this.addDefaultHeader();
        this.setPrintOption();
        this.setPropertiesOption();
    }

    protected void finished() {
        this.addRowSelectOptions();
    }

    private void setSheetOption() {
        Integer defaultRowWidth;
        Integer defaultRowHeight;
        if (this.sheetConfig.sheetOption.isNameReset()) {
            this.workbook.setSheetName(this.workbook.getSheetIndex(this.sheet), this.sheetConfig.sheetOption.getName());
        }
        if ((defaultRowHeight = this.sheetConfig.sheetOption.getRowHeight()) != null) {
            this.sheet.setDefaultRowHeightInPoints((float)defaultRowHeight.intValue());
        }
        if ((defaultRowWidth = this.sheetConfig.sheetOption.getColumnWidth()) != null) {
            this.sheet.setDefaultColumnWidth(defaultRowWidth.intValue());
        }
        if (this.sheetConfig.sheetOption.getZoom() != null) {
            this.sheet.setZoom(this.sheetConfig.sheetOption.getZoom().intValue());
        }
        if (this.sheetConfig.sheetOption.isSelected()) {
            this.workbook.setActiveSheet(this.workbook.getSheetIndex(this.sheet));
        }
        if (this.sheetConfig.sheetOption.isHidden()) {
            this.workbook.setSheetHidden(this.workbook.getSheetIndex(this.sheet), true);
        }
        if (this.sheetConfig.sheetOption.isDisplayGridLines()) {
            this.sheet.setDisplayGridlines(false);
        }
        if (this.sheetConfig.sheetOption.isDisplayRowColHeadings()) {
            this.sheet.setDisplayRowColHeadings(false);
        }
        if (this.sheetConfig.sheetOption.isDisplayFormulas()) {
            this.sheet.setDisplayFormulas(true);
        }
    }

    private void setPageHeader() {
        HeaderOption headerOption = this.sheetConfig.sheetOption.getHeaderOption();
        if (headerOption != null) {
            Excels.setHeader(this.sheet, headerOption);
        }
    }

    private void setPageFooter() {
        FooterOption footerOption = this.sheetConfig.sheetOption.getFooterOption();
        if (footerOption != null) {
            Excels.setFooter(this.sheet, footerOption);
        }
    }

    private void addColumnStyle() {
        this.sheetConfig.fieldOptions.forEach((k, v) -> {
            CellStyle columnStyle = this.parseStyle((int)k, true, (ExportFieldOption)v);
            this.sheetConfig.columnStyles.put((Integer)k, columnStyle);
            if (this.sheetConfig.sheetOption.isColumnUseDefaultStyle()) {
                this.sheet.setDefaultColumnStyle(k.intValue(), columnStyle);
            }
            if (this.sheetConfig.sheetOption.isHeaderUseColumnStyle() && !v.isSkipHeaderStyle()) {
                CellStyle headerStyle = this.parseStyle((int)k, false, (ExportFieldOption)v);
                this.sheetConfig.headerStyles.put((Integer)k, headerStyle);
            } else {
                this.sheetConfig.headerStyles.put((Integer)k, this.workbook.createCellStyle());
            }
            if (v.isHidden()) {
                this.sheet.setColumnHidden(k.intValue(), true);
            }
        });
    }

    private void addTitle() {
        TitleOption titleOption = this.sheetConfig.sheetOption.getTitleOption();
        if (this.sheetConfig.sheetOption.isSkipTitle() || titleOption == null) {
            return;
        }
        if (this.sheetConfig.sheetOption.getTitle() != null) {
            titleOption.setTitle(this.sheetConfig.sheetOption.getTitle());
        }
        titleOption.setPaletteColorIndex(this.sheetConfig.colorIndex);
        CellStyle titleStyle = (CellStyle)Objects1.def((Object)Excels.parseTitleStyle(this.workbook, titleOption), () -> ((Workbook)this.workbook).createCellStyle());
        this.sheetConfig.colorIndex = titleOption.getPaletteColorIndex();
        FontOption fontOption = titleOption.getFont();
        fontOption.setPaletteColorIndex(this.sheetConfig.colorIndex);
        Font font = (Font)Objects1.def((Object)Excels.parseFont(this.workbook, fontOption), () -> ((Workbook)this.workbook).createFont());
        titleStyle.setFont(font);
        this.sheetConfig.colorIndex = fontOption.getPaletteColorIndex();
        Row titleRow = this.sheet.createRow(this.rowIndex);
        int useRow = titleOption.getUseRow();
        for (int i = 1; i < useRow; ++i) {
            Row temp = this.sheet.createRow(this.rowIndex + i);
            if (this.sheetConfig.sheetOption.getTitleHeight() == null) continue;
            temp.setHeightInPoints((float)this.sheetConfig.sheetOption.getTitleHeight().intValue());
        }
        if (this.sheetConfig.sheetOption.getTitleHeight() != null) {
            titleRow.setHeightInPoints((float)this.sheetConfig.sheetOption.getTitleHeight().intValue());
        }
        if (titleOption.getUseColumn() == -1) {
            titleOption.setUseColumn(this.sheetConfig.sheetOption.getColumnMaxIndex());
        }
        Cell titleCell = titleRow.createCell(0);
        titleCell.setCellStyle(titleStyle);
        titleCell.setCellValue(titleOption.getTitle());
        CellRangeAddress region = new CellRangeAddress(this.rowIndex, this.rowIndex + useRow - 1, 0, titleOption.getUseColumn());
        Excels.mergeCell(this.sheet, region);
        Excels.mergeCellBorder(this.sheet, titleStyle.getBorderTop().getCode(), titleStyle.getTopBorderColor(), region);
        this.rowIndex += useRow;
        this.sheetConfig.sheetOption.setTitleAndHeaderLastRowIndex(this.rowIndex);
    }

    private void addDefaultHeader() {
        if (this.sheetConfig.sheetOption.isSkipFieldHeader()) {
            return;
        }
        Integer size = (Integer)Sets.max(this.sheetConfig.fieldOptions.keySet());
        CharSequence[] header = new String[size + 1];
        this.sheetConfig.fieldOptions.forEach((arg_0, arg_1) -> ExportInitializer.lambda$addDefaultHeader$1((String[])header, arg_0, arg_1));
        if (Strings.isAllEmpty((CharSequence[])header)) {
            return;
        }
        this.headers(true, (String[])header);
        this.sheetConfig.sheetOption.setTitleAndHeaderLastRowIndex(this.rowIndex);
        if (this.sheetConfig.sheetOption.isFreezeHeader()) {
            Excels.freezeRow(this.sheet, this.rowIndex);
        }
        if (this.sheetConfig.sheetOption.isFilterHeader()) {
            Excels.filterRow(this.sheet, this.rowIndex - 1, 0, this.sheetConfig.sheetOption.getColumnMaxIndex());
        }
    }

    private void addRowSelectOptions() {
        if (this.sheetConfig.sheetOption.isSkipSelectOption()) {
            return;
        }
        this.sheetConfig.fieldOptions.forEach((k, v) -> {
            Object[] options = v.getSelectOptions();
            if (Arrays1.isEmpty((Object[])options)) {
                return;
            }
            Excels.addSelectOptions(this.sheet, this.sheetConfig.sheetOption.getTitleAndHeaderLastRowIndex(), this.rowIndex - 1, k, (String[])options);
        });
    }

    private void setPrintOption() {
        PrintOption printOption = this.sheetConfig.sheetOption.getPrintOption();
        if (printOption != null) {
            Excels.parsePrint(this.sheet, printOption);
        }
    }

    private void setPropertiesOption() {
        PropertiesOption propertiesOption = this.sheetConfig.sheetOption.getPropertiesOption();
        if (propertiesOption != null) {
            Excels.setProperties(this.workbook, propertiesOption);
        }
    }

    protected void headers(boolean isDefault, String ... headers) {
        if (Arrays1.isEmpty((Object[])headers)) {
            return;
        }
        Row headerRow = this.sheet.createRow(this.rowIndex);
        Integer headerHeight = this.sheetConfig.sheetOption.getHeaderHeight();
        if (headerHeight != null) {
            headerRow.setHeightInPoints(headerHeight.floatValue());
        }
        for (int i = 0; i < headers.length; ++i) {
            CommentOption commentOption;
            Comment comment;
            Cell headerCell = headerRow.createCell(i);
            CellStyle headStyle = this.sheetConfig.headerStyles.get(i);
            if (headStyle != null) {
                headerCell.setCellStyle(headStyle);
            }
            if (isDefault && (comment = Excels.createComment(this.sheet, i, this.rowIndex, commentOption = (CommentOption)Optional.ofNullable(this.sheetConfig.fieldOptions.get(i)).map(ExportFieldOption::getCommentOption).orElse(null))) != null) {
                headerCell.setCellComment(comment);
            }
            headerCell.setCellValue(Strings.def((String)headers[i]));
        }
        ++this.rowIndex;
    }

    protected CellStyle parseStyle(int columnIndex, boolean isColumn, ExportFieldOption option) {
        Font font;
        option.setPaletteColorIndex(this.sheetConfig.colorIndex);
        CellStyle style = isColumn ? (CellStyle)Objects1.def((Object)Excels.parseColumnStyle(this.workbook, option), () -> ((Workbook)this.workbook).createCellStyle()) : (CellStyle)Objects1.def((Object)Excels.parseStyle(this.workbook, option), () -> ((Workbook)this.workbook).createCellStyle());
        this.sheetConfig.colorIndex = option.getPaletteColorIndex();
        if (option.getFontOption() != null) {
            option.getFontOption().setPaletteColorIndex(this.sheetConfig.colorIndex);
            font = (Font)Objects1.def((Object)Excels.parseFont(this.workbook, option.getFontOption()), () -> ((Workbook)this.workbook).createFont());
            this.sheetConfig.colorIndex = option.getFontOption().getPaletteColorIndex();
        } else {
            font = this.workbook.createFont();
        }
        style.setFont(font);
        Integer width = option.getWidth();
        if (width != null) {
            this.sheet.setColumnWidth(columnIndex, Excels.getWidth(width));
        }
        return style;
    }

    private static /* synthetic */ void lambda$addDefaultHeader$1(String[] header, Integer k, ExportFieldOption v) {
        header[k.intValue()] = v.getHeader();
    }
}

