/*
 * Decompiled with CFR 0.152.
 */
package com.orion.office.excel.writer.exporting;

import com.orion.lang.function.select.Selector;
import com.orion.lang.utils.Exceptions;
import com.orion.lang.utils.Objects1;
import com.orion.lang.utils.codec.Base64s;
import com.orion.lang.utils.io.Streams;
import com.orion.lang.utils.reflect.Methods;
import com.orion.office.excel.Excels;
import com.orion.office.excel.option.ExportFieldOption;
import com.orion.office.excel.option.LinkOption;
import com.orion.office.excel.option.PictureOption;
import com.orion.office.excel.writer.exporting.SheetConfig;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Optional;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Picture;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class ExportProcessor<T> {
    private final Workbook workbook;
    private final Sheet sheet;
    private final SheetConfig<T> sheetConfig;

    protected ExportProcessor(Workbook workbook, Sheet sheet, SheetConfig<T> sheetConfig) {
        this.workbook = workbook;
        this.sheetConfig = sheetConfig;
        this.sheet = sheet;
    }

    protected void setCellValue(Cell cell, int rowIndex, int columnIndex, T row, ExportFieldOption option) {
        CellStyle style = Optional.ofNullable(this.sheetConfig.columnStyleSelector.get(columnIndex)).map(s -> (Selector)s.apply(row)).map(s -> (CellStyle)s.orElse(null)).orElse(this.sheetConfig.columnStyles.get(columnIndex));
        if (style != null) {
            cell.setCellStyle(style);
        }
        if (row == null) {
            return;
        }
        boolean setValue = true;
        if (option.getPictureOption() != null) {
            this.setPicture(cell, row, rowIndex, columnIndex, option);
            setValue = false;
        }
        if (option.getLinkOption() != null) {
            this.setLink(cell, row, option);
            setValue = false;
        }
        if (setValue) {
            Object o = Methods.invokeMethod(row, (Method)option.getGetterMethod());
            if (o instanceof String && option.isTrim()) {
                o = ((String)o).trim();
            }
            Excels.setCellValue(cell, o, option.getType(), option.getCellOption());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPicture(Cell cell, T row, int rowIndex, int columnIndex, ExportFieldOption option) {
        Method getterMethod = option.getGetterMethod();
        PictureOption pictureOption = option.getPictureOption();
        Method pictureGetterMethod = pictureOption.isOriginImage() ? getterMethod : pictureOption.getImageGetter();
        Object pictureValue = Methods.invokeMethod(row, (Method)pictureGetterMethod);
        if (pictureValue != null) {
            try {
                Picture picture = null;
                if (pictureValue instanceof InputStream) {
                    picture = Excels.setPicture(this.workbook, this.sheet, (InputStream)pictureValue, rowIndex, columnIndex, pictureOption.getType());
                } else if (pictureValue instanceof byte[]) {
                    picture = Excels.setPicture(this.workbook, this.sheet, (byte[])pictureValue, rowIndex, columnIndex, pictureOption.getType());
                } else if (pictureValue instanceof String && pictureOption.isBase64()) {
                    String type = Base64s.img64Type((String)((String)pictureValue));
                    byte[] bytes = Base64s.img64Decode((String)((String)pictureValue));
                    picture = Excels.setPicture(this.workbook, this.sheet, bytes, rowIndex, columnIndex, type, pictureOption.getType());
                }
                if (picture != null) {
                    picture.resize(pictureOption.getScaleX(), pictureOption.getScaleY());
                }
            }
            catch (Exception e) {
                if (!this.sheetConfig.sheetOption.isSkipPictureException()) {
                    throw Exceptions.unchecked((Throwable)e);
                }
            }
            finally {
                if (pictureOption.isAutoClose() && pictureValue instanceof InputStream) {
                    Streams.close((AutoCloseable)((InputStream)pictureValue));
                }
            }
        }
        Object textValue = null;
        if (pictureOption.isNoneText()) {
            return;
        }
        if (pictureOption.isOriginText()) {
            textValue = Methods.invokeMethod(row, (Method)getterMethod);
        } else if (pictureOption.getTextValue() != null) {
            textValue = pictureOption.getTextValue();
        } else if (pictureOption.getTextGetter() != null) {
            textValue = Methods.invokeMethod(row, (Method)pictureOption.getTextGetter());
        }
        Excels.setCellValue(cell, textValue, pictureOption.getTextType(), pictureOption.getCellOption());
    }

    private void setLink(Cell cell, T row, ExportFieldOption option) {
        Method getterMethod = option.getGetterMethod();
        LinkOption linkOption = option.getLinkOption();
        String address = null;
        Object textValue = null;
        Object methodValue = null;
        if (linkOption.isOriginLink()) {
            methodValue = Methods.invokeMethod(row, (Method)getterMethod);
            address = Objects1.toString((Object)methodValue);
        } else if (linkOption.getLinkValue() != null) {
            address = linkOption.getLinkValue();
        } else if (linkOption.getLinkGetterMethod() != null) {
            address = Objects1.toString((Object)Methods.invokeMethod(row, (Method)linkOption.getLinkGetterMethod()));
        }
        if (linkOption.isOriginText()) {
            if (methodValue == null) {
                methodValue = Methods.invokeMethod(row, (Method)getterMethod);
            }
            textValue = methodValue;
        } else if (linkOption.getTextValue() != null) {
            textValue = linkOption.getTextValue();
        } else if (linkOption.getTextGetterMethod() != null) {
            textValue = Objects1.toString((Object)Methods.invokeMethod(row, (Method)linkOption.getTextGetterMethod()));
        }
        Excels.setLink(this.workbook, cell, linkOption.getType(), address, linkOption.getTextType(), linkOption.getCellOption(), textValue);
    }
}

