/*
 * Decompiled with CFR 0.152.
 */
package com.orion.office.excel.writer.exporting;

import com.orion.lang.able.Analysable;
import com.orion.lang.define.wrapper.Tuple;
import com.orion.lang.utils.Exceptions;
import com.orion.lang.utils.Strings;
import com.orion.lang.utils.reflect.Annotations;
import com.orion.lang.utils.reflect.Classes;
import com.orion.lang.utils.reflect.Fields;
import com.orion.lang.utils.reflect.Methods;
import com.orion.office.excel.annotation.ExportComment;
import com.orion.office.excel.annotation.ExportField;
import com.orion.office.excel.annotation.ExportFont;
import com.orion.office.excel.annotation.ExportIgnore;
import com.orion.office.excel.annotation.ExportLink;
import com.orion.office.excel.annotation.ExportPicture;
import com.orion.office.excel.option.CellOption;
import com.orion.office.excel.option.CommentOption;
import com.orion.office.excel.option.ExportFieldOption;
import com.orion.office.excel.option.FontOption;
import com.orion.office.excel.option.LinkOption;
import com.orion.office.excel.option.PictureOption;
import com.orion.office.excel.type.ExcelFieldType;
import com.orion.office.excel.writer.exporting.SheetConfig;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class SheetColumnAnalysis<T>
implements Analysable {
    private final Class<T> targetClass;
    private final SheetConfig<T> sheetConfig;
    private int columnMaxIndex;

    protected SheetColumnAnalysis(Class<T> targetClass, SheetConfig<T> sheetConfig) {
        this.targetClass = targetClass;
        this.sheetConfig = sheetConfig;
    }

    public void analysis() {
        List fieldList = Fields.getFieldsByCache(this.targetClass);
        List methodList = Methods.getGetterMethodsByCache(this.targetClass);
        for (Field field : fieldList) {
            this.analysisColumn((ExportField)Annotations.getAnnotation((Field)field, ExportField.class), (ExportFont)Annotations.getAnnotation((Field)field, ExportFont.class), (ExportComment)Annotations.getAnnotation((Field)field, ExportComment.class), (ExportLink)Annotations.getAnnotation((Field)field, ExportLink.class), (ExportPicture)Annotations.getAnnotation((Field)field, ExportPicture.class), (ExportIgnore)Annotations.getAnnotation((Field)field, ExportIgnore.class), Methods.getGetterMethodByField(this.targetClass, (Field)field), field.getName());
        }
        for (Method method : methodList) {
            this.analysisColumn((ExportField)Annotations.getAnnotation((Method)method, ExportField.class), (ExportFont)Annotations.getAnnotation((Method)method, ExportFont.class), (ExportComment)Annotations.getAnnotation((Method)method, ExportComment.class), (ExportLink)Annotations.getAnnotation((Method)method, ExportLink.class), (ExportPicture)Annotations.getAnnotation((Method)method, ExportPicture.class), (ExportIgnore)Annotations.getAnnotation((Method)method, ExportIgnore.class), method, null);
        }
        this.indexToSort();
    }

    private void analysisColumn(ExportField field, ExportFont font, ExportComment comment, ExportLink link, ExportPicture picture, ExportIgnore ignore, Method method, String fieldName) {
        if (field == null || ignore != null) {
            return;
        }
        if (method == null) {
            throw Exceptions.parse((String)("not found " + fieldName + "getter method"));
        }
        int index = field.index();
        this.columnMaxIndex = Math.max(this.columnMaxIndex, index);
        this.sheetConfig.sheetOption.setColumnMaxIndex(this.columnMaxIndex);
        ExportFieldOption exportFieldOption = this.analysisField(field, method);
        if (font != null) {
            exportFieldOption.setFontOption(this.analysisFont(font));
        }
        if (comment != null && !this.sheetConfig.sheetOption.isSkipComment()) {
            exportFieldOption.setCommentOption(this.analysisComment(comment));
        }
        if (link != null && !this.sheetConfig.sheetOption.isSkipLink()) {
            exportFieldOption.setLinkOption(this.analysisLink(link, exportFieldOption));
        }
        if (picture != null && !this.sheetConfig.sheetOption.isSkipPicture()) {
            exportFieldOption.setPictureOption(this.analysisPicture(picture, exportFieldOption, method));
        }
    }

    private ExportFieldOption analysisField(ExportField field, Method method) {
        ExcelFieldType type;
        String backgroundColor;
        ExportFieldOption exportFieldOption = new ExportFieldOption();
        exportFieldOption.setGetterMethod(method);
        exportFieldOption.setAlign(field.align());
        exportFieldOption.setVerticalAlign(field.verticalAlign());
        int width = field.width();
        if (width != -1) {
            exportFieldOption.setWidth(width);
        }
        if (!Strings.isEmpty((CharSequence)(backgroundColor = field.backgroundColor()))) {
            exportFieldOption.setBackgroundColor(backgroundColor);
        }
        if (field.wrapText()) {
            exportFieldOption.setWrapText(true);
        }
        exportFieldOption.setBorder(field.border());
        String borderColor = field.borderColor();
        if (!Strings.isEmpty((CharSequence)borderColor)) {
            exportFieldOption.setBorderColor(borderColor);
        }
        if (field.indent() != -1) {
            exportFieldOption.setIndent((short)field.indent());
        }
        if ((type = field.type()).equals((Object)ExcelFieldType.AUTO)) {
            exportFieldOption.setType(ExcelFieldType.of(method.getReturnType()));
        } else {
            exportFieldOption.setType(type);
        }
        exportFieldOption.setTrim(field.trim());
        exportFieldOption.setFormat(field.format());
        exportFieldOption.setHeader(field.header());
        exportFieldOption.setSkipHeaderStyle(field.skipHeaderStyle());
        exportFieldOption.setSelectOptions(field.selectOptions());
        exportFieldOption.setHidden(field.hidden());
        exportFieldOption.setLock(field.lock());
        exportFieldOption.setAutoResize(field.autoResize());
        exportFieldOption.setQuotePrefixed(field.quotePrefixed());
        CellOption cellOption = new CellOption();
        cellOption.setFormat(field.format());
        exportFieldOption.setCellOption(cellOption);
        this.sheetConfig.fieldOptions.put(field.index(), exportFieldOption);
        return exportFieldOption;
    }

    private FontOption analysisFont(ExportFont font) {
        return SheetColumnAnalysis.parseFont(font);
    }

    private CommentOption analysisComment(ExportComment comment) {
        CommentOption commentOption = new CommentOption();
        commentOption.setAuthor(comment.author());
        commentOption.setComment(comment.comment());
        commentOption.setVisible(comment.visible());
        return commentOption;
    }

    private LinkOption analysisLink(ExportLink link, ExportFieldOption exportFieldOption) {
        String fieldName;
        LinkOption linkOption = new LinkOption();
        linkOption.setType(link.type());
        linkOption.setAddress(link.address());
        linkOption.setText(link.text());
        if ("@".equals(linkOption.getAddress())) {
            linkOption.setOriginLink(true);
        } else if (linkOption.getAddress().startsWith("!")) {
            linkOption.setLinkValue(linkOption.getAddress().substring(1));
        } else if (linkOption.getAddress().startsWith("$")) {
            fieldName = linkOption.getAddress().substring(1);
            SheetColumnAnalysis.setLinkOptionType(this.targetClass, linkOption, true, fieldName);
        } else {
            throw Exceptions.parse((String)("failed to parse the hyperlink address formula, reason: unknown formula " + linkOption.getAddress()));
        }
        if ("@".equals(linkOption.getText())) {
            linkOption.setOriginText(true);
            linkOption.setTextType(exportFieldOption.getType());
            linkOption.setCellOption(exportFieldOption.getCellOption());
        } else if (linkOption.getText().startsWith("!")) {
            linkOption.setTextType(ExcelFieldType.TEXT);
            linkOption.setTextValue(linkOption.getText().substring(1));
        } else if (linkOption.getText().startsWith("$")) {
            fieldName = linkOption.getText().substring(1);
            SheetColumnAnalysis.setLinkOptionType(this.targetClass, linkOption, false, fieldName);
        } else {
            throw Exceptions.parse((String)("failed to parse the hyperlink text formula, reason: unknown formula " + linkOption.getTextGetterMethod()));
        }
        return linkOption;
    }

    private PictureOption analysisPicture(ExportPicture picture, ExportFieldOption exportFieldOption, Method method) {
        Method pictureGetterMethod;
        PictureOption option = new PictureOption();
        option.setScaleX(picture.scaleX());
        option.setScaleY(picture.scaleY());
        option.setType(picture.type());
        option.setAutoClose(picture.autoClose());
        option.setBase64(picture.base64());
        option.setText(picture.text());
        option.setImage(picture.image());
        if ("@".equals(option.getImage())) {
            option.setOriginImage(true);
            pictureGetterMethod = method;
        } else if (option.getImage().startsWith("$")) {
            pictureGetterMethod = method;
            option.setImageGetter(pictureGetterMethod);
        } else {
            throw Exceptions.parse((String)("failed to parse the hyperlink address formula, reason: unknown formula " + option.getImage()));
        }
        Class<?> pictureReturnType = pictureGetterMethod.getReturnType();
        if (!(Classes.isImplClass(InputStream.class, pictureReturnType) || pictureReturnType.equals(byte[].class) || option.isBase64() && pictureReturnType.equals(String.class))) {
            throw Exceptions.parse((String)"the image field type must not be InputStream, byte[], or Base64 String");
        }
        if (Strings.isEmpty((CharSequence)option.getText())) {
            option.setNoneText(true);
        } else if ("@".equals(option.getText())) {
            option.setOriginText(true);
            option.setTextType(exportFieldOption.getType());
            option.setCellOption(exportFieldOption.getCellOption());
        } else if (option.getText().startsWith("!")) {
            option.setTextType(ExcelFieldType.TEXT);
            option.setTextValue(option.getText().substring(1));
        } else if (option.getText().startsWith("$")) {
            String fieldName = option.getText().substring(1);
            SheetColumnAnalysis.setPictureTextOption(this.targetClass, option, fieldName);
        } else {
            throw Exceptions.parse((String)("failed to parse the picture text formula, reason: unknown formula " + option.getText()));
        }
        return option;
    }

    private void indexToSort() {
        if (!this.sheetConfig.sheetOption.isIndexToSort()) {
            return;
        }
        int i = 0;
        TreeMap<Integer, ExportFieldOption> sortedFieldOptions = new TreeMap<Integer, ExportFieldOption>();
        Set<Map.Entry<Integer, ExportFieldOption>> fieldOptionEntries = this.sheetConfig.fieldOptions.entrySet();
        for (Map.Entry<Integer, ExportFieldOption> fieldOptionEntry : fieldOptionEntries) {
            sortedFieldOptions.put(i++, fieldOptionEntry.getValue());
        }
        this.sheetConfig.fieldOptions = sortedFieldOptions;
        this.columnMaxIndex = fieldOptionEntries.size() - 1;
        this.sheetConfig.sheetOption.setColumnMaxIndex(this.columnMaxIndex);
    }

    public static void setPictureTextOption(Class<?> targetClass, PictureOption option, String fieldName) {
        Tuple tuple = SheetColumnAnalysis.getFieldOptionByFieldName(targetClass, fieldName);
        option.setTextGetter((Method)tuple.get(0));
        option.setTextType((ExcelFieldType)((Object)tuple.get(1)));
        option.setCellOption((CellOption)tuple.get(2));
    }

    public static void setLinkOptionType(Class<?> targetClass, LinkOption option, boolean isLink, String fieldName) {
        Tuple tuple = SheetColumnAnalysis.getFieldOptionByFieldName(targetClass, fieldName);
        Method getterMethod = (Method)tuple.get(0);
        if (isLink) {
            option.setLinkGetterMethod(getterMethod);
        } else {
            option.setTextGetterMethod(getterMethod);
            option.setTextType((ExcelFieldType)((Object)tuple.get(1)));
            option.setCellOption((CellOption)tuple.get(2));
        }
    }

    public static Tuple getFieldOptionByFieldName(Class<?> targetClass, String fieldName) {
        ExcelFieldType type;
        Field field = Fields.getFieldByCache(targetClass, (String)fieldName);
        Method getterMethod = field == null ? Methods.getGetterMethodByCache(targetClass, (String)fieldName) : Methods.getGetterMethodByField(targetClass, (Field)field);
        if (getterMethod == null) {
            throw Exceptions.parse((String)("did not find " + fieldName + " getter method at " + targetClass));
        }
        ExportField exportField = null;
        if (field != null) {
            exportField = (ExportField)Annotations.getAnnotation((Field)field, ExportField.class);
        }
        if (exportField == null) {
            exportField = (ExportField)Annotations.getAnnotation((Method)getterMethod, ExportField.class);
        }
        CellOption cellOption = null;
        if (exportField == null) {
            type = ExcelFieldType.of(getterMethod.getReturnType());
        } else if (exportField.type().equals((Object)ExcelFieldType.AUTO)) {
            type = ExcelFieldType.of(getterMethod.getReturnType());
            cellOption = new CellOption(exportField.format());
        } else {
            type = exportField.type();
            cellOption = new CellOption(exportField.format());
        }
        return Tuple.of((Object[])new Object[]{getterMethod, type, cellOption});
    }

    public static FontOption parseFont(ExportFont font) {
        String c;
        int s;
        FontOption fontOption = new FontOption();
        String name = font.fontName();
        if (!Strings.isEmpty((CharSequence)name)) {
            fontOption.setFontName(name);
        }
        if ((s = font.fontSize()) != -1) {
            fontOption.setFontSize(s);
        }
        if (!(c = font.color()).isEmpty()) {
            fontOption.setColor(c);
        }
        if (font.bold()) {
            fontOption.setBold(true);
        }
        if (font.italic()) {
            fontOption.setItalic(true);
        }
        fontOption.setUnder(font.under());
        if (font.delete()) {
            fontOption.setDelete(true);
        }
        return fontOption;
    }
}

