/*
 * Decompiled with CFR 0.152.
 */
package com.orion.office.excel.writer.exporting;

import com.orion.lang.function.select.Selector;
import com.orion.office.excel.Excels;
import com.orion.office.excel.option.ExportFieldOption;
import com.orion.office.excel.option.ExportSheetOption;
import com.orion.office.excel.writer.exporting.ExportInitializer;
import java.io.Serializable;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import org.apache.poi.ss.usermodel.CellStyle;

public class SheetConfig<T>
implements Serializable {
    protected short colorIndex = (short)32;
    protected ExportSheetOption sheetOption = new ExportSheetOption();
    protected Map<Integer, CellStyle> columnStyles = new TreeMap<Integer, CellStyle>();
    protected Map<Integer, CellStyle> headerStyles = new TreeMap<Integer, CellStyle>();
    protected Map<Integer, Function<T, Selector<T, CellStyle>>> columnStyleSelector = new TreeMap<Integer, Function<T, Selector<T, CellStyle>>>();
    protected Map<Integer, ExportFieldOption> fieldOptions = new TreeMap<Integer, ExportFieldOption>();
    protected ExportInitializer<?> initializer;

    protected SheetConfig() {
    }

    public SheetConfig<T> cleanStyle(int column) {
        this.initializer.checkInit();
        this.columnStyles.remove(column);
        this.headerStyles.remove(column);
        Integer rowWidth = this.sheetOption.getColumnWidth();
        if (rowWidth != null) {
            this.initializer.sheet.setColumnWidth(column, Excels.getWidth(rowWidth));
        }
        return this;
    }

    public SheetConfig<T> cleanHeaderStyle(int column) {
        this.initializer.checkInit();
        this.headerStyles.remove(column);
        return this;
    }

    public SheetConfig<T> cleanColumnStyle(int column) {
        this.initializer.checkInit();
        this.columnStyles.remove(column);
        return this;
    }

    public SheetConfig<T> headUseColumnStyle() {
        this.initializer.checkInit();
        this.fieldOptions.forEach((k, v) -> this.headerStyles.put((Integer)k, this.initializer.parseStyle((int)k, false, (ExportFieldOption)v)));
        return this;
    }

    public SheetConfig<T> headUseColumnStyle(int column) {
        this.initializer.checkInit();
        this.headerStyles.put(column, this.initializer.parseStyle(column, false, this.fieldOptions.get(column)));
        return this;
    }

    public SheetConfig<T> columnUseHeadStyle() {
        this.initializer.checkInit();
        this.fieldOptions.forEach((k, v) -> this.columnStyles.put((Integer)k, this.initializer.parseStyle((int)k, true, (ExportFieldOption)v)));
        return this;
    }

    public SheetConfig<T> columnUseHeadStyle(int column) {
        this.initializer.checkInit();
        this.columnStyles.put(column, this.initializer.parseStyle(column, true, this.fieldOptions.get(column)));
        return this;
    }

    public SheetConfig<T> setStyle(int column, CellStyle style) {
        this.initializer.checkInit();
        this.headerStyles.put(column, style);
        this.columnStyles.put(column, style);
        return this;
    }

    public SheetConfig<T> setHeaderStyle(int column, CellStyle style) {
        this.initializer.checkInit();
        this.headerStyles.put(column, style);
        return this;
    }

    public SheetConfig<T> setColumnStyle(int column, CellStyle style) {
        this.initializer.checkInit();
        this.columnStyles.put(column, style);
        return this;
    }

    public SheetConfig<T> setStyle(int column, ExportFieldOption option) {
        this.initializer.checkInit();
        if (option == null) {
            return this;
        }
        this.headerStyles.put(column, this.initializer.parseStyle(column, false, option));
        this.columnStyles.put(column, this.initializer.parseStyle(column, true, option));
        return this;
    }

    public SheetConfig<T> setHeaderStyle(int column, ExportFieldOption option) {
        this.initializer.checkInit();
        if (option == null) {
            return this;
        }
        this.headerStyles.put(column, this.initializer.parseStyle(column, false, option));
        return this;
    }

    public SheetConfig<T> setColumnStyle(int column, ExportFieldOption option) {
        this.initializer.checkInit();
        if (option == null) {
            return this;
        }
        this.columnStyles.put(column, this.initializer.parseStyle(column, true, option));
        return this;
    }

    public SheetConfig<T> setColumnStyle(int column, Function<T, Selector<T, CellStyle>> selector) {
        this.columnStyleSelector.put(column, selector);
        return this;
    }

    public ExportSheetOption getSheetOption() {
        this.initializer.checkInit();
        return this.sheetOption;
    }

    public Map<Integer, CellStyle> getColumnStyles() {
        this.initializer.checkInit();
        return this.columnStyles;
    }

    public Map<Integer, CellStyle> getHeaderStyles() {
        this.initializer.checkInit();
        return this.headerStyles;
    }

    public Map<Integer, Function<T, Selector<T, CellStyle>>> getColumnStyleSelector() {
        this.initializer.checkInit();
        return this.columnStyleSelector;
    }

    public Map<Integer, ExportFieldOption> getFieldOptions() {
        this.initializer.checkInit();
        return this.fieldOptions;
    }
}

