/*
 * Decompiled with CFR 0.152.
 */
package msnet;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import msnet.Call;
import msnet.Callback;
import msnet.Converter;
import msnet.ExceptionCatchingResponseBody;
import msnet.RequestFactory;
import msnet.Response;
import msnet.Utils;
import okcronet.Call;
import okcronet.http.MediaType;
import okcronet.http.Request;
import okcronet.http.ResponseBody;
import okio.BufferedSource;
import okio.Timeout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0001+B7\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00028\u00000\u000b\u00a2\u0006\u0002\u0010\rJ\b\u0010\u001e\u001a\u00020\u001fH\u0016J\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00028\u00000\u0002H\u0016J\u0016\u0010!\u001a\u00020\u001f2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00028\u00000#H\u0016J\u000e\u0010$\u001a\b\u0012\u0004\u0012\u00028\u00000%H\u0016J\u0014\u0010&\u001a\b\u0012\u0004\u0012\u00028\u00000%2\u0006\u0010'\u001a\u00020(J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010)\u001a\u00020*H\u0016R\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0014R\u001b\u0010\u0016\u001a\u00020\u00178BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00028\u00000\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lmsnet/MsCall;", "T", "Lmsnet/Call;", "callFactory", "Lokcronet/Call$Factory;", "requestFactory", "Lmsnet/RequestFactory;", "args", "", "", "responseConverter", "Lmsnet/Converter;", "Lokcronet/http/ResponseBody;", "(Lokcronet/Call$Factory;Lmsnet/RequestFactory;[Ljava/lang/Object;Lmsnet/Converter;)V", "[Ljava/lang/Object;", "canceled", "", "executed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "isCanceled", "()Z", "isExecuted", "rawCall", "Lokcronet/Call;", "getRawCall", "()Lokcronet/Call;", "rawCall$delegate", "Lkotlin/Lazy;", "request", "Lokcronet/http/Request;", "cancel", "", "clone", "enqueue", "callback", "Lmsnet/Callback;", "execute", "Lmsnet/Response;", "parseResponse", "response", "Lokcronet/http/Response;", "timeout", "Lokio/Timeout;", "NoContentResponseBody", "msnet_release"})
public final class MsCall<T>
implements Call<T> {
    @NotNull
    private final Call.Factory callFactory;
    @NotNull
    private final RequestFactory requestFactory;
    @NotNull
    private final Object[] args;
    @NotNull
    private final Converter<ResponseBody, T> responseConverter;
    @NotNull
    private final Request request;
    @NotNull
    private final AtomicBoolean executed;
    private boolean canceled;
    @NotNull
    private final Lazy rawCall$delegate;

    public MsCall(@NotNull Call.Factory callFactory, @NotNull RequestFactory requestFactory, @NotNull Object[] args, @NotNull Converter<ResponseBody, T> responseConverter) {
        Intrinsics.checkNotNullParameter((Object)callFactory, (String)"callFactory");
        Intrinsics.checkNotNullParameter((Object)requestFactory, (String)"requestFactory");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Intrinsics.checkNotNullParameter(responseConverter, (String)"responseConverter");
        this.callFactory = callFactory;
        this.requestFactory = requestFactory;
        this.args = args;
        this.responseConverter = responseConverter;
        Request request = this.requestFactory.create(this.args);
        Intrinsics.checkNotNullExpressionValue((Object)request, (String)"create(...)");
        this.request = request;
        this.executed = new AtomicBoolean();
        this.rawCall$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<okcronet.Call>(this){
            final /* synthetic */ MsCall<T> this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final okcronet.Call invoke() {
                return MsCall.access$getCallFactory$p(this.this$0).newCall(MsCall.access$getRequest$p(this.this$0));
            }
        }));
    }

    private final okcronet.Call getRawCall() {
        Lazy lazy = this.rawCall$delegate;
        return (okcronet.Call)lazy.getValue();
    }

    @Override
    @NotNull
    public Response<T> execute() throws IOException {
        if (!(!this.executed.getAndSet(true))) {
            boolean bl = false;
            String string = "Already Executed";
            throw new IllegalStateException(string.toString());
        }
        okcronet.http.Response rawResponse = this.getRawCall().execute();
        return this.parseResponse(rawResponse);
    }

    @Override
    public void enqueue(@NotNull Callback<T> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        if (!(!this.executed.getAndSet(true))) {
            boolean bl = false;
            String string = "Already Executed";
            throw new IllegalStateException(string.toString());
        }
        this.getRawCall().enqueue(new okcronet.Callback(this, callback){
            final /* synthetic */ MsCall<T> this$0;
            final /* synthetic */ Callback<T> $callback;
            {
                this.this$0 = $receiver;
                this.$callback = $callback;
            }

            public void onResponse(@NotNull okcronet.Call call, @NotNull okcronet.http.Response response) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                Response<T> msResponse = null;
                try {
                    msResponse = this.this$0.parseResponse(response);
                }
                catch (Throwable e) {
                    Utils.throwIfFatal(e);
                    this.callFailure(e);
                    return;
                }
                try {
                    this.$callback.onResponse(this.this$0, msResponse);
                }
                catch (Throwable t) {
                    Utils.throwIfFatal(t);
                    t.printStackTrace();
                }
            }

            public void onFailure(@NotNull okcronet.Call call, @NotNull IOException e) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.callFailure(e);
            }

            private final void callFailure(Throwable e) {
                try {
                    this.$callback.onFailure(this.this$0, e);
                }
                catch (Throwable t) {
                    Utils.throwIfFatal(t);
                    t.printStackTrace();
                }
            }
        });
    }

    @Override
    public boolean isExecuted() {
        return this.executed.get();
    }

    @Override
    public boolean isCanceled() {
        if (this.canceled) {
            return true;
        }
        return this.getRawCall().isCanceled();
    }

    @Override
    public void cancel() {
        this.canceled = true;
        this.getRawCall().cancel();
    }

    @Override
    @NotNull
    public Call<T> clone() {
        return new MsCall<T>(this.callFactory, this.requestFactory, this.args, this.responseConverter);
    }

    @Override
    @NotNull
    public Request request() {
        return this.request;
    }

    @Override
    @NotNull
    public synchronized Timeout timeout() {
        return this.getRawCall().timeout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Response<T> parseResponse(@NotNull okcronet.http.Response response) throws IOException {
        Response<T> response2;
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        okcronet.http.Response rawResponse = null;
        rawResponse = response;
        ResponseBody responseBody = response.getBody();
        if (responseBody == null) {
            throw new IllegalStateException("Raw response body is null.");
        }
        ResponseBody rawBody = responseBody;
        rawResponse = rawResponse.newBuilder().body((ResponseBody)new NoContentResponseBody(rawBody.contentType(), rawBody.contentLength())).build();
        int code = response.getUrlResponseInfo().getHttpStatusCode();
        if (code < 200 || code >= 300) {
            Closeable closeable = (Closeable)rawBody;
            Throwable throwable = null;
            try {
                Object it = (ResponseBody)closeable;
                boolean bl = false;
                ResponseBody bufferedBody = Utils.buffer(it);
                Intrinsics.checkNotNull((Object)bufferedBody);
                it = Response.Companion.error(bufferedBody, rawResponse);
            }
            catch (Throwable it) {
                throwable = it;
                throw it;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            return it;
        }
        switch (code) {
            case 204: 
            case 205: {
                rawBody.close();
                return Response.Companion.success(null, rawResponse);
            }
        }
        ExceptionCatchingResponseBody catchingBody = new ExceptionCatchingResponseBody(rawBody);
        try {
            T body = this.responseConverter.convert(catchingBody);
            response2 = Response.Companion.success(body, rawResponse);
        }
        catch (RuntimeException e) {
            catchingBody.throwIfCaught();
            throw e;
        }
        return response2;
    }

    public static final /* synthetic */ Call.Factory access$getCallFactory$p(MsCall $this) {
        return $this.callFactory;
    }

    public static final /* synthetic */ Request access$getRequest$p(MsCall $this) {
        return $this.request;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\n\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lmsnet/MsCall$NoContentResponseBody;", "Lokcronet/http/ResponseBody;", "contentType", "Lokcronet/http/MediaType;", "contentLength", "", "(Lokcronet/http/MediaType;J)V", "source", "Lokio/BufferedSource;", "msnet_release"})
    private static final class NoContentResponseBody
    extends ResponseBody {
        @Nullable
        private final MediaType contentType;
        private final long contentLength;

        public NoContentResponseBody(@Nullable MediaType contentType, long contentLength) {
            this.contentType = contentType;
            this.contentLength = contentLength;
        }

        @Nullable
        public MediaType contentType() {
            return this.contentType;
        }

        public long contentLength() {
            return this.contentLength;
        }

        @NotNull
        public BufferedSource source() {
            throw new IllegalStateException("Cannot read raw response body of a converted body.");
        }
    }
}

