/*
 * Decompiled with CFR 0.152.
 */
package msnet;

import android.annotation.TargetApi;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import androidx.annotation.ChecksSdkIntAtLeast;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import msnet.CallAdapter;
import msnet.CompletableFutureCallAdapterFactory;
import msnet.Converter;
import msnet.DefaultCallAdapterFactory;
import msnet.OptionalConverterFactory;
import org.jetbrains.annotations.Nullable;

abstract class Platform {
    private static final Platform PLATFORM = Platform.createPlatform();

    Platform() {
    }

    static Platform get() {
        return PLATFORM;
    }

    private static Platform createPlatform() {
        if (Build.VERSION.SDK_INT >= 24) {
            return new Android24();
        }
        return new Android21();
    }

    @Nullable
    abstract Executor defaultCallbackExecutor();

    abstract List<? extends CallAdapter.Factory> createDefaultCallAdapterFactories(@Nullable Executor var1);

    abstract List<? extends Converter.Factory> createDefaultConverterFactories();

    abstract boolean isDefaultMethod(Method var1);

    @Nullable
    abstract Object invokeDefaultMethod(Method var1, Class<?> var2, Object var3, Object ... var4) throws Throwable;

    private static final class MainThreadExecutor
    implements Executor {
        static final Executor INSTANCE = new MainThreadExecutor();
        private final Handler handler = new Handler(Looper.getMainLooper());

        private MainThreadExecutor() {
        }

        @Override
        public void execute(Runnable r) {
            this.handler.post(r);
        }
    }

    @TargetApi(value=24)
    private static final class Android24
    extends Platform {
        @ChecksSdkIntAtLeast(api=24)
        @Nullable
        private Constructor<MethodHandles.Lookup> lookupConstructor;

        private Android24() {
        }

        @Override
        Executor defaultCallbackExecutor() {
            return MainThreadExecutor.INSTANCE;
        }

        @Override
        List<? extends CallAdapter.Factory> createDefaultCallAdapterFactories(@Nullable Executor callbackExecutor) {
            return Arrays.asList(new CompletableFutureCallAdapterFactory(), new DefaultCallAdapterFactory(callbackExecutor));
        }

        @Override
        List<? extends Converter.Factory> createDefaultConverterFactories() {
            return Collections.singletonList(new OptionalConverterFactory());
        }

        @Override
        public boolean isDefaultMethod(Method method) {
            return method.isDefault();
        }

        @Override
        @Nullable
        public Object invokeDefaultMethod(Method method, Class<?> declaringClass, Object proxy, Object ... args) throws Throwable {
            if (Build.VERSION.SDK_INT < 26) {
                throw new UnsupportedOperationException("Calling default methods on API 24 and 25 is not supported");
            }
            Constructor<MethodHandles.Lookup> lookupConstructor = this.lookupConstructor;
            if (lookupConstructor == null) {
                lookupConstructor = MethodHandles.Lookup.class.getDeclaredConstructor(Class.class, Integer.TYPE);
                lookupConstructor.setAccessible(true);
                this.lookupConstructor = lookupConstructor;
            }
            return lookupConstructor.newInstance(declaringClass, -1).unreflectSpecial(method, declaringClass).bindTo(proxy).invokeWithArguments(args);
        }
    }

    private static final class Android21
    extends Platform {
        private Android21() {
        }

        @Override
        boolean isDefaultMethod(Method method) {
            return false;
        }

        @Override
        @Nullable
        Object invokeDefaultMethod(Method method, Class<?> declaringClass, Object proxy, Object ... args) {
            throw new AssertionError();
        }

        @Override
        Executor defaultCallbackExecutor() {
            return MainThreadExecutor.INSTANCE;
        }

        @Override
        List<? extends CallAdapter.Factory> createDefaultCallAdapterFactories(@Nullable Executor callbackExecutor) {
            return Collections.singletonList(new DefaultCallAdapterFactory(callbackExecutor));
        }

        @Override
        List<? extends Converter.Factory> createDefaultConverterFactories() {
            return Collections.emptyList();
        }
    }
}

