/*
 * Decompiled with CFR 0.152.
 */
package msnet;

import androidx.annotation.NonNull;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.concurrent.Executor;
import msnet.Call;
import msnet.CallAdapter;
import msnet.Callback;
import msnet.MSNet;
import msnet.Response;
import msnet.SkipCallbackExecutor;
import msnet.Utils;
import okcronet.http.Request;
import okio.Timeout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class DefaultCallAdapterFactory
extends CallAdapter.Factory {
    @Nullable
    private final Executor callbackExecutor;

    DefaultCallAdapterFactory(@Nullable Executor callbackExecutor) {
        this.callbackExecutor = callbackExecutor;
    }

    @Override
    @Nullable
    public CallAdapter<?, ?> get(@NonNull Type returnType, @NonNull Annotation[] annotations, @NonNull MSNet msNet) {
        if (DefaultCallAdapterFactory.getRawType(returnType) != Call.class) {
            return null;
        }
        if (!(returnType instanceof ParameterizedType)) {
            throw new IllegalArgumentException("Call return type must be parameterized as Call<Foo> or Call<? extends Foo>");
        }
        final Type responseType = Utils.getParameterUpperBound(0, (ParameterizedType)returnType);
        final Executor executor = Utils.isAnnotationPresent(annotations, SkipCallbackExecutor.class) ? null : this.callbackExecutor;
        return new CallAdapter<Object, Call<?>>(){

            @Override
            @NotNull
            public Type responseType() {
                return responseType;
            }

            @Override
            public Call<Object> adapt(@NotNull Call<Object> call) {
                return executor == null ? call : new ExecutorCallbackCall(executor, call);
            }
        };
    }

    static final class ExecutorCallbackCall<T>
    implements Call<T> {
        final Executor callbackExecutor;
        final Call<T> delegate;

        ExecutorCallbackCall(Executor callbackExecutor, Call<T> delegate) {
            this.callbackExecutor = callbackExecutor;
            this.delegate = delegate;
        }

        @Override
        public void enqueue(final @NotNull Callback<T> callback) {
            this.delegate.enqueue(new Callback<T>(){

                @Override
                public void onResponse(@NotNull Call<T> call, @NotNull Response<T> response) {
                    callbackExecutor.execute(() -> {
                        if (delegate.isCanceled()) {
                            callback.onFailure(this, new IOException("Canceled"));
                        } else {
                            callback.onResponse(this, response);
                        }
                    });
                }

                @Override
                public void onFailure(@NotNull Call<T> call, @NotNull Throwable t) {
                    callbackExecutor.execute(() -> callback.onFailure(this, t));
                }
            });
        }

        @Override
        public boolean isExecuted() {
            return this.delegate.isExecuted();
        }

        @Override
        @NotNull
        public Response<T> execute() throws IOException {
            return this.delegate.execute();
        }

        @Override
        public void cancel() {
            this.delegate.cancel();
        }

        @Override
        public boolean isCanceled() {
            return this.delegate.isCanceled();
        }

        @Override
        @NotNull
        public Call<T> clone() {
            return new ExecutorCallbackCall<T>(this.callbackExecutor, this.delegate.clone());
        }

        @Override
        @NotNull
        public Request request() {
            return this.delegate.request();
        }

        @Override
        public Timeout timeout() {
            return this.delegate.timeout();
        }
    }
}

