/*
 * Decompiled with CFR 0.152.
 */
package msnet;

import java.io.EOFException;
import java.io.IOException;
import java.util.regex.Pattern;
import okcronet.http.FormBody;
import okcronet.http.Headers;
import okcronet.http.HttpUrl;
import okcronet.http.MediaType;
import okcronet.http.MultipartBody;
import okcronet.http.Request;
import okcronet.http.RequestBody;
import okio.Buffer;
import okio.BufferedSink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class RequestBuilder {
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final String PATH_SEGMENT_ALWAYS_ENCODE_SET = " \"<>^`{}|\\?#";
    private static final Pattern PATH_TRAVERSAL = Pattern.compile("(.*/)?(\\.|%2e|%2E){1,2}(/.*)?");
    private final String method;
    private final HttpUrl baseUrl;
    @Nullable
    private String relativeUrl;
    @Nullable
    private HttpUrl.Builder urlBuilder;
    private final Request.Builder requestBuilder = new Request.Builder();
    private final Headers.Builder headersBuilder;
    @Nullable
    private MediaType contentType;
    private final boolean hasBody;
    @Nullable
    private MultipartBody.Builder multipartBuilder;
    @Nullable
    private FormBody.Builder formBuilder;
    @Nullable
    private RequestBody body;
    private final int priority;
    private final boolean disableCache;

    RequestBuilder(String method, int priority, boolean disableCache, HttpUrl baseUrl, @Nullable String relativeUrl, @Nullable Headers headers, @Nullable MediaType contentType, boolean hasBody, boolean isFormEncoded, boolean isMultipart) {
        this.method = method;
        this.priority = priority;
        this.disableCache = disableCache;
        this.baseUrl = baseUrl;
        this.relativeUrl = relativeUrl;
        this.contentType = contentType;
        this.hasBody = hasBody;
        this.headersBuilder = headers != null ? headers.newBuilder() : new Headers.Builder();
        if (isFormEncoded) {
            this.formBuilder = new FormBody.Builder();
        } else if (isMultipart) {
            this.multipartBuilder = new MultipartBody.Builder();
            this.multipartBuilder.setType(MultipartBody.FORM);
        }
    }

    void setRelativeUrl(Object relativeUrl) {
        this.relativeUrl = relativeUrl.toString();
    }

    void addHeader(String name, String value, boolean allowUnsafeNonAsciiValues) {
        if ("Content-Type".equalsIgnoreCase(name)) {
            try {
                this.contentType = MediaType.toMediaType((String)value);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Malformed content type: " + value, e);
            }
        } else if (allowUnsafeNonAsciiValues) {
            this.headersBuilder.addUnsafeNonAscii(name, value);
        } else {
            this.headersBuilder.add(name, value);
        }
    }

    void addHeaders(Headers headers) {
        this.headersBuilder.addAll(headers);
    }

    void addPathParam(String name, String value, boolean encoded) {
        if (this.relativeUrl == null) {
            throw new AssertionError();
        }
        String replacement = RequestBuilder.canonicalizeForPath(value, encoded);
        String newRelativeUrl = this.relativeUrl.replace("{" + name + "}", replacement);
        if (PATH_TRAVERSAL.matcher(newRelativeUrl).matches()) {
            throw new IllegalArgumentException("@Path parameters shouldn't perform path traversal ('.' or '..'): " + value);
        }
        this.relativeUrl = newRelativeUrl;
    }

    private static String canonicalizeForPath(String input, boolean alreadyEncoded) {
        int codePoint;
        int limit = input.length();
        for (int i = 0; i < limit; i += Character.charCount(codePoint)) {
            codePoint = input.codePointAt(i);
            if (codePoint >= 32 && codePoint < 127 && PATH_SEGMENT_ALWAYS_ENCODE_SET.indexOf(codePoint) == -1 && (alreadyEncoded || codePoint != 47 && codePoint != 37)) continue;
            Buffer out = new Buffer();
            out.writeUtf8(input, 0, i);
            RequestBuilder.canonicalizeForPath(out, input, i, limit, alreadyEncoded);
            return out.readUtf8();
        }
        return input;
    }

    private static void canonicalizeForPath(Buffer out, String input, int pos, int limit, boolean alreadyEncoded) {
        int codePoint;
        Buffer utf8Buffer = null;
        for (int i = pos; i < limit; i += Character.charCount(codePoint)) {
            codePoint = input.codePointAt(i);
            if (alreadyEncoded && (codePoint == 9 || codePoint == 10 || codePoint == 12 || codePoint == 13)) continue;
            if (codePoint < 32 || codePoint >= 127 || PATH_SEGMENT_ALWAYS_ENCODE_SET.indexOf(codePoint) != -1 || !alreadyEncoded && (codePoint == 47 || codePoint == 37)) {
                if (utf8Buffer == null) {
                    utf8Buffer = new Buffer();
                }
                utf8Buffer.writeUtf8CodePoint(codePoint);
                while (!utf8Buffer.exhausted()) {
                    int b;
                    try {
                        b = utf8Buffer.readByte() & 0xFF;
                    }
                    catch (EOFException e) {
                        throw new RuntimeException(e);
                    }
                    out.writeByte(37);
                    out.writeByte((int)HEX_DIGITS[b >> 4 & 0xF]);
                    out.writeByte((int)HEX_DIGITS[b & 0xF]);
                }
                continue;
            }
            out.writeUtf8CodePoint(codePoint);
        }
    }

    void addQueryParam(String name, @Nullable String value, boolean encoded) {
        if (this.relativeUrl != null) {
            this.urlBuilder = this.baseUrl.newBuilder(this.relativeUrl);
            if (this.urlBuilder == null) {
                throw new IllegalArgumentException("Malformed URL. Base: " + this.baseUrl + ", Relative: " + this.relativeUrl);
            }
            this.relativeUrl = null;
        }
        if (encoded) {
            this.urlBuilder.addEncodedQueryParameter(name, value);
        } else {
            this.urlBuilder.addQueryParameter(name, value);
        }
    }

    void addFormField(String name, String value, boolean encoded) {
        assert (this.formBuilder != null);
        if (encoded) {
            this.formBuilder.addEncoded(name, value);
        } else {
            this.formBuilder.add(name, value);
        }
    }

    void addPart(Headers headers, RequestBody body) {
        if (this.multipartBuilder != null) {
            this.multipartBuilder.addPart(headers, body);
        }
    }

    void addPart(MultipartBody.Part part) {
        if (this.multipartBuilder != null) {
            this.multipartBuilder.addPart(part);
        }
    }

    void setBody(@Nullable RequestBody body) {
        this.body = body;
    }

    <T> void addTag(Class<T> cls, @Nullable T value) {
        this.requestBuilder.tag(cls, value);
    }

    Request.Builder get() {
        MediaType contentType;
        HttpUrl url;
        HttpUrl.Builder urlBuilder = this.urlBuilder;
        if (urlBuilder != null) {
            url = urlBuilder.build();
        } else {
            url = this.baseUrl.resolve(this.relativeUrl);
            if (url == null) {
                throw new IllegalArgumentException("Malformed URL. Base: " + this.baseUrl + ", Relative: " + this.relativeUrl);
            }
        }
        RequestBody body = this.body;
        if (body == null) {
            if (this.formBuilder != null) {
                body = this.formBuilder.build();
            } else if (this.multipartBuilder != null) {
                body = this.multipartBuilder.build();
            } else if (this.hasBody) {
                body = RequestBody.Companion.getEMPTY_REQUEST_BODY();
            }
        }
        if ((contentType = this.contentType) != null) {
            if (body != null) {
                body = new ContentTypeOverridingRequestBody(body, contentType);
            } else {
                this.headersBuilder.add("Content-Type", contentType.toString());
            }
        }
        if (this.disableCache) {
            this.requestBuilder.disableCache();
        }
        return this.requestBuilder.headers(this.headersBuilder.build()).method(this.method, body).priority(this.priority).url(url);
    }

    private static class ContentTypeOverridingRequestBody
    extends RequestBody {
        private final RequestBody delegate;
        private final MediaType contentType;

        ContentTypeOverridingRequestBody(RequestBody delegate, MediaType contentType) {
            this.delegate = delegate;
            this.contentType = contentType;
        }

        public MediaType contentType() {
            return this.contentType;
        }

        public long length() throws IOException {
            return this.delegate.length();
        }

        public void writeTo(@NotNull BufferedSink sink) throws IOException {
            this.delegate.writeTo(sink);
        }
    }
}

