/*
 * Decompiled with CFR 0.152.
 */
package msnet;

import android.annotation.TargetApi;
import androidx.annotation.NonNull;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.concurrent.CompletableFuture;
import msnet.Call;
import msnet.CallAdapter;
import msnet.Callback;
import msnet.HttpException;
import msnet.MSNet;
import msnet.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@TargetApi(value=24)
final class CompletableFutureCallAdapterFactory
extends CallAdapter.Factory {
    CompletableFutureCallAdapterFactory() {
    }

    @Override
    @Nullable
    public CallAdapter<?, ?> get(@NonNull Type returnType, @NonNull Annotation[] annotations, @NonNull MSNet msNet) {
        if (CompletableFutureCallAdapterFactory.getRawType(returnType) != CompletableFuture.class) {
            return null;
        }
        if (!(returnType instanceof ParameterizedType)) {
            throw new IllegalStateException("CompletableFuture return type must be parameterized as CompletableFuture<Foo> or CompletableFuture<? extends Foo>");
        }
        Type innerType = CompletableFutureCallAdapterFactory.getParameterUpperBound(0, (ParameterizedType)returnType);
        if (CompletableFutureCallAdapterFactory.getRawType(innerType) != Response.class) {
            return new BodyCallAdapter(innerType);
        }
        if (!(innerType instanceof ParameterizedType)) {
            throw new IllegalStateException("Response must be parameterized as Response<Foo> or Response<? extends Foo>");
        }
        Type responseType = CompletableFutureCallAdapterFactory.getParameterUpperBound(0, (ParameterizedType)innerType);
        return new ResponseCallAdapter(responseType);
    }

    private static final class CallCancelCompletableFuture<T>
    extends CompletableFuture<T> {
        private final Call<?> call;

        CallCancelCompletableFuture(Call<?> call) {
            this.call = call;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            if (mayInterruptIfRunning) {
                this.call.cancel();
            }
            return super.cancel(mayInterruptIfRunning);
        }
    }

    private static final class ResponseCallAdapter<R>
    implements CallAdapter<R, CompletableFuture<Response<R>>> {
        private final Type responseType;

        ResponseCallAdapter(Type responseType) {
            this.responseType = responseType;
        }

        @Override
        @NotNull
        public Type responseType() {
            return this.responseType;
        }

        @Override
        public CompletableFuture<Response<R>> adapt(@NotNull Call<R> call) {
            CallCancelCompletableFuture future = new CallCancelCompletableFuture(call);
            call.enqueue(new ResponseCallback(future));
            return future;
        }

        private class ResponseCallback
        implements Callback<R> {
            private final CompletableFuture<Response<R>> future;

            public ResponseCallback(CompletableFuture<Response<R>> future) {
                this.future = future;
            }

            @Override
            public void onResponse(@NotNull Call<R> call, @NotNull Response<R> response) {
                this.future.complete(response);
            }

            @Override
            public void onFailure(@NotNull Call<R> call, @NotNull Throwable t) {
                this.future.completeExceptionally(t);
            }
        }
    }

    private static final class BodyCallAdapter<R>
    implements CallAdapter<R, CompletableFuture<R>> {
        private final Type responseType;

        BodyCallAdapter(Type responseType) {
            this.responseType = responseType;
        }

        @Override
        @NotNull
        public Type responseType() {
            return this.responseType;
        }

        @Override
        public CompletableFuture<R> adapt(@NotNull Call<R> call) {
            CallCancelCompletableFuture future = new CallCancelCompletableFuture(call);
            call.enqueue(new BodyCallback(future));
            return future;
        }

        private class BodyCallback
        implements Callback<R> {
            private final CompletableFuture<R> future;

            public BodyCallback(CompletableFuture<R> future) {
                this.future = future;
            }

            @Override
            public void onResponse(@NotNull Call<R> call, @NotNull Response<R> response) {
                if (response.isSuccessful()) {
                    this.future.complete(response.body());
                } else {
                    this.future.completeExceptionally(new HttpException(response));
                }
            }

            @Override
            public void onFailure(@NotNull Call<R> call, @NotNull Throwable t) {
                this.future.completeExceptionally(t);
            }
        }
    }
}

