/*
 * Decompiled with CFR 0.152.
 */
package msnet;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import kotlin.coroutines.Continuation;
import msnet.Call;
import msnet.CallAdapter;
import msnet.Converter;
import msnet.KotlinExtensionsKt;
import msnet.MSNet;
import msnet.MsCall;
import msnet.RequestFactory;
import msnet.Response;
import msnet.ServiceMethod;
import msnet.SkipCallbackExecutorImpl;
import msnet.Utils;
import okcronet.Call;
import okcronet.http.ResponseBody;
import org.jetbrains.annotations.Nullable;

abstract class HttpServiceMethod<ResponseT, ReturnT>
extends ServiceMethod<ReturnT> {
    private final RequestFactory requestFactory;
    private final Converter<ResponseBody, ResponseT> responseConverter;
    private final Call.Factory callFactory;

    static <ResponseT, ReturnT> HttpServiceMethod<ResponseT, ReturnT> parseAnnotations(MSNet MSNet2, Method method, RequestFactory requestFactory, Call.Factory callFactory) {
        Type adapterType;
        Type responseType;
        boolean isKotlinSuspendFunction = requestFactory.isKotlinSuspendFunction;
        boolean continuationWantsResponse = false;
        boolean continuationBodyNullable = false;
        boolean continuationIsUnit = false;
        Annotation[] annotations = method.getAnnotations();
        if (isKotlinSuspendFunction) {
            Type[] parameterTypes = method.getGenericParameterTypes();
            responseType = Utils.getParameterLowerBound(0, (ParameterizedType)parameterTypes[parameterTypes.length - 1]);
            if (Utils.getRawType(responseType) == Response.class && responseType instanceof ParameterizedType) {
                responseType = Utils.getParameterUpperBound(0, (ParameterizedType)responseType);
                continuationWantsResponse = true;
            } else {
                continuationIsUnit = Utils.isUnit(responseType);
            }
            adapterType = new Utils.ParameterizedTypeImpl(null, (Type)((Object)Call.class), responseType);
            annotations = SkipCallbackExecutorImpl.ensurePresent(annotations);
        } else {
            adapterType = method.getGenericReturnType();
        }
        CallAdapter<ResponseT, ReturnT> callAdapter = HttpServiceMethod.createCallAdapter(MSNet2, method, adapterType, annotations);
        responseType = callAdapter.responseType();
        if (responseType == okcronet.http.Response.class) {
            throw Utils.methodError(method, "'" + Utils.getRawType(responseType).getName() + "' is not a valid response body type. Did you mean ResponseBody?", new Object[0]);
        }
        if (responseType == Response.class) {
            throw Utils.methodError(method, "Response must include generic type (e.g., Response<String>)", new Object[0]);
        }
        if (requestFactory.httpMethod.equals("HEAD") && !Void.class.equals((Object)responseType) && !Utils.isUnit(responseType)) {
            throw Utils.methodError(method, "HEAD method must use Void or Unit as response type.", new Object[0]);
        }
        Converter<ResponseBody, ResponseT> responseConverter = HttpServiceMethod.createResponseConverter(MSNet2, method, responseType);
        if (!isKotlinSuspendFunction) {
            return new CallAdapted<ResponseT, ReturnT>(requestFactory, callFactory, responseConverter, callAdapter);
        }
        if (continuationWantsResponse) {
            return new SuspendForResponse<ResponseT>(requestFactory, callFactory, responseConverter, callAdapter);
        }
        return new SuspendForBody<ResponseT>(requestFactory, callFactory, responseConverter, callAdapter, continuationBodyNullable, continuationIsUnit);
    }

    private static <ResponseT, ReturnT> CallAdapter<ResponseT, ReturnT> createCallAdapter(MSNet MSNet2, Method method, Type returnType, Annotation[] annotations) {
        try {
            return MSNet2.callAdapter(returnType, annotations);
        }
        catch (RuntimeException e) {
            throw Utils.methodError(method, e, "Unable to create call adapter for %s", returnType);
        }
    }

    private static <ResponseT> Converter<ResponseBody, ResponseT> createResponseConverter(MSNet MSNet2, Method method, Type responseType) {
        Annotation[] annotations = method.getAnnotations();
        try {
            return MSNet2.responseBodyConverter(responseType, annotations);
        }
        catch (RuntimeException e) {
            throw Utils.methodError(method, e, "Unable to create converter for %s", responseType);
        }
    }

    HttpServiceMethod(RequestFactory requestFactory, Call.Factory callFactory, Converter<ResponseBody, ResponseT> responseConverter) {
        this.requestFactory = requestFactory;
        this.callFactory = callFactory;
        this.responseConverter = responseConverter;
    }

    @Override
    @Nullable
    final ReturnT invoke(Object[] args) {
        MsCall<ResponseT> call = new MsCall<ResponseT>(this.callFactory, this.requestFactory, args, this.responseConverter);
        return this.adapt(call, args);
    }

    @Nullable
    protected abstract ReturnT adapt(Call<ResponseT> var1, Object[] var2);

    static final class SuspendForBody<ResponseT>
    extends HttpServiceMethod<ResponseT, Object> {
        private final CallAdapter<ResponseT, Call<ResponseT>> callAdapter;
        private final boolean isNullable;

        SuspendForBody(RequestFactory requestFactory, Call.Factory callFactory, Converter<ResponseBody, ResponseT> responseConverter, CallAdapter<ResponseT, Call<ResponseT>> callAdapter, boolean isNullable, boolean isUnit) {
            super(requestFactory, callFactory, responseConverter);
            this.callAdapter = callAdapter;
            this.isNullable = isNullable;
        }

        @Override
        protected Object adapt(Call<ResponseT> call, Object[] args) {
            call = this.callAdapter.adapt(call);
            Continuation continuation = (Continuation)args[args.length - 1];
            return this.isNullable ? KotlinExtensionsKt.awaitNullable(call, continuation) : KotlinExtensionsKt.await(call, continuation);
        }
    }

    static final class SuspendForResponse<ResponseT>
    extends HttpServiceMethod<ResponseT, Object> {
        private final CallAdapter<ResponseT, Call<ResponseT>> callAdapter;

        SuspendForResponse(RequestFactory requestFactory, Call.Factory callFactory, Converter<ResponseBody, ResponseT> responseConverter, CallAdapter<ResponseT, Call<ResponseT>> callAdapter) {
            super(requestFactory, callFactory, responseConverter);
            this.callAdapter = callAdapter;
        }

        @Override
        protected Object adapt(Call<ResponseT> call, Object[] args) {
            call = this.callAdapter.adapt(call);
            Continuation continuation = (Continuation)args[args.length - 1];
            return KotlinExtensionsKt.awaitResponse(call, continuation);
        }
    }

    static final class CallAdapted<ResponseT, ReturnT>
    extends HttpServiceMethod<ResponseT, ReturnT> {
        private final CallAdapter<ResponseT, ReturnT> callAdapter;

        CallAdapted(RequestFactory requestFactory, Call.Factory callFactory, Converter<ResponseBody, ResponseT> responseConverter, CallAdapter<ResponseT, ReturnT> callAdapter) {
            super(requestFactory, callFactory, responseConverter);
            this.callAdapter = callAdapter;
        }

        @Override
        protected ReturnT adapt(Call<ResponseT> call, Object[] args) {
            return this.callAdapter.adapt(call);
        }
    }
}

