/*
 * Decompiled with CFR 0.152.
 */
package okcronet;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okcronet.AnnotationRequestInfo;
import okcronet.CronetClient;
import okcronet.DirectExecutor;
import okcronet.Interceptor;
import okcronet.ResponseCallback;
import okcronet.UploadDataHelper;
import okcronet.http.Cookie;
import okcronet.http.CookieJar;
import okcronet.http.Headers;
import okcronet.http.Request;
import okcronet.http.RequestBody;
import okcronet.http.Response;
import org.chromium.net.UrlRequest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u000f"}, d2={"Lokcronet/CallCronetInterceptor;", "Lokcronet/Interceptor;", "client", "Lokcronet/CronetClient;", "(Lokcronet/CronetClient;)V", "urlRequest", "Lorg/chromium/net/UrlRequest;", "getUrlRequest", "()Lorg/chromium/net/UrlRequest;", "setUrlRequest", "(Lorg/chromium/net/UrlRequest;)V", "intercept", "Lokcronet/http/Response;", "chain", "Lokcronet/Interceptor$Chain;", "okcronet_release"})
@SourceDebugExtension(value={"SMAP\nCallCronetInterceptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CallCronetInterceptor.kt\nokcronet/CallCronetInterceptor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,119:1\n1855#2,2:120\n*S KotlinDebug\n*F\n+ 1 CallCronetInterceptor.kt\nokcronet/CallCronetInterceptor\n*L\n57#1:120,2\n*E\n"})
public final class CallCronetInterceptor
implements Interceptor {
    @NotNull
    private final CronetClient client;
    @Nullable
    private UrlRequest urlRequest;

    public CallCronetInterceptor(@NotNull CronetClient client) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        this.client = client;
    }

    @Nullable
    public final UrlRequest getUrlRequest() {
        return this.urlRequest;
    }

    public final void setUrlRequest(@Nullable UrlRequest urlRequest) {
        this.urlRequest = urlRequest;
    }

    @Override
    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) {
        ResponseCallback callback;
        block15: {
            Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
            Request request = chain.request();
            callback = new ResponseCallback(request, this.client.getReadTimeoutMillis(), this.client.getCookieJar());
            UrlRequest.Builder builder = this.client.getCronetEngine().newUrlRequestBuilder(request.getUrl().toString(), (UrlRequest.Callback)callback, (Executor)DirectExecutor.INSTANCE).allowDirectExecutor().setPriority(request.getPriority()).setHttpMethod(request.getMethod()).addRequestAnnotation((Object)new AnnotationRequestInfo(request.getMethod(), request.getPriority())).setRequestFinishedListener(this.client.getRequestFinishedInfoListener());
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"setRequestFinishedListener(...)");
            UrlRequest.Builder urlRequestBuilder = builder;
            Long l = this.client.getNetworkHandle();
            if (l != null) {
                long it = ((Number)l).longValue();
                boolean bl = false;
                urlRequestBuilder.bindToNetwork(it);
            }
            List<Object> list = this.client.getAnnotationList();
            if (list != null) {
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv.iterator();
                while (iterator.hasNext()) {
                    Object element$iv;
                    Object it = element$iv = iterator.next();
                    boolean bl = false;
                    urlRequestBuilder.addRequestAnnotation(it);
                }
            }
            if (request.getDisableCache()) {
                urlRequestBuilder.disableCache();
            }
            RequestBody requestBody = request.getBody();
            if (requestBody != null) {
                long element$iv;
                RequestBody it = requestBody;
                boolean bl = false;
                try {
                    element$iv = it.length();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                long contentLength = element$iv;
                if (contentLength > 0L) {
                    urlRequestBuilder.setUploadDataProvider(UploadDataHelper.Companion.getUploadDataProvider(it, this.client.getWriteTimeoutMillis()), (Executor)DirectExecutor.INSTANCE);
                }
            }
            Headers headers = null;
            headers = request.getHeaders();
            CookieJar cookieJar = this.client.getCookieJar();
            if (cookieJar != null) {
                CookieJar it = cookieJar;
                boolean bl = false;
                List<Cookie> cookies = it.load(request.getUrl());
                if (!((Collection)cookies).isEmpty()) {
                    StringBuilder stringBuilder = new StringBuilder();
                    for (Cookie cookie : cookies) {
                        stringBuilder.append(cookie.toString()).append(";");
                    }
                    if (((CharSequence)stringBuilder).length() > 0) {
                        Headers.Builder builder2 = headers.newBuilder();
                        String string = stringBuilder.toString();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                        headers = builder2.add("Cookie", string).build();
                    }
                }
            }
            int s = headers.getSize();
            for (int i = 0; i < s; ++i) {
                urlRequestBuilder.addHeader(headers.name(i), headers.value(i));
            }
            this.urlRequest = urlRequestBuilder.build();
            if (chain.call().isCanceled()) {
                UrlRequest urlRequest = this.urlRequest;
                if (urlRequest != null) {
                    urlRequest.cancel();
                }
                throw new IOException("This Request is canceled!");
            }
            UrlRequest urlRequest = this.urlRequest;
            if (urlRequest == null) break block15;
            urlRequest.start();
        }
        return callback.getResponse();
    }
}

