/*
 * Decompiled with CFR 0.152.
 */
package okcronet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import okcronet.Call;
import okcronet.CallCronetInterceptor;
import okcronet.Callback;
import okcronet.CronetClient;
import okcronet.CronetTransportResponseBody;
import okcronet.RealInterceptorChain;
import okcronet.http.Request;
import okcronet.http.Response;
import okcronet.http.ResponseBody;
import okio.AsyncTimeout;
import okio.Timeout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0001H\u0016J\u0010\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0013H\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001aH\u0002J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0010\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001aH\u0002R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lokcronet/RealCall;", "Lokcronet/Call;", "client", "Lokcronet/CronetClient;", "request", "Lokcronet/http/Request;", "(Lokcronet/CronetClient;Lokcronet/http/Request;)V", "callCronetInterceptor", "Lokcronet/CallCronetInterceptor;", "canceled", "Ljava/util/concurrent/atomic/AtomicBoolean;", "executed", "isCanceled", "", "()Z", "isExecuted", "timeout", "Lokio/AsyncTimeout;", "cancel", "", "clone", "enqueue", "responseCallback", "Lokcronet/Callback;", "evaluateExecutionPreconditions", "execute", "Lokcronet/http/Response;", "getResponseWithInterceptorChain", "Lokio/Timeout;", "toHookResponse", "response", "okcronet_release"})
public final class RealCall
implements Call {
    @NotNull
    private final CronetClient client;
    @NotNull
    private final Request request;
    @Nullable
    private CallCronetInterceptor callCronetInterceptor;
    @NotNull
    private final AtomicBoolean executed;
    @NotNull
    private final AtomicBoolean canceled;
    @NotNull
    private final AsyncTimeout timeout;

    public RealCall(@NotNull CronetClient client, @NotNull Request request) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        this.client = client;
        this.request = request;
        this.executed = new AtomicBoolean(false);
        this.canceled = new AtomicBoolean(false);
        this.timeout = new AsyncTimeout(){

            protected void timedOut() {
                this.cancel();
            }
        };
        this.timeout.timeout(this.client.getCallTimeoutMillis(), TimeUnit.MILLISECONDS);
    }

    @Override
    @NotNull
    public Request request() {
        return this.request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Response execute() {
        this.evaluateExecutionPreconditions();
        try {
            this.timeout.enter();
            Response response = this.toHookResponse(this.getResponseWithInterceptorChain());
            return response;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            this.timeout.exit();
        }
    }

    @Override
    public void enqueue(@NotNull Callback responseCallback) {
        Intrinsics.checkNotNullParameter((Object)responseCallback, (String)"responseCallback");
        this.evaluateExecutionPreconditions();
        this.timeout.enter();
        this.client.getResponseCallbackExecutor().execute(() -> RealCall.enqueue$lambda$0(this, responseCallback));
    }

    @Override
    public void cancel() {
        if (!this.canceled.getAndSet(true)) {
            CallCronetInterceptor callCronetInterceptor = this.callCronetInterceptor;
            if (callCronetInterceptor != null && (callCronetInterceptor = callCronetInterceptor.getUrlRequest()) != null) {
                callCronetInterceptor.cancel();
            }
            this.timeout.exit();
        }
    }

    @Override
    public boolean isExecuted() {
        return this.executed.get();
    }

    @Override
    public boolean isCanceled() {
        return this.canceled.get();
    }

    @Override
    @NotNull
    public Timeout timeout() {
        return (Timeout)this.timeout;
    }

    @Override
    @NotNull
    public Call clone() {
        return new RealCall(this.client, this.request);
    }

    /*
     * WARNING - void declaration
     */
    private final Response getResponseWithInterceptorChain() {
        void $this$getResponseWithInterceptorChain_u24lambda_u241;
        CallCronetInterceptor callCronetInterceptor;
        ArrayList interceptors = new ArrayList(this.client.getInterceptors().size() + 1);
        CollectionsKt.addAll((Collection)interceptors, (Iterable)this.client.getInterceptors());
        CallCronetInterceptor callCronetInterceptor2 = callCronetInterceptor = new CallCronetInterceptor(this.client);
        RealCall realCall = this;
        boolean bl = false;
        ((Collection)interceptors).add($this$getResponseWithInterceptorChain_u24lambda_u241);
        realCall.callCronetInterceptor = callCronetInterceptor;
        RealInterceptorChain chain = new RealInterceptorChain(this, interceptors, 0, this.request);
        return chain.proceed(this.request);
    }

    private final void evaluateExecutionPreconditions() throws IOException {
        if (this.canceled.get()) {
            throw new IOException("Can't execute canceled requests");
        }
        if (!(!this.executed.getAndSet(true))) {
            boolean bl = false;
            String string = "Already Executed";
            throw new IllegalStateException(string.toString());
        }
        CallCronetInterceptor callCronetInterceptor = this.callCronetInterceptor;
        if (callCronetInterceptor != null && (callCronetInterceptor = callCronetInterceptor.getUrlRequest()) != null) {
            CallCronetInterceptor it = callCronetInterceptor;
            boolean bl = false;
            if (!(!it.isDone())) {
                boolean bl2 = false;
                String string = "The request was successfully started and is now finished (completed, canceled, or failed)";
                throw new IllegalStateException(string.toString());
            }
        }
    }

    private final Response toHookResponse(Response response) {
        ResponseBody responseBody = response.getBody();
        if (responseBody == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        ResponseBody it = responseBody;
        boolean bl = false;
        return response.newBuilder().body(new CronetTransportResponseBody(it, this){
            final /* synthetic */ RealCall this$0;
            {
                this.this$0 = $receiver;
                super($it);
            }

            protected void customCloseHook() {
                RealCall.access$getTimeout$p(this.this$0).exit();
            }
        }).build();
    }

    private static final void enqueue$lambda$0(RealCall this$0, Callback $responseCallback) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$responseCallback, (String)"$responseCallback");
        try {
            Response response = this$0.getResponseWithInterceptorChain();
            this$0.timeout.exit();
            $responseCallback.onResponse(this$0, this$0.toHookResponse(response));
        }
        catch (ExecutionException e) {
            this$0.timeout.exit();
            Call call = this$0;
            Throwable throwable = e.getCause();
            if (throwable == null) {
                throwable = e;
            }
            $responseCallback.onFailure(call, new IOException(throwable));
            return;
        }
        catch (IOException e) {
            this$0.timeout.exit();
            $responseCallback.onFailure(this$0, e);
            return;
        }
        catch (Throwable e) {
            this$0.timeout.exit();
            $responseCallback.onFailure(this$0, new IOException(e));
            return;
        }
    }

    public static final /* synthetic */ AsyncTimeout access$getTimeout$p(RealCall $this) {
        return $this.timeout;
    }
}

