/*
 * Decompiled with CFR 0.152.
 */
package okcronet;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okcronet.CompletableFutureCompat;
import okcronet.CronetTimeoutException;
import okcronet.UtilKt;
import okcronet.http.Cookie;
import okcronet.http.CookieJar;
import okcronet.http.Headers;
import okcronet.http.HttpUrl;
import okio.Buffer;
import okio.BufferedSink;
import okio.Okio;
import okio.Sink;
import okio.Source;
import okio.Timeout;
import org.chromium.net.CronetException;
import org.chromium.net.UrlRequest;
import org.chromium.net.UrlResponseInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u0000 42\u00020\u0001:\u000245B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010#\u001a\u00020$J\u001a\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\b\u0010)\u001a\u0004\u0018\u00010\u0012H\u0016J\"\u0010*\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\b\u0010\u001e\u001a\u0004\u0018\u00010\u00122\u0006\u0010+\u001a\u00020,H\u0016J \u0010-\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010\u001e\u001a\u00020\u00122\u0006\u0010.\u001a\u00020/H\u0016J \u00100\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010\u001e\u001a\u00020\u00122\u0006\u00101\u001a\u00020\u0014H\u0016J\u0018\u00102\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010\u001e\u001a\u00020\u0012H\u0016J\u0018\u00103\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010\u001e\u001a\u00020\u0012H\u0016R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0017\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0017\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00100\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0017\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00120\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u001d\u00a8\u00066"}, d2={"Lokcronet/SourceCallback;", "Lorg/chromium/net/UrlRequest$Callback;", "readTimeoutMillis", "", "(J)V", "cookieJar", "Lokcronet/http/CookieJar;", "(JLokcronet/http/CookieJar;)V", "code", "", "getCode", "()I", "cronetBodySource", "Lokcronet/SourceCallback$CronetBodySource;", "mSourceFuture", "Lokcronet/CompletableFutureCompat;", "Lokio/Source;", "mUrlResponseInfo", "Lorg/chromium/net/UrlResponseInfo;", "message", "", "getMessage", "()Ljava/lang/String;", "source", "getSource", "()Lokio/Source;", "sourceFuture", "Ljava/util/concurrent/Future;", "getSourceFuture", "()Ljava/util/concurrent/Future;", "urlResponseInfo", "getUrlResponseInfo", "()Lorg/chromium/net/UrlResponseInfo;", "urlResponseInfoFuture", "getUrlResponseInfoFuture", "isSuccess", "", "onCanceled", "", "urlRequest", "Lorg/chromium/net/UrlRequest;", "responseInfo", "onFailed", "e", "Lorg/chromium/net/CronetException;", "onReadCompleted", "byteBuffer", "Ljava/nio/ByteBuffer;", "onRedirectReceived", "nextUrl", "onResponseStarted", "onSucceeded", "Companion", "CronetBodySource", "okcronet_release"})
@SourceDebugExtension(value={"SMAP\nSourceCallback.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SourceCallback.kt\nokcronet/SourceCallback\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,407:1\n1855#2,2:408\n*S KotlinDebug\n*F\n+ 1 SourceCallback.kt\nokcronet/SourceCallback\n*L\n170#1:408,2\n*E\n"})
public class SourceCallback
extends UrlRequest.Callback {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final CookieJar cookieJar;
    @NotNull
    private final CompletableFutureCompat<Source> mSourceFuture;
    @NotNull
    private final CompletableFutureCompat<UrlResponseInfo> mUrlResponseInfo;
    private final long readTimeoutMillis;
    @Nullable
    private volatile CronetBodySource cronetBodySource;
    private static final int CRONET_BYTE_BUFFER_CAPACITY = 32768;

    public SourceCallback(long readTimeoutMillis, @Nullable CookieJar cookieJar) {
        this.cookieJar = cookieJar;
        this.mSourceFuture = new CompletableFutureCompat();
        this.mUrlResponseInfo = new CompletableFutureCompat();
        if (!(readTimeoutMillis >= 0L)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.readTimeoutMillis = readTimeoutMillis == 0L ? Long.MAX_VALUE : readTimeoutMillis;
    }

    public SourceCallback(long readTimeoutMillis) {
        this(readTimeoutMillis, null);
    }

    @NotNull
    public final Future<Source> getSourceFuture() {
        return this.mSourceFuture;
    }

    @NotNull
    public final Source getSource() throws IOException {
        return (Source)UtilKt.getValue((Future)this.mSourceFuture);
    }

    @NotNull
    public final Future<UrlResponseInfo> getUrlResponseInfoFuture() {
        return this.mUrlResponseInfo;
    }

    @NotNull
    public final UrlResponseInfo getUrlResponseInfo() throws IOException {
        return (UrlResponseInfo)UtilKt.getValue((Future)this.mUrlResponseInfo);
    }

    public final int getCode() {
        return ((UrlResponseInfo)UtilKt.getValue((Future)this.mUrlResponseInfo)).getHttpStatusCode();
    }

    public final boolean isSuccess() {
        int n = this.getCode();
        return 200 <= n ? n < 300 : false;
    }

    @NotNull
    public final String getMessage() {
        String string = ((UrlResponseInfo)UtilKt.getValue((Future)this.mUrlResponseInfo)).getHttpStatusText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHttpStatusText(...)");
        return string;
    }

    public void onRedirectReceived(@NotNull UrlRequest urlRequest, @NotNull UrlResponseInfo urlResponseInfo, @NotNull String nextUrl) {
        Intrinsics.checkNotNullParameter((Object)urlRequest, (String)"urlRequest");
        Intrinsics.checkNotNullParameter((Object)urlResponseInfo, (String)"urlResponseInfo");
        Intrinsics.checkNotNullParameter((Object)nextUrl, (String)"nextUrl");
        urlRequest.followRedirect();
    }

    /*
     * WARNING - void declaration
     */
    public void onResponseStarted(@NotNull UrlRequest urlRequest, @NotNull UrlResponseInfo urlResponseInfo) {
        void $this$onResponseStarted_u24lambda_u240;
        CronetBodySource cronetBodySource;
        Intrinsics.checkNotNullParameter((Object)urlRequest, (String)"urlRequest");
        Intrinsics.checkNotNullParameter((Object)urlResponseInfo, (String)"urlResponseInfo");
        CronetBodySource cronetBodySource2 = cronetBodySource = new CronetBodySource(urlRequest, this.readTimeoutMillis);
        SourceCallback sourceCallback = this;
        boolean bl = false;
        if (!this.mSourceFuture.complete((Source)$this$onResponseStarted_u24lambda_u240)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        if (!this.mUrlResponseInfo.complete(urlResponseInfo)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        sourceCallback.cronetBodySource = cronetBodySource;
    }

    public void onReadCompleted(@NotNull UrlRequest urlRequest, @NotNull UrlResponseInfo urlResponseInfo, @NotNull ByteBuffer byteBuffer) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)urlRequest, (String)"urlRequest");
            Intrinsics.checkNotNullParameter((Object)urlResponseInfo, (String)"urlResponseInfo");
            Intrinsics.checkNotNullParameter((Object)byteBuffer, (String)"byteBuffer");
            CronetBodySource cronetBodySource = this.cronetBodySource;
            if (cronetBodySource == null) break block0;
            cronetBodySource.add(new CronetBodySource.CronetResult.ReadCompleted(byteBuffer));
        }
    }

    public void onSucceeded(@NotNull UrlRequest urlRequest, @NotNull UrlResponseInfo urlResponseInfo) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)urlRequest, (String)"urlRequest");
            Intrinsics.checkNotNullParameter((Object)urlResponseInfo, (String)"urlResponseInfo");
            if (!urlResponseInfo.wasCached() && this.cookieJar != null) {
                List cronetHeaders = urlResponseInfo.getAllHeadersAsList();
                Intrinsics.checkNotNull((Object)cronetHeaders);
                if (!((Collection)cronetHeaders).isEmpty()) {
                    Headers.Builder headerBuilder = new Headers.Builder();
                    Iterable $this$forEach$iv = cronetHeaders;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        Map.Entry it = (Map.Entry)element$iv;
                        boolean bl = false;
                        Object k = it.getKey();
                        Intrinsics.checkNotNullExpressionValue(k, (String)"<get-key>(...)");
                        String string = ((Object)StringsKt.trim((CharSequence)((String)k))).toString();
                        Object v = it.getValue();
                        Intrinsics.checkNotNullExpressionValue(v, (String)"<get-value>(...)");
                        headerBuilder.add(string, ((Object)StringsKt.trim((CharSequence)((String)v))).toString());
                    }
                    String string = urlResponseInfo.getUrl();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrl(...)");
                    HttpUrl url = HttpUrl.Companion.toHttpUrl(string);
                    this.cookieJar.save(url, Cookie.Companion.parseAll(url, headerBuilder.build()));
                }
            }
            CronetBodySource cronetBodySource = this.cronetBodySource;
            if (cronetBodySource == null) break block3;
            cronetBodySource.add(CronetBodySource.CronetResult.Success.INSTANCE);
        }
    }

    public void onFailed(@NotNull UrlRequest urlRequest, @Nullable UrlResponseInfo urlResponseInfo, @NotNull CronetException e) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)urlRequest, (String)"urlRequest");
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            this.mUrlResponseInfo.completeExceptionally((Throwable)e);
            if (this.mSourceFuture.completeExceptionally((Throwable)e)) {
                return;
            }
            CronetBodySource cronetBodySource = this.cronetBodySource;
            if (cronetBodySource == null) break block1;
            cronetBodySource.add(new CronetBodySource.CronetResult.Failed(e));
        }
    }

    public void onCanceled(@NotNull UrlRequest urlRequest, @Nullable UrlResponseInfo responseInfo) {
        Intrinsics.checkNotNullParameter((Object)urlRequest, (String)"urlRequest");
        CronetBodySource cronetBodySource = this.cronetBodySource;
        if (cronetBodySource != null) {
            cronetBodySource.canceled();
        }
        CronetBodySource cronetBodySource2 = this.cronetBodySource;
        if (cronetBodySource2 != null) {
            cronetBodySource2.add(CronetBodySource.CronetResult.Canceled.INSTANCE);
        }
        IOException e = new IOException("The request was canceled!");
        this.mUrlResponseInfo.completeExceptionally(e);
        this.mSourceFuture.completeExceptionally(e);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\n\u0010\t\u001a\u00020\n*\u00020\u000bJ\u0012\u0010\f\u001a\u00020\r*\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0012\u0010\f\u001a\u00020\r*\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011J\u0012\u0010\f\u001a\u00020\r*\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lokcronet/SourceCallback$Companion;", "", "()V", "CRONET_BYTE_BUFFER_CAPACITY", "", "getCharsetFromHeaders", "Ljava/nio/charset/Charset;", "info", "Lorg/chromium/net/UrlResponseInfo;", "string", "", "Lokcronet/SourceCallback;", "writeTo", "", "file", "Ljava/io/File;", "outputStream", "Ljava/io/OutputStream;", "bufferedSink", "Lokio/BufferedSink;", "okcronet_release"})
    @SourceDebugExtension(value={"SMAP\nSourceCallback.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SourceCallback.kt\nokcronet/SourceCallback$Companion\n+ 2 Okio.kt\nokio/Okio__OkioKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,407:1\n66#2:408\n52#2,5:409\n66#2:414\n52#2,21:415\n60#2,10:436\n57#2,2:446\n71#2,2:448\n1855#3:450\n1855#3,2:451\n1856#3:453\n*S KotlinDebug\n*F\n+ 1 SourceCallback.kt\nokcronet/SourceCallback$Companion\n*L\n360#1:408\n360#1:409,5\n361#1:414\n361#1:415,21\n360#1:436,10\n360#1:446,2\n360#1:448,2\n394#1:450\n395#1:451,2\n394#1:453\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public final long writeTo(@NotNull SourceCallback $this$writeTo, @NotNull BufferedSink bufferedSink) {
            Throwable thrown$iv;
            Long result$iv;
            block28: {
                Throwable thrown$iv2;
                Long result$iv2;
                Closeable $this$use$iv;
                block27: {
                    long l;
                    Intrinsics.checkNotNullParameter((Object)((Object)$this$writeTo), (String)"<this>");
                    Intrinsics.checkNotNullParameter((Object)bufferedSink, (String)"bufferedSink");
                    $this$use$iv = (Closeable)bufferedSink;
                    boolean $i$f$use = false;
                    result$iv = null;
                    thrown$iv = null;
                    BufferedSink sink = (BufferedSink)$this$use$iv;
                    boolean bl = false;
                    Closeable $this$use$iv2 = (Closeable)$this$writeTo.getSource();
                    boolean $i$f$use2 = false;
                    result$iv2 = null;
                    thrown$iv2 = null;
                    Source s = (Source)$this$use$iv2;
                    boolean bl2 = false;
                    long $this$writeTo_u24lambda_u242_u24lambda_u241_u24lambda_u240 = l = sink.writeAll(s);
                    boolean bl3 = false;
                    sink.flush();
                    result$iv2 = l;
                    try {
                        Closeable closeable = $this$use$iv2;
                        if (closeable != null) {
                            closeable.close();
                        }
                        break block27;
                    }
                    catch (Throwable t$iv) {
                        thrown$iv2 = t$iv;
                    }
                    break block27;
                    catch (Throwable t$iv) {
                        try {
                            thrown$iv2 = t$iv;
                        }
                        catch (Throwable throwable) {
                            try {
                                Closeable closeable = $this$use$iv2;
                                if (closeable != null) {
                                    closeable.close();
                                }
                            }
                            catch (Throwable t$iv2) {
                                thrown$iv2 = t$iv2;
                            }
                            throw throwable;
                        }
                        try {
                            Closeable closeable = $this$use$iv2;
                            if (closeable != null) {
                                closeable.close();
                            }
                        }
                        catch (Throwable t$iv3) {
                            if (thrown$iv2 == null) {
                                thrown$iv2 = t$iv3;
                                break block27;
                            }
                            ExceptionsKt.addSuppressed((Throwable)thrown$iv2, (Throwable)t$iv3);
                        }
                    }
                }
                Throwable throwable = thrown$iv2;
                if (throwable != null) {
                    throw throwable;
                }
                Long l = result$iv2;
                Intrinsics.checkNotNull(l);
                result$iv = ((Number)l).longValue();
                try {
                    $this$use$iv.close();
                }
                catch (Throwable t$iv) {
                    thrown$iv = t$iv;
                }
                break block28;
                catch (Throwable t$iv) {
                    try {
                        thrown$iv = t$iv;
                    }
                    catch (Throwable throwable2) {
                        try {
                            $this$use$iv.close();
                        }
                        catch (Throwable t$iv4) {
                            thrown$iv = t$iv4;
                        }
                        throw throwable2;
                    }
                    try {
                        $this$use$iv.close();
                    }
                    catch (Throwable t$iv5) {
                        if (thrown$iv == null) {
                            thrown$iv = t$iv5;
                            break block28;
                        }
                        ExceptionsKt.addSuppressed((Throwable)thrown$iv, (Throwable)t$iv5);
                    }
                }
            }
            Throwable throwable = thrown$iv;
            if (throwable != null) {
                throw throwable;
            }
            Long l = result$iv;
            Intrinsics.checkNotNull(l);
            return ((Number)l).longValue();
        }

        public final long writeTo(@NotNull SourceCallback $this$writeTo, @NotNull OutputStream outputStream) {
            Intrinsics.checkNotNullParameter((Object)((Object)$this$writeTo), (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
            return this.writeTo($this$writeTo, Okio.buffer((Sink)Okio.sink((OutputStream)outputStream)));
        }

        public final long writeTo(@NotNull SourceCallback $this$writeTo, @NotNull File file) {
            Intrinsics.checkNotNullParameter((Object)((Object)$this$writeTo), (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            return this.writeTo($this$writeTo, Okio.buffer((Sink)Okio.sink$default((File)file, (boolean)false, (int)1, null)));
        }

        @NotNull
        public final String string(@NotNull SourceCallback $this$string) {
            Intrinsics.checkNotNullParameter((Object)((Object)$this$string), (String)"<this>");
            return Okio.buffer((Source)$this$string.getSource()).readString(this.getCharsetFromHeaders($this$string.getUrlResponseInfo()));
        }

        private final Charset getCharsetFromHeaders(UrlResponseInfo info) {
            List list = (List)info.getAllHeaders().get("Content-Type");
            if (list != null) {
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it);
                    String[] stringArray = new String[]{";"};
                    Iterable $this$forEach$iv2 = StringsKt.split$default((CharSequence)it, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv2 : $this$forEach$iv2) {
                        String type = (String)element$iv2;
                        boolean bl2 = false;
                        if (!StringsKt.startsWith((String)((Object)StringsKt.trim((CharSequence)type)).toString(), (String)"charset", (boolean)true)) continue;
                        String[] stringArray2 = new String[]{"="};
                        String string = (String)CollectionsKt.lastOrNull((List)StringsKt.split$default((CharSequence)type, (String[])stringArray2, (boolean)false, (int)0, (int)6, null));
                        if (string == null) continue;
                        String c = string;
                        boolean bl3 = false;
                        Charset charset = Charset.forName(((Object)StringsKt.trim((CharSequence)c)).toString());
                        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(...)");
                        return charset;
                    }
                }
            }
            Charset charset = Charset.defaultCharset();
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"defaultCharset(...)");
            return charset;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001bB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000fJ\u0006\u0010\t\u001a\u00020\u0012J\b\u0010\u0014\u001a\u00020\u0012H\u0016J\u0018\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0005H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lokcronet/SourceCallback$CronetBodySource;", "Lokio/Source;", "request", "Lorg/chromium/net/UrlRequest;", "readTimeoutMillis", "", "(Lorg/chromium/net/UrlRequest;J)V", "buffer", "Ljava/nio/ByteBuffer;", "canceled", "Ljava/util/concurrent/atomic/AtomicBoolean;", "closed", "", "cronetResults", "Ljava/util/concurrent/BlockingQueue;", "Lokcronet/SourceCallback$CronetBodySource$CronetResult;", "finished", "add", "", "callbackResult", "close", "read", "sink", "Lokio/Buffer;", "byteCount", "timeout", "Lokio/Timeout;", "CronetResult", "okcronet_release"})
    private static final class CronetBodySource
    implements Source {
        @NotNull
        private final UrlRequest request;
        private final long readTimeoutMillis;
        @NotNull
        private final BlockingQueue<CronetResult> cronetResults;
        @NotNull
        private final AtomicBoolean finished;
        @NotNull
        private final AtomicBoolean canceled;
        @Nullable
        private ByteBuffer buffer;
        private volatile boolean closed;

        public CronetBodySource(@NotNull UrlRequest request, long readTimeoutMillis) {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            this.request = request;
            this.readTimeoutMillis = readTimeoutMillis;
            this.cronetResults = new ArrayBlockingQueue(2);
            this.finished = new AtomicBoolean(false);
            this.canceled = new AtomicBoolean(false);
            this.buffer = ByteBuffer.allocateDirect(32768);
        }

        public long read(@NotNull Buffer sink, long byteCount) throws IOException {
            long l;
            CronetResult cronetResult;
            Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
            if (this.canceled.get()) {
                throw new IOException("The request was canceled!");
            }
            if (!(byteCount >= 0L)) {
                boolean $i$a$-require-SourceCallback$CronetBodySource$read$22 = false;
                String $i$a$-require-SourceCallback$CronetBodySource$read$22 = "byteCount < 0: " + byteCount;
                throw new IllegalArgumentException($i$a$-require-SourceCallback$CronetBodySource$read$22.toString());
            }
            if (!(!this.closed)) {
                boolean bl = false;
                String string = "CronetBodySource closed";
                throw new IllegalStateException(string.toString());
            }
            if (this.finished.get()) {
                return -1L;
            }
            ByteBuffer byteBuffer = this.buffer;
            if (byteCount < (long)(byteBuffer != null ? byteBuffer.limit() : 0)) {
                ByteBuffer byteBuffer2 = this.buffer;
                if (byteBuffer2 != null) {
                    byteBuffer2.limit((int)byteCount);
                }
            }
            this.request.read(this.buffer);
            try {
                cronetResult = this.cronetResults.poll(this.readTimeoutMillis, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                cronetResult = null;
            }
            CronetResult result = cronetResult;
            if (result == null) {
                this.request.cancel();
                throw new CronetTimeoutException();
            }
            cronetResult = result;
            if (cronetResult instanceof CronetResult.Canceled) {
                this.buffer = null;
                throw new IOException("The request was canceled!");
            }
            if (cronetResult instanceof CronetResult.Failed) {
                this.finished.set(true);
                this.buffer = null;
                throw new IOException((Throwable)((CronetResult.Failed)result).getException());
            }
            if (cronetResult instanceof CronetResult.Success) {
                this.finished.set(true);
                this.buffer = null;
                l = -1L;
            } else if (cronetResult instanceof CronetResult.ReadCompleted) {
                ((CronetResult.ReadCompleted)result).getBuffer().flip();
                int bytesWritten = sink.write(((CronetResult.ReadCompleted)result).getBuffer());
                ((CronetResult.ReadCompleted)result).getBuffer().clear();
                l = bytesWritten;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return l;
        }

        @NotNull
        public Timeout timeout() {
            return Timeout.NONE;
        }

        public void close() {
            if (this.closed) {
                return;
            }
            this.closed = true;
            if (!this.finished.get()) {
                this.request.cancel();
            }
        }

        public final void add(@NotNull CronetResult callbackResult) {
            Intrinsics.checkNotNullParameter((Object)callbackResult, (String)"callbackResult");
            this.cronetResults.add(callbackResult);
        }

        public final void canceled() {
            this.canceled.set(true);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0004\u0003\u0004\u0005\u0006B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0004\u0007\b\t\n\u00a8\u0006\u000b"}, d2={"Lokcronet/SourceCallback$CronetBodySource$CronetResult;", "", "()V", "Canceled", "Failed", "ReadCompleted", "Success", "Lokcronet/SourceCallback$CronetBodySource$CronetResult$Canceled;", "Lokcronet/SourceCallback$CronetBodySource$CronetResult$Failed;", "Lokcronet/SourceCallback$CronetBodySource$CronetResult$ReadCompleted;", "Lokcronet/SourceCallback$CronetBodySource$CronetResult$Success;", "okcronet_release"})
        public static abstract class CronetResult {
            private CronetResult() {
            }

            public /* synthetic */ CronetResult(DefaultConstructorMarker $constructor_marker) {
                this();
            }

            @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u00d6\u0003J\t\u0010\u0007\u001a\u00020\bH\u00d6\u0001J\t\u0010\t\u001a\u00020\nH\u00d6\u0001\u00a8\u0006\u000b"}, d2={"Lokcronet/SourceCallback$CronetBodySource$CronetResult$Canceled;", "Lokcronet/SourceCallback$CronetBodySource$CronetResult;", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "okcronet_release"})
            public static final class Canceled
            extends CronetResult {
                @NotNull
                public static final Canceled INSTANCE = new Canceled();

                private Canceled() {
                    super(null);
                }

                @NotNull
                public String toString() {
                    return "Canceled";
                }

                public int hashCode() {
                    return 597969778;
                }

                public boolean equals(@Nullable Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof Canceled)) {
                        return false;
                    }
                    Canceled cfr_ignored_0 = (Canceled)other;
                    return true;
                }
            }

            @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lokcronet/SourceCallback$CronetBodySource$CronetResult$Failed;", "Lokcronet/SourceCallback$CronetBodySource$CronetResult;", "exception", "Lorg/chromium/net/CronetException;", "(Lorg/chromium/net/CronetException;)V", "getException", "()Lorg/chromium/net/CronetException;", "okcronet_release"})
            public static final class Failed
            extends CronetResult {
                @Nullable
                private final CronetException exception;

                public Failed(@Nullable CronetException exception) {
                    super(null);
                    this.exception = exception;
                }

                @Nullable
                public final CronetException getException() {
                    return this.exception;
                }
            }

            @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lokcronet/SourceCallback$CronetBodySource$CronetResult$ReadCompleted;", "Lokcronet/SourceCallback$CronetBodySource$CronetResult;", "buffer", "Ljava/nio/ByteBuffer;", "(Ljava/nio/ByteBuffer;)V", "getBuffer", "()Ljava/nio/ByteBuffer;", "okcronet_release"})
            public static final class ReadCompleted
            extends CronetResult {
                @NotNull
                private final ByteBuffer buffer;

                public ReadCompleted(@NotNull ByteBuffer buffer) {
                    Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
                    super(null);
                    this.buffer = buffer;
                }

                @NotNull
                public final ByteBuffer getBuffer() {
                    return this.buffer;
                }
            }

            @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u00d6\u0003J\t\u0010\u0007\u001a\u00020\bH\u00d6\u0001J\t\u0010\t\u001a\u00020\nH\u00d6\u0001\u00a8\u0006\u000b"}, d2={"Lokcronet/SourceCallback$CronetBodySource$CronetResult$Success;", "Lokcronet/SourceCallback$CronetBodySource$CronetResult;", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "okcronet_release"})
            public static final class Success
            extends CronetResult {
                @NotNull
                public static final Success INSTANCE = new Success();

                private Success() {
                    super(null);
                }

                @NotNull
                public String toString() {
                    return "Success";
                }

                public int hashCode() {
                    return -735528438;
                }

                public boolean equals(@Nullable Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof Success)) {
                        return false;
                    }
                    Success cfr_ignored_0 = (Success)other;
                    return true;
                }
            }
        }
    }
}

