/*
 * Decompiled with CFR 0.152.
 */
package okcronet.http;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okcronet.http.HttpUrl;
import okcronet.http.MediaType;
import okcronet.http.RequestBody;
import okio.Buffer;
import okio.BufferedSink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u001b2\u00020\u0001:\u0002\u001a\u001bB#\b\u0000\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0006J\b\u0010\r\u001a\u00020\u000eH\u0016J\u000e\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\nJ\u000e\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\nJ\b\u0010\u0012\u001a\u00020\bH\u0016J\u000e\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\nJ\u000e\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\nJ\u0012\u0010\u0015\u001a\u00020\b2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001c"}, d2={"Lokcronet/http/FormBody;", "Lokcronet/http/RequestBody;", "encodedNames", "", "", "encodedValues", "(Ljava/util/List;Ljava/util/List;)V", "contentLength", "", "size", "", "getSize", "()I", "contentType", "Lokcronet/http/MediaType;", "encodedName", "index", "encodedValue", "length", "name", "value", "writeOrCountBytes", "sink", "Lokio/BufferedSink;", "writeTo", "", "Builder", "Companion", "okcronet_release"})
public final class FormBody
extends RequestBody {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<String> encodedNames;
    @NotNull
    private final List<String> encodedValues;
    private long contentLength;
    @NotNull
    private static final MediaType CONTENT_TYPE = MediaType.Companion.toMediaType("application/x-www-form-urlencoded");

    public FormBody(@NotNull List<String> encodedNames, @NotNull List<String> encodedValues) {
        Intrinsics.checkNotNullParameter(encodedNames, (String)"encodedNames");
        Intrinsics.checkNotNullParameter(encodedValues, (String)"encodedValues");
        this.encodedNames = encodedNames;
        this.encodedValues = encodedValues;
        this.contentLength = -1L;
    }

    public final int getSize() {
        return this.encodedNames.size();
    }

    @NotNull
    public final String encodedName(int index) {
        return this.encodedNames.get(index);
    }

    @NotNull
    public final String name(int index) {
        return this.encodedName(index);
    }

    @NotNull
    public final String encodedValue(int index) {
        return this.encodedValues.get(index);
    }

    @NotNull
    public final String value(int index) {
        return this.encodedValue(index);
    }

    @Override
    @NotNull
    public MediaType contentType() {
        return CONTENT_TYPE;
    }

    @Override
    public long length() {
        if (this.contentLength == -1L) {
            this.contentLength = this.writeOrCountBytes(null);
        }
        return this.contentLength;
    }

    @Override
    public void writeTo(@NotNull BufferedSink sink) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        this.writeOrCountBytes(sink);
    }

    private final long writeOrCountBytes(BufferedSink sink) {
        Buffer buffer;
        boolean countBytes = sink == null;
        long byteCount = 0L;
        if (countBytes) {
            buffer = new Buffer();
        } else {
            BufferedSink bufferedSink = sink;
            Intrinsics.checkNotNull((Object)bufferedSink);
            buffer = bufferedSink.getBuffer();
        }
        Buffer buffer2 = buffer;
        int n = this.encodedNames.size();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                buffer2.writeByte(38);
            }
            buffer2.writeUtf8(this.encodedNames.get(i));
            buffer2.writeByte(61);
            buffer2.writeUtf8(this.encodedValues.get(i));
        }
        if (countBytes) {
            byteCount = buffer2.size();
            buffer2.clear();
        }
        return byteCount;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0013\b\u0007\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\t\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0007J\u0016\u0010\f\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0007J\u0006\u0010\r\u001a\u00020\u000eR\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lokcronet/http/FormBody$Builder;", "", "charset", "Ljava/nio/charset/Charset;", "(Ljava/nio/charset/Charset;)V", "names", "", "", "values", "add", "name", "value", "addEncoded", "build", "Lokcronet/http/FormBody;", "okcronet_release"})
    public static final class Builder {
        @Nullable
        private final Charset charset;
        @NotNull
        private final List<String> names;
        @NotNull
        private final List<String> values;

        @JvmOverloads
        public Builder(@Nullable Charset charset) {
            this.charset = charset;
            this.names = new ArrayList();
            this.values = new ArrayList();
        }

        public /* synthetic */ Builder(Charset charset, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                charset = null;
            }
            this(charset);
        }

        @NotNull
        public final Builder add(@NotNull String name, @NotNull String value) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Builder $this$add_u24lambda_u240 = builder = this;
            boolean bl = false;
            ((Collection)$this$add_u24lambda_u240.names).add(HttpUrl.Companion.canonicalize$okcronet_release$default(HttpUrl.Companion, name, 0, 0, " \"':;<=>@[]^`{}|/\\?#&!$(),~", false, false, true, false, $this$add_u24lambda_u240.charset, 91, null));
            ((Collection)$this$add_u24lambda_u240.values).add(HttpUrl.Companion.canonicalize$okcronet_release$default(HttpUrl.Companion, value, 0, 0, " \"':;<=>@[]^`{}|/\\?#&!$(),~", false, false, true, false, $this$add_u24lambda_u240.charset, 91, null));
            return builder;
        }

        @NotNull
        public final Builder addEncoded(@NotNull String name, @NotNull String value) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Builder $this$addEncoded_u24lambda_u241 = builder = this;
            boolean bl = false;
            ((Collection)$this$addEncoded_u24lambda_u241.names).add(HttpUrl.Companion.canonicalize$okcronet_release$default(HttpUrl.Companion, name, 0, 0, " \"':;<=>@[]^`{}|/\\?#&!$(),~", true, false, true, false, $this$addEncoded_u24lambda_u241.charset, 83, null));
            ((Collection)$this$addEncoded_u24lambda_u241.values).add(HttpUrl.Companion.canonicalize$okcronet_release$default(HttpUrl.Companion, value, 0, 0, " \"':;<=>@[]^`{}|/\\?#&!$(),~", true, false, true, false, $this$addEncoded_u24lambda_u241.charset, 83, null));
            return builder;
        }

        @NotNull
        public final FormBody build() {
            return new FormBody(this.names, this.values);
        }

        @JvmOverloads
        public Builder() {
            this(null, 1, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lokcronet/http/FormBody$Companion;", "", "()V", "CONTENT_TYPE", "Lokcronet/http/MediaType;", "okcronet_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

