/*
 * Decompiled with CFR 0.152.
 */
package okcronet.http;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okcronet.http.Headers;
import okcronet.http.MediaType;
import okcronet.http.RequestBody;
import okio.Buffer;
import okio.BufferedSink;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 \u001d2\u00020\u0001:\u0003\u001c\u001d\u001eB%\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0010\u001a\u00020\u0005H\u0016J\b\u0010\u0015\u001a\u00020\u000fH\u0016J\u0012\u0010\u0016\u001a\u00020\u000f2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0018H\u0016R\u0014\u0010\n\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001f"}, d2={"Lokcronet/http/MultipartBody;", "Lokcronet/http/RequestBody;", "boundaryByteString", "Lokio/ByteString;", "type", "Lokcronet/http/MediaType;", "parts", "", "Lokcronet/http/MultipartBody$Part;", "(Lokio/ByteString;Lokcronet/http/MediaType;Ljava/util/List;)V", "boundary", "", "getBoundary", "()Ljava/lang/String;", "contentLength", "", "contentType", "getParts", "()Ljava/util/List;", "getType", "()Lokcronet/http/MediaType;", "length", "writeOrCountBytes", "bufferedSink", "Lokio/BufferedSink;", "writeTo", "", "sink", "Builder", "Companion", "Part", "okcronet_release"})
public final class MultipartBody
extends RequestBody {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ByteString boundaryByteString;
    @NotNull
    private final MediaType type;
    @NotNull
    private final List<Part> parts;
    @NotNull
    private final MediaType contentType;
    private long contentLength;
    @JvmField
    @NotNull
    public static final MediaType MIXED = MediaType.Companion.toMediaType("multipart/mixed");
    @JvmField
    @NotNull
    public static final MediaType ALTERNATIVE = MediaType.Companion.toMediaType("multipart/alternative");
    @JvmField
    @NotNull
    public static final MediaType DIGEST = MediaType.Companion.toMediaType("multipart/digest");
    @JvmField
    @NotNull
    public static final MediaType PARALLEL = MediaType.Companion.toMediaType("multipart/parallel");
    @JvmField
    @NotNull
    public static final MediaType FORM = MediaType.Companion.toMediaType("multipart/form-data");
    @NotNull
    private static final byte[] COLONSPACE;
    @NotNull
    private static final byte[] CRLF;
    @NotNull
    private static final byte[] DASHDASH;

    public MultipartBody(@NotNull ByteString boundaryByteString, @NotNull MediaType type, @NotNull List<Part> parts) {
        Intrinsics.checkNotNullParameter((Object)boundaryByteString, (String)"boundaryByteString");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter(parts, (String)"parts");
        this.boundaryByteString = boundaryByteString;
        this.type = type;
        this.parts = parts;
        this.contentType = MediaType.Companion.toMediaType(this.type + "; boundary=" + this.getBoundary());
        this.contentLength = -1L;
    }

    @NotNull
    public final MediaType getType() {
        return this.type;
    }

    @NotNull
    public final List<Part> getParts() {
        return this.parts;
    }

    private final String getBoundary() {
        return this.boundaryByteString.utf8();
    }

    @Override
    @NotNull
    public MediaType contentType() {
        return this.contentType;
    }

    @Override
    public long length() {
        if (this.contentLength == -1L) {
            this.contentLength = this.writeOrCountBytes(null);
        }
        return this.contentLength;
    }

    @Override
    public void writeTo(@NotNull BufferedSink sink) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        this.writeOrCountBytes(sink);
    }

    private final long writeOrCountBytes(BufferedSink bufferedSink) throws IOException {
        boolean countBytes = bufferedSink == null;
        BufferedSink sink = bufferedSink;
        long byteCount = 0L;
        Buffer byteCountBuffer = null;
        if (countBytes) {
            byteCountBuffer = new Buffer();
            sink = (BufferedSink)byteCountBuffer;
        }
        for (Part element : this.parts) {
            long contentLength;
            MediaType contentType;
            Headers headers = element.getHeaders();
            RequestBody body = element.getBody();
            BufferedSink bufferedSink2 = sink;
            Intrinsics.checkNotNull((Object)bufferedSink2);
            bufferedSink2.write(DASHDASH);
            sink.write(this.boundaryByteString);
            sink.write(CRLF);
            if (headers != null) {
                int n = headers.getSize();
                for (int h = 0; h < n; ++h) {
                    sink.writeUtf8(headers.name(h)).write(COLONSPACE).writeUtf8(headers.value(h)).write(CRLF);
                }
            }
            if ((contentType = body.contentType()) != null) {
                sink.writeUtf8("Content-Type: ").writeUtf8(contentType.toString()).write(CRLF);
            }
            if ((contentLength = body.length()) != -1L) {
                sink.writeUtf8("Content-Length: ").writeDecimalLong(contentLength).write(CRLF);
            } else if (countBytes) {
                Buffer buffer = byteCountBuffer;
                Intrinsics.checkNotNull((Object)buffer);
                buffer.clear();
                return -1L;
            }
            sink.write(CRLF);
            if (countBytes) {
                byteCount += contentLength;
            } else {
                body.writeTo(sink);
            }
            sink.write(CRLF);
        }
        BufferedSink bufferedSink3 = sink;
        Intrinsics.checkNotNull((Object)bufferedSink3);
        bufferedSink3.write(DASHDASH);
        sink.write(this.boundaryByteString);
        sink.write(DASHDASH);
        sink.write(CRLF);
        if (countBytes) {
            Buffer buffer = byteCountBuffer;
            Intrinsics.checkNotNull((Object)buffer);
            byteCount += buffer.size();
            byteCountBuffer.clear();
        }
        return byteCount;
    }

    static {
        byte[] byArray = new byte[]{58, 32};
        COLONSPACE = byArray;
        byArray = new byte[]{13, 10};
        CRLF = byArray;
        byArray = new byte[]{45, 45};
        DASHDASH = byArray;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0011\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u000b\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0003J \u0010\u000b\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u00032\b\u0010\u000e\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000f\u001a\u00020\u0010J\u0016\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\bJ\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0002\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lokcronet/http/MultipartBody$Builder;", "", "boundary", "", "(Ljava/lang/String;)V", "Lokio/ByteString;", "parts", "", "Lokcronet/http/MultipartBody$Part;", "type", "Lokcronet/http/MediaType;", "addFormDataPart", "name", "value", "filename", "body", "Lokcronet/http/RequestBody;", "addPart", "headers", "Lokcronet/http/Headers;", "part", "build", "Lokcronet/http/MultipartBody;", "setType", "okcronet_release"})
    @SourceDebugExtension(value={"SMAP\nMultipartBody.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultipartBody.kt\nokcronet/http/MultipartBody$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,285:1\n1#2:286\n*E\n"})
    public static final class Builder {
        @NotNull
        private final ByteString boundary;
        @NotNull
        private MediaType type;
        @NotNull
        private final List<Part> parts;

        @JvmOverloads
        public Builder(@NotNull String boundary) {
            Intrinsics.checkNotNullParameter((Object)boundary, (String)"boundary");
            this.boundary = ByteString.Companion.encodeUtf8(boundary);
            this.type = MIXED;
            this.parts = new ArrayList();
        }

        public /* synthetic */ Builder(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                String string2 = UUID.randomUUID().toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
                string = string2;
            }
            this(string);
        }

        @NotNull
        public final Builder setType(@NotNull MediaType type) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Builder $this$setType_u24lambda_u241 = builder = this;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)type.getType(), (Object)"multipart")) {
                boolean bl2 = false;
                String string = "multipart != " + type;
                throw new IllegalArgumentException(string.toString());
            }
            $this$setType_u24lambda_u241.type = type;
            return builder;
        }

        @NotNull
        public final Builder addPart(@NotNull Headers headers, @NotNull RequestBody body) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
            Intrinsics.checkNotNullParameter((Object)body, (String)"body");
            Builder $this$addPart_u24lambda_u242 = builder = this;
            boolean bl = false;
            $this$addPart_u24lambda_u242.addPart(Part.Companion.create(headers, body));
            return builder;
        }

        @NotNull
        public final Builder addFormDataPart(@NotNull String name, @NotNull String value) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Builder $this$addFormDataPart_u24lambda_u243 = builder = this;
            boolean bl = false;
            $this$addFormDataPart_u24lambda_u243.addPart(Part.Companion.createFormData(name, value));
            return builder;
        }

        @NotNull
        public final Builder addFormDataPart(@NotNull String name, @Nullable String filename, @NotNull RequestBody body) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)body, (String)"body");
            Builder $this$addFormDataPart_u24lambda_u244 = builder = this;
            boolean bl = false;
            $this$addFormDataPart_u24lambda_u244.addPart(Part.Companion.createFormData(name, filename, body));
            return builder;
        }

        @NotNull
        public final Builder addPart(@NotNull Part part) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)part, (String)"part");
            Builder $this$addPart_u24lambda_u245 = builder = this;
            boolean bl = false;
            ((Collection)$this$addPart_u24lambda_u245.parts).add(part);
            return builder;
        }

        @NotNull
        public final MultipartBody build() {
            if (!(!((Collection)this.parts).isEmpty())) {
                boolean bl = false;
                String string = "Multipart body must have at least one part.";
                throw new IllegalStateException(string.toString());
            }
            return new MultipartBody(this.boundary, this.type, this.parts);
        }

        @JvmOverloads
        public Builder() {
            this(null, 1, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\r\u001a\u00020\u000e*\u00060\u000fj\u0002`\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b\u0013R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lokcronet/http/MultipartBody$Companion;", "", "()V", "ALTERNATIVE", "Lokcronet/http/MediaType;", "COLONSPACE", "", "CRLF", "DASHDASH", "DIGEST", "FORM", "MIXED", "PARALLEL", "appendQuotedString", "", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "key", "", "appendQuotedString$okcronet_release", "okcronet_release"})
    public static final class Companion {
        private Companion() {
        }

        public final void appendQuotedString$okcronet_release(@NotNull StringBuilder $this$appendQuotedString, @NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)$this$appendQuotedString, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            $this$appendQuotedString.append('\"');
            int n = key.length();
            for (int i = 0; i < n; ++i) {
                char element = key.charAt(i);
                char c = element;
                if (c == '\n') {
                    $this$appendQuotedString.append("%0A");
                    continue;
                }
                if (c == '\r') {
                    $this$appendQuotedString.append("%0D");
                    continue;
                }
                if (c == '\"') {
                    $this$appendQuotedString.append("%22");
                    continue;
                }
                $this$appendQuotedString.append(element);
            }
            $this$appendQuotedString.append('\"');
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0019\b\u0002\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\f"}, d2={"Lokcronet/http/MultipartBody$Part;", "", "headers", "Lokcronet/http/Headers;", "body", "Lokcronet/http/RequestBody;", "(Lokcronet/http/Headers;Lokcronet/http/RequestBody;)V", "getBody", "()Lokcronet/http/RequestBody;", "getHeaders", "()Lokcronet/http/Headers;", "Companion", "okcronet_release"})
    public static final class Part {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private final Headers headers;
        @NotNull
        private final RequestBody body;

        private Part(Headers headers, RequestBody body) {
            this.headers = headers;
            this.body = body;
        }

        @Nullable
        public final Headers getHeaders() {
            return this.headers;
        }

        @NotNull
        public final RequestBody getBody() {
            return this.body;
        }

        @JvmStatic
        @NotNull
        public static final Part create(@NotNull Headers headers, @NotNull RequestBody body) {
            return Companion.create(headers, body);
        }

        @JvmStatic
        @NotNull
        public static final Part createFormData(@NotNull String name, @NotNull String value) {
            return Companion.createFormData(name, value);
        }

        @JvmStatic
        @NotNull
        public static final Part createFormData(@NotNull String name, @Nullable String filename, @NotNull RequestBody body) {
            return Companion.createFormData(name, filename, body);
        }

        public /* synthetic */ Part(Headers headers, RequestBody body, DefaultConstructorMarker $constructor_marker) {
            this(headers, body);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0007J\"\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0007\u001a\u00020\bH\u0007\u00a8\u0006\u000e"}, d2={"Lokcronet/http/MultipartBody$Part$Companion;", "", "()V", "create", "Lokcronet/http/MultipartBody$Part;", "headers", "Lokcronet/http/Headers;", "body", "Lokcronet/http/RequestBody;", "createFormData", "name", "", "value", "filename", "okcronet_release"})
        @SourceDebugExtension(value={"SMAP\nMultipartBody.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultipartBody.kt\nokcronet/http/MultipartBody$Part$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,285:1\n1#2:286\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @JvmStatic
            @NotNull
            public final Part create(@NotNull Headers headers, @NotNull RequestBody body) {
                Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
                Intrinsics.checkNotNullParameter((Object)body, (String)"body");
                if (!(headers.get("Content-Type") == null)) {
                    boolean $i$a$-require-MultipartBody$Part$Companion$create$32 = false;
                    String $i$a$-require-MultipartBody$Part$Companion$create$32 = "Unexpected header: Content-Type";
                    throw new IllegalArgumentException($i$a$-require-MultipartBody$Part$Companion$create$32.toString());
                }
                if (!(headers.get("Content-Length") == null)) {
                    boolean bl = false;
                    String string = "Unexpected header: Content-Length";
                    throw new IllegalArgumentException(string.toString());
                }
                return new Part(headers, body, null);
            }

            @JvmStatic
            @NotNull
            public final Part createFormData(@NotNull String name, @NotNull String value) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return this.createFormData(name, null, RequestBody.Companion.toRequestBody$default(RequestBody.Companion, value, null, 1, null));
            }

            @JvmStatic
            @NotNull
            public final Part createFormData(@NotNull String name, @Nullable String filename, @NotNull RequestBody body) {
                StringBuilder stringBuilder;
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter((Object)body, (String)"body");
                StringBuilder $this$createFormData_u24lambda_u242 = stringBuilder = new StringBuilder();
                boolean bl = false;
                $this$createFormData_u24lambda_u242.append("form-data; name=");
                MultipartBody.Companion.appendQuotedString$okcronet_release($this$createFormData_u24lambda_u242, name);
                if (filename != null) {
                    $this$createFormData_u24lambda_u242.append("; filename=");
                    MultipartBody.Companion.appendQuotedString$okcronet_release($this$createFormData_u24lambda_u242, filename);
                }
                String string = stringBuilder.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                String disposition = string;
                Headers headers = new Headers.Builder().addUnsafeNonAscii("Content-Disposition", disposition).build();
                return this.create(headers, body);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

