/*
 * Decompiled with CFR 0.152.
 */
package okcronet.http;

import java.io.IOException;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okcronet.http.Headers;
import okcronet.http.HttpUrl;
import okcronet.http.MediaType;
import okcronet.http.RequestBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0001*BQ\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0016\u0010\u000e\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0010\u0012\u0004\u0012\u00020\u00010\u000f\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010!\u001a\u0004\u0018\u00010\u00052\u0006\u0010\"\u001a\u00020\u0005J\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050#2\u0006\u0010\"\u001a\u00020\u0005J\u0006\u0010$\u001a\u00020%J\b\u0010&\u001a\u0004\u0018\u00010\u0001J#\u0010&\u001a\u0004\u0018\u0001H'\"\u0004\b\u0000\u0010'2\u000e\u0010(\u001a\n\u0012\u0006\b\u0001\u0012\u0002H'0\u0010\u00a2\u0006\u0002\u0010)R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0015R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR$\u0010\u000e\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0010\u0012\u0004\u0012\u00020\u00010\u000fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u00a8\u0006+"}, d2={"Lokcronet/http/Request;", "", "url", "Lokcronet/http/HttpUrl;", "method", "", "headers", "Lokcronet/http/Headers;", "body", "Lokcronet/http/RequestBody;", "priority", "", "disableCache", "", "tags", "", "Ljava/lang/Class;", "(Lokcronet/http/HttpUrl;Ljava/lang/String;Lokcronet/http/Headers;Lokcronet/http/RequestBody;IZLjava/util/Map;)V", "getBody", "()Lokcronet/http/RequestBody;", "getDisableCache", "()Z", "getHeaders", "()Lokcronet/http/Headers;", "isHttps", "getMethod", "()Ljava/lang/String;", "getPriority", "()I", "getTags$okcronet_release", "()Ljava/util/Map;", "getUrl", "()Lokcronet/http/HttpUrl;", "header", "name", "", "newBuilder", "Lokcronet/http/Request$Builder;", "tag", "T", "type", "(Ljava/lang/Class;)Ljava/lang/Object;", "Builder", "okcronet_release"})
public final class Request {
    @NotNull
    private final HttpUrl url;
    @NotNull
    private final String method;
    @NotNull
    private final Headers headers;
    @Nullable
    private final RequestBody body;
    private final int priority;
    private final boolean disableCache;
    @NotNull
    private final Map<Class<?>, Object> tags;

    private Request(HttpUrl url, String method, Headers headers, RequestBody body, int priority, boolean disableCache, Map<Class<?>, ? extends Object> tags) {
        this.url = url;
        this.method = method;
        this.headers = headers;
        this.body = body;
        this.priority = priority;
        this.disableCache = disableCache;
        this.tags = tags;
    }

    @NotNull
    public final HttpUrl getUrl() {
        return this.url;
    }

    @NotNull
    public final String getMethod() {
        return this.method;
    }

    @NotNull
    public final Headers getHeaders() {
        return this.headers;
    }

    @Nullable
    public final RequestBody getBody() {
        return this.body;
    }

    public final int getPriority() {
        return this.priority;
    }

    public final boolean getDisableCache() {
        return this.disableCache;
    }

    @NotNull
    public final Map<Class<?>, Object> getTags$okcronet_release() {
        return this.tags;
    }

    public final boolean isHttps() {
        return this.url.isHttps();
    }

    @Nullable
    public final String header(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.headers.get(name);
    }

    @NotNull
    public final List<String> headers(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.headers.values(name);
    }

    @Nullable
    public final Object tag() {
        return this.tag(Object.class);
    }

    @Nullable
    public final <T> T tag(@NotNull Class<? extends T> type) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        return type.cast(this.tags.get(type));
    }

    @NotNull
    public final Builder newBuilder() {
        return new Builder(this);
    }

    public /* synthetic */ Request(HttpUrl url, String method, Headers headers, RequestBody body, int priority, boolean disableCache, Map tags, DefaultConstructorMarker $constructor_marker) {
        this(url, method, headers, body, priority, disableCache, tags);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 *2\u00020\u0001:\u0001*B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u000f\b\u0010\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\rJ\u0006\u0010\u0018\u001a\u00020\u0004J\u0010\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0006\u001a\u00020\u0007J\u0006\u0010\b\u001a\u00020\u0000J\u0006\u0010\u001a\u001a\u00020\u0000J\b\u0010\u001b\u001a\u00020\u001cH\u0002J\u0006\u0010\u001d\u001a\u00020\u0000J\u0016\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\rJ\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u001fJ\u0018\u0010\f\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007J\u000e\u0010 \u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010!\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\u000fJ\u000e\u0010#\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010$\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\rJ+\u0010%\u001a\u00020\u0000\"\u0004\b\u0000\u0010&2\u000e\u0010'\u001a\n\u0012\u0006\b\u0000\u0012\u0002H&0\u00122\b\u0010%\u001a\u0004\u0018\u0001H&\u00a2\u0006\u0002\u0010(J\u0010\u0010%\u001a\u00020\u00002\b\u0010%\u001a\u0004\u0018\u00010\u0001J\u000e\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020)J\u000e\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\rJ\u000e\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0014R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0010\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0012\u0012\u0004\u0012\u00020\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lokcronet/http/Request$Builder;", "", "()V", "request", "Lokcronet/http/Request;", "(Lokcronet/http/Request;)V", "body", "Lokcronet/http/RequestBody;", "disableCache", "", "headers", "Lokcronet/http/Headers$Builder;", "method", "", "priority", "", "tags", "", "Ljava/lang/Class;", "url", "Lokcronet/http/HttpUrl;", "addHeader", "name", "value", "build", "delete", "get", "handleHeader", "", "head", "header", "Lokcronet/http/Headers;", "patch", "post", "int", "put", "removeHeader", "tag", "T", "type", "(Ljava/lang/Class;Ljava/lang/Object;)Lokcronet/http/Request$Builder;", "Ljava/net/URL;", "Companion", "okcronet_release"})
    @SourceDebugExtension(value={"SMAP\nRequest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Request.kt\nokcronet/http/Request$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,270:1\n1#2:271\n*E\n"})
    public static final class Builder {
        @NotNull
        private static final Companion Companion = new Companion(null);
        @Nullable
        private HttpUrl url;
        @NotNull
        private String method;
        @NotNull
        private Headers.Builder headers;
        @Nullable
        private RequestBody body;
        private int priority;
        private boolean disableCache;
        @NotNull
        private Map<Class<?>, Object> tags;

        public Builder() {
            this.priority = 3;
            this.tags = new LinkedHashMap();
            this.method = "GET";
            this.headers = new Headers.Builder();
        }

        public Builder(@NotNull Request request) {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            this.priority = 3;
            this.tags = new LinkedHashMap();
            this.url = request.getUrl();
            this.method = request.getMethod();
            this.body = request.getBody();
            this.tags = request.getTags$okcronet_release().isEmpty() ? (Map)new LinkedHashMap() : MapsKt.toMutableMap(request.getTags$okcronet_release());
            this.headers = request.getHeaders().newBuilder();
        }

        @NotNull
        public final Builder priority(int n) {
            this.priority = n;
            return this;
        }

        @NotNull
        public final Builder disableCache() {
            this.disableCache = true;
            return this;
        }

        @NotNull
        public final Builder url(@NotNull HttpUrl url) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Builder $this$url_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$url_u24lambda_u240.url = url;
            return builder;
        }

        @NotNull
        public final Builder url(@NotNull String url) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            if (StringsKt.startsWith((String)url, (String)"ws:", (boolean)true)) {
                String string = url.substring(3);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                object = "http:" + string;
            } else if (StringsKt.startsWith((String)url, (String)"wss:", (boolean)true)) {
                String string = url.substring(4);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                object = "https:" + string;
            } else {
                object = url;
            }
            Object finalUrl = object;
            return this.url(HttpUrl.Companion.toHttpUrl((String)finalUrl));
        }

        @NotNull
        public final Builder url(@NotNull URL url) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            String string = url.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return this.url(HttpUrl.Companion.toHttpUrl(string));
        }

        @NotNull
        public final Builder header(@NotNull String name, @NotNull String value) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Builder $this$header_u24lambda_u241 = builder = this;
            boolean bl = false;
            $this$header_u24lambda_u241.headers.set(name, value);
            return builder;
        }

        @NotNull
        public final Builder addHeader(@NotNull String name, @NotNull String value) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Builder $this$addHeader_u24lambda_u242 = builder = this;
            boolean bl = false;
            $this$addHeader_u24lambda_u242.headers.add(name, value);
            return builder;
        }

        @NotNull
        public final Builder removeHeader(@NotNull String name) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Builder $this$removeHeader_u24lambda_u243 = builder = this;
            boolean bl = false;
            $this$removeHeader_u24lambda_u243.headers.removeAll(name);
            return builder;
        }

        @NotNull
        public final Builder headers(@NotNull Headers headers) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
            Builder $this$headers_u24lambda_u244 = builder = this;
            boolean bl = false;
            $this$headers_u24lambda_u244.headers = headers.newBuilder();
            return builder;
        }

        @NotNull
        public final Builder get() {
            return this.method("GET", null);
        }

        @NotNull
        public final Builder head() {
            return this.method("HEAD", null);
        }

        @NotNull
        public final Builder post(@NotNull RequestBody body) {
            Intrinsics.checkNotNullParameter((Object)body, (String)"body");
            return this.method("POST", body);
        }

        @NotNull
        public final Builder delete(@NotNull RequestBody body) {
            Intrinsics.checkNotNullParameter((Object)body, (String)"body");
            return this.method("DELETE", body);
        }

        public static /* synthetic */ Builder delete$default(Builder builder, RequestBody requestBody, int n, Object object) {
            if ((n & 1) != 0) {
                requestBody = RequestBody.Companion.getEMPTY_REQUEST_BODY();
            }
            return builder.delete(requestBody);
        }

        @NotNull
        public final Builder put(@NotNull RequestBody body) {
            Intrinsics.checkNotNullParameter((Object)body, (String)"body");
            return this.method("PUT", body);
        }

        @NotNull
        public final Builder patch(@NotNull RequestBody body) {
            Intrinsics.checkNotNullParameter((Object)body, (String)"body");
            return this.method("PATCH", body);
        }

        @NotNull
        public final Builder method(@NotNull String method, @Nullable RequestBody body) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            Builder $this$method_u24lambda_u248 = builder = this;
            boolean bl = false;
            if (!(((CharSequence)method).length() > 0)) {
                boolean $i$a$-require-Request$Builder$method$1$42 = false;
                String $i$a$-require-Request$Builder$method$1$42 = "method.isEmpty() == true";
                throw new IllegalArgumentException($i$a$-require-Request$Builder$method$1$42.toString());
            }
            if (body == null) {
                if (!(!Companion.requiresRequestBody(method))) {
                    boolean $i$a$-require-Request$Builder$method$1$52 = false;
                    String $i$a$-require-Request$Builder$method$1$52 = "method " + method + " must have a request body.";
                    throw new IllegalArgumentException($i$a$-require-Request$Builder$method$1$52.toString());
                }
            } else if (!Companion.permitsRequestBody(method)) {
                boolean bl2 = false;
                String string = "method " + method + " must not have a request body.";
                throw new IllegalArgumentException(string.toString());
            }
            $this$method_u24lambda_u248.method = method;
            $this$method_u24lambda_u248.body = body;
            return builder;
        }

        @NotNull
        public final Builder tag(@Nullable Object tag) {
            return this.tag(Object.class, tag);
        }

        @NotNull
        public final <T> Builder tag(@NotNull Class<? super T> type, @Nullable T tag) {
            Builder builder;
            Intrinsics.checkNotNullParameter(type, (String)"type");
            Builder $this$tag_u24lambda_u249 = builder = this;
            boolean bl = false;
            if (tag == null) {
                $this$tag_u24lambda_u249.tags.remove(type);
            } else {
                if ($this$tag_u24lambda_u249.tags.isEmpty()) {
                    $this$tag_u24lambda_u249.tags = new LinkedHashMap();
                }
                Map<Class<?>, Object> map = $this$tag_u24lambda_u249.tags;
                T t = type.cast(tag);
                Intrinsics.checkNotNull(t);
                map.put(type, t);
            }
            return builder;
        }

        @NotNull
        public final Request build() {
            this.handleHeader();
            HttpUrl httpUrl = this.url;
            if (httpUrl == null) {
                boolean bl = false;
                String string = "url == null";
                throw new IllegalStateException(string.toString());
            }
            DefaultConstructorMarker defaultConstructorMarker = null;
            Map<Class<?>, Object> map = this.tags;
            boolean bl = this.disableCache;
            int n = this.priority;
            RequestBody requestBody = this.body;
            Headers headers = this.headers.build();
            String string = this.method;
            HttpUrl httpUrl2 = httpUrl;
            return new Request(httpUrl2, string, headers, requestBody, n, bl, map, defaultConstructorMarker);
        }

        private final void handleHeader() {
            if (this.body != null) {
                long l;
                try {
                    RequestBody requestBody = this.body;
                    Intrinsics.checkNotNull((Object)requestBody);
                    l = requestBody.length();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                long contentLength = l;
                if (contentLength != -1L) {
                    String contentType;
                    this.headers.set("Content-Length", String.valueOf(contentLength));
                    String string = this.headers.get("Content-Type");
                    if (string == null) {
                        RequestBody requestBody = this.body;
                        Intrinsics.checkNotNull((Object)requestBody);
                        MediaType mediaType = requestBody.contentType();
                        string = mediaType != null ? mediaType.toString() : null;
                    }
                    if ((contentType = string) == null) {
                        this.headers.set("Content-Type", "application/octet-stream");
                    } else {
                        this.headers.set("Content-Type", contentType);
                    }
                }
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\b"}, d2={"Lokcronet/http/Request$Builder$Companion;", "", "()V", "permitsRequestBody", "", "method", "", "requiresRequestBody", "okcronet_release"})
        private static final class Companion {
            private Companion() {
            }

            public final boolean requiresRequestBody(@NotNull String method) {
                Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                return Intrinsics.areEqual((Object)method, (Object)"POST") || Intrinsics.areEqual((Object)method, (Object)"PUT") || Intrinsics.areEqual((Object)method, (Object)"PATCH") || Intrinsics.areEqual((Object)method, (Object)"PROPPATCH") || Intrinsics.areEqual((Object)method, (Object)"REPORT");
            }

            public final boolean permitsRequestBody(@NotNull String method) {
                Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                return !Intrinsics.areEqual((Object)method, (Object)"GET") && !Intrinsics.areEqual((Object)method, (Object)"HEAD");
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

