/*
 * Decompiled with CFR 0.152.
 */
package okcronet.http;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okcronet.http.Request;
import okcronet.http.ResponseBody;
import okio.Buffer;
import okio.BufferedSource;
import okio.Source;
import org.chromium.net.UrlResponseInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001fB!\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u001eR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006 "}, d2={"Lokcronet/http/Response;", "", "request", "Lokcronet/http/Request;", "urlResponseInfo", "Lorg/chromium/net/UrlResponseInfo;", "body", "Lokcronet/http/ResponseBody;", "(Lokcronet/http/Request;Lorg/chromium/net/UrlResponseInfo;Lokcronet/http/ResponseBody;)V", "getBody", "()Lokcronet/http/ResponseBody;", "code", "", "getCode", "()I", "isSuccessful", "", "()Z", "message", "", "getMessage", "()Ljava/lang/String;", "getRequest", "()Lokcronet/http/Request;", "getUrlResponseInfo", "()Lorg/chromium/net/UrlResponseInfo;", "newBuilder", "Lokcronet/http/Response$Builder;", "peekBody", "byteCount", "", "Builder", "okcronet_release"})
public final class Response {
    @NotNull
    private final Request request;
    @NotNull
    private final UrlResponseInfo urlResponseInfo;
    @Nullable
    private final ResponseBody body;

    public Response(@NotNull Request request, @NotNull UrlResponseInfo urlResponseInfo, @Nullable ResponseBody body) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)urlResponseInfo, (String)"urlResponseInfo");
        this.request = request;
        this.urlResponseInfo = urlResponseInfo;
        this.body = body;
    }

    @NotNull
    public final Request getRequest() {
        return this.request;
    }

    @NotNull
    public final UrlResponseInfo getUrlResponseInfo() {
        return this.urlResponseInfo;
    }

    @Nullable
    public final ResponseBody getBody() {
        return this.body;
    }

    public final boolean isSuccessful() {
        int n = this.urlResponseInfo.getHttpStatusCode();
        return 200 <= n ? n < 300 : false;
    }

    public final int getCode() {
        return this.urlResponseInfo.getHttpStatusCode();
    }

    @NotNull
    public final String getMessage() {
        String string = this.urlResponseInfo.getHttpStatusText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHttpStatusText(...)");
        return string;
    }

    @NotNull
    public final Builder newBuilder() {
        return new Builder(this);
    }

    @NotNull
    public final ResponseBody peekBody(long byteCount) throws IOException {
        ResponseBody responseBody = this.body;
        Intrinsics.checkNotNull((Object)responseBody);
        BufferedSource peeked = responseBody.source().peek();
        Buffer buffer = new Buffer();
        peeked.request(byteCount);
        buffer.write((Source)peeked, Math.min(byteCount, peeked.getBuffer().size()));
        return ResponseBody.Companion.asResponseBody((BufferedSource)buffer, this.body.contentType(), buffer.size());
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00002\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007J\u0006\u0010\f\u001a\u00020\u0003J\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u000bR\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lokcronet/http/Response$Builder;", "", "response", "Lokcronet/http/Response;", "(Lokcronet/http/Response;)V", "()V", "body", "Lokcronet/http/ResponseBody;", "request", "Lokcronet/http/Request;", "urlResponseInfo", "Lorg/chromium/net/UrlResponseInfo;", "build", "requestParameter", "okcronet_release"})
    @SourceDebugExtension(value={"SMAP\nResponse.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Response.kt\nokcronet/http/Response$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,109:1\n1#2:110\n*E\n"})
    public static final class Builder {
        @Nullable
        private Request request;
        @Nullable
        private UrlResponseInfo urlResponseInfo;
        @Nullable
        private ResponseBody body;

        public Builder(@NotNull Response response) {
            Intrinsics.checkNotNullParameter((Object)response, (String)"response");
            this.request = response.getRequest();
            this.urlResponseInfo = response.getUrlResponseInfo();
            this.body = response.getBody();
        }

        public Builder() {
        }

        @NotNull
        public final Builder body(@Nullable ResponseBody body) {
            this.body = body;
            return this;
        }

        @NotNull
        public final Builder requestParameter(@NotNull Request request) {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            this.request = request;
            return this;
        }

        @NotNull
        public final Builder urlResponseInfo(@NotNull UrlResponseInfo urlResponseInfo) {
            Intrinsics.checkNotNullParameter((Object)urlResponseInfo, (String)"urlResponseInfo");
            this.urlResponseInfo = urlResponseInfo;
            return this;
        }

        @NotNull
        public final Response build() {
            Request request = this.request;
            if (request == null) {
                boolean $i$a$-checkNotNull-Response$Builder$build$32 = false;
                String $i$a$-checkNotNull-Response$Builder$build$32 = "request == null";
                throw new IllegalStateException($i$a$-checkNotNull-Response$Builder$build$32.toString());
            }
            UrlResponseInfo urlResponseInfo = this.urlResponseInfo;
            if (urlResponseInfo == null) {
                Request request2 = request;
                boolean bl = false;
                Request request3 = request2;
                String string = "urlResponseInfo == null";
                throw new IllegalStateException(string.toString());
            }
            ResponseBody responseBody = this.body;
            UrlResponseInfo urlResponseInfo2 = urlResponseInfo;
            Request request4 = request;
            return new Response(request4, urlResponseInfo2, responseBody);
        }
    }
}

