/*
 * Decompiled with CFR 0.152.
 */
package okcronet.http;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import okcronet.http.MediaType;
import okcronet.http.UtilKt;
import okio.Buffer;
import okio.BufferedSource;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b&\u0018\u0000 !2\u00020\u0001:\u0002 !B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0005\u001a\u00020\u0006J\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\u000b\u001a\u00020\u0004J\b\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016J@\u0010\u0010\u001a\u0002H\u0011\"\b\b\u0000\u0010\u0011*\u00020\u00122\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u0002H\u00110\u00142\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u0002H\u0011\u0012\u0004\u0012\u00020\u00170\u0014H\u0082\b\u00a2\u0006\u0002\u0010\u0018J\b\u0010\u0019\u001a\u00020\u001aH&J\n\u0010\u001b\u001a\u0004\u0018\u00010\u001cH&J\b\u0010\u001d\u001a\u00020\u0015H&J\u0006\u0010\u001e\u001a\u00020\u001fR\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lokcronet/http/ResponseBody;", "Ljava/io/Closeable;", "()V", "reader", "Ljava/io/Reader;", "byteStream", "Ljava/io/InputStream;", "byteString", "Lokio/ByteString;", "bytes", "", "charStream", "charset", "Ljava/nio/charset/Charset;", "close", "", "consumeSource", "T", "", "consumer", "Lkotlin/Function1;", "Lokio/BufferedSource;", "sizeMapper", "", "(Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "contentLength", "", "contentType", "Lokcronet/http/MediaType;", "source", "string", "", "BomAwareReader", "Companion", "okcronet_release"})
@SourceDebugExtension(value={"SMAP\nResponseBody.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResponseBody.kt\nokcronet/http/ResponseBody\n*L\n1#1,222:1\n89#1,11:223\n89#1,11:234\n*S KotlinDebug\n*F\n+ 1 ResponseBody.kt\nokcronet/http/ResponseBody\n*L\n70#1:223,11\n83#1:234,11\n*E\n"})
public abstract class ResponseBody
implements Closeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Reader reader;

    @Nullable
    public abstract MediaType contentType();

    public abstract long contentLength();

    @NotNull
    public abstract BufferedSource source();

    @NotNull
    public final InputStream byteStream() {
        return this.source().inputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final byte[] bytes() throws IOException {
        byte[] bytes$iv;
        byte[] byArray;
        ResponseBody this_$iv = this;
        boolean $i$f$consumeSource = false;
        long contentLength$iv = this_$iv.contentLength();
        if (contentLength$iv > Integer.MAX_VALUE) {
            throw new IOException("Cannot buffer entire body for content length: " + contentLength$iv);
        }
        Closeable closeable = (Closeable)this_$iv.source();
        Throwable throwable = null;
        try {
            BufferedSource p0 = (BufferedSource)closeable;
            boolean bl = false;
            byArray = p0.readByteArray();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        byte[] it = bytes$iv = byArray;
        boolean bl = false;
        int size$iv = it.length;
        if (contentLength$iv != -1L && contentLength$iv != (long)size$iv) {
            throw new IOException("Content-Length (" + contentLength$iv + ") and stream length (" + size$iv + ") disagree");
        }
        return bytes$iv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final ByteString byteString() throws IOException {
        ByteString bytes$iv;
        ByteString byteString;
        ResponseBody this_$iv = this;
        boolean $i$f$consumeSource = false;
        long contentLength$iv = this_$iv.contentLength();
        if (contentLength$iv > Integer.MAX_VALUE) {
            throw new IOException("Cannot buffer entire body for content length: " + contentLength$iv);
        }
        Closeable closeable = (Closeable)this_$iv.source();
        Throwable throwable = null;
        try {
            BufferedSource p0 = (BufferedSource)closeable;
            boolean bl = false;
            byteString = p0.readByteString();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        ByteString it = bytes$iv = byteString;
        boolean bl = false;
        int size$iv = it.size();
        if (contentLength$iv != -1L && contentLength$iv != (long)size$iv) {
            throw new IOException("Content-Length (" + contentLength$iv + ") and stream length (" + size$iv + ") disagree");
        }
        return bytes$iv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> T consumeSource(Function1<? super BufferedSource, ? extends T> consumer, Function1<? super T, Integer> sizeMapper) {
        Object object;
        boolean $i$f$consumeSource = false;
        long contentLength = this.contentLength();
        if (contentLength > Integer.MAX_VALUE) {
            throw new IOException("Cannot buffer entire body for content length: " + contentLength);
        }
        Closeable closeable = (Closeable)this.source();
        Throwable throwable = null;
        try {
            object = consumer.invoke((Object)closeable);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            InlineMarker.finallyEnd((int)1);
        }
        Object bytes = object;
        int size = ((Number)sizeMapper.invoke(bytes)).intValue();
        if (contentLength != -1L && contentLength != (long)size) {
            throw new IOException("Content-Length (" + contentLength + ") and stream length (" + size + ") disagree");
        }
        return (T)bytes;
    }

    @NotNull
    public final Reader charStream() {
        Reader reader = this.reader;
        if (reader == null) {
            BomAwareReader bomAwareReader;
            BomAwareReader it = bomAwareReader = new BomAwareReader(this.source(), this.charset());
            boolean bl = false;
            this.reader = it;
            reader = bomAwareReader;
        }
        return reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String string() throws IOException {
        String string;
        Closeable closeable = (Closeable)this.source();
        Throwable throwable = null;
        try {
            BufferedSource source = (BufferedSource)closeable;
            boolean bl = false;
            string = source.readString(UtilKt.readBomAsCharset(source, this.charset()));
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return string;
    }

    private final Charset charset() {
        Object object = this.contentType();
        if (object == null || (object = ((MediaType)object).charset(Charsets.UTF_8)) == null) {
            object = Charsets.UTF_8;
        }
        return object;
    }

    @Override
    public void close() {
        UtilKt.closeQuietly((Closeable)this.source());
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0019\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\rH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lokcronet/http/ResponseBody$BomAwareReader;", "Ljava/io/Reader;", "source", "Lokio/BufferedSource;", "charset", "Ljava/nio/charset/Charset;", "(Lokio/BufferedSource;Ljava/nio/charset/Charset;)V", "closed", "", "delegate", "close", "", "read", "", "cbuf", "", "off", "len", "okcronet_release"})
    @SourceDebugExtension(value={"SMAP\nResponseBody.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResponseBody.kt\nokcronet/http/ResponseBody$BomAwareReader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,222:1\n1#2:223\n*E\n"})
    public static final class BomAwareReader
    extends Reader {
        @NotNull
        private final BufferedSource source;
        @NotNull
        private final Charset charset;
        private boolean closed;
        @Nullable
        private Reader delegate;

        public BomAwareReader(@NotNull BufferedSource source, @NotNull Charset charset) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
            this.source = source;
            this.charset = charset;
        }

        @Override
        public int read(@NotNull char[] cbuf, int off, int len) throws IOException {
            Intrinsics.checkNotNullParameter((Object)cbuf, (String)"cbuf");
            if (this.closed) {
                throw new IOException("Stream closed");
            }
            Reader reader = this.delegate;
            if (reader == null) {
                InputStreamReader inputStreamReader;
                InputStreamReader it = inputStreamReader = new InputStreamReader(this.source.inputStream(), UtilKt.readBomAsCharset(this.source, this.charset));
                boolean bl = false;
                this.delegate = it;
                reader = inputStreamReader;
            }
            Reader finalDelegate = reader;
            return finalDelegate.read(cbuf, off, len);
        }

        @Override
        public void close() throws IOException {
            block2: {
                Unit unit;
                this.closed = true;
                Reader reader = this.delegate;
                if (reader != null) {
                    reader.close();
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                if (unit != null) break block2;
                BomAwareReader $this$close_u24lambda_u241 = this;
                boolean bl = false;
                $this$close_u24lambda_u241.source.close();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0012\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u0004*\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\b\u0002\u0010\b\u001a\u00020\tJ\u0016\u0010\n\u001a\u00020\u0004*\u00020\u000b2\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007J\u0016\u0010\n\u001a\u00020\u0004*\u00020\f2\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007J\u0016\u0010\n\u001a\u00020\u0004*\u00020\r2\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a8\u0006\u000e"}, d2={"Lokcronet/http/ResponseBody$Companion;", "", "()V", "asResponseBody", "Lokcronet/http/ResponseBody;", "Lokio/BufferedSource;", "contentType", "Lokcronet/http/MediaType;", "contentLength", "", "toResponseBody", "", "", "Lokio/ByteString;", "okcronet_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ResponseBody toResponseBody(@NotNull String $this$toResponseBody, @Nullable MediaType contentType) {
            Intrinsics.checkNotNullParameter((Object)$this$toResponseBody, (String)"<this>");
            Charset charset = Charsets.UTF_8;
            MediaType finalContentType = contentType;
            if (contentType != null) {
                Charset resolvedCharset = MediaType.charset$default(contentType, null, 1, null);
                if (resolvedCharset == null) {
                    charset = Charsets.UTF_8;
                    finalContentType = MediaType.Companion.toMediaTypeOrNull(contentType + "; charset=utf-8");
                } else {
                    charset = resolvedCharset;
                }
            }
            Buffer buffer = new Buffer().writeString($this$toResponseBody, charset);
            return this.asResponseBody((BufferedSource)buffer, finalContentType, buffer.size());
        }

        public static /* synthetic */ ResponseBody toResponseBody$default(Companion companion, String string, MediaType mediaType, int n, Object object) {
            if ((n & 1) != 0) {
                mediaType = null;
            }
            return companion.toResponseBody(string, mediaType);
        }

        @NotNull
        public final ResponseBody toResponseBody(@NotNull byte[] $this$toResponseBody, @Nullable MediaType contentType) {
            Intrinsics.checkNotNullParameter((Object)$this$toResponseBody, (String)"<this>");
            return this.asResponseBody((BufferedSource)new Buffer().write($this$toResponseBody), contentType, $this$toResponseBody.length);
        }

        public static /* synthetic */ ResponseBody toResponseBody$default(Companion companion, byte[] byArray, MediaType mediaType, int n, Object object) {
            if ((n & 1) != 0) {
                mediaType = null;
            }
            return companion.toResponseBody(byArray, mediaType);
        }

        @NotNull
        public final ResponseBody toResponseBody(@NotNull ByteString $this$toResponseBody, @Nullable MediaType contentType) {
            Intrinsics.checkNotNullParameter((Object)$this$toResponseBody, (String)"<this>");
            return this.asResponseBody((BufferedSource)new Buffer().write($this$toResponseBody), contentType, $this$toResponseBody.size());
        }

        public static /* synthetic */ ResponseBody toResponseBody$default(Companion companion, ByteString byteString, MediaType mediaType, int n, Object object) {
            if ((n & 1) != 0) {
                mediaType = null;
            }
            return companion.toResponseBody(byteString, mediaType);
        }

        @NotNull
        public final ResponseBody asResponseBody(@NotNull BufferedSource $this$asResponseBody, @Nullable MediaType contentType, long contentLength) {
            Intrinsics.checkNotNullParameter((Object)$this$asResponseBody, (String)"<this>");
            return new ResponseBody(contentType, contentLength, $this$asResponseBody){
                final /* synthetic */ MediaType $contentType;
                final /* synthetic */ long $contentLength;
                final /* synthetic */ BufferedSource $this_asResponseBody;
                {
                    this.$contentType = $contentType;
                    this.$contentLength = $contentLength;
                    this.$this_asResponseBody = $receiver;
                }

                @Nullable
                public MediaType contentType() {
                    return this.$contentType;
                }

                public long contentLength() {
                    return this.$contentLength;
                }

                @NotNull
                public BufferedSource source() {
                    return this.$this_asResponseBody;
                }
            };
        }

        public static /* synthetic */ ResponseBody asResponseBody$default(Companion companion, BufferedSource bufferedSource, MediaType mediaType, long l, int n, Object object) {
            if ((n & 1) != 0) {
                mediaType = null;
            }
            if ((n & 2) != 0) {
                l = -1L;
            }
            return companion.asResponseBody(bufferedSource, mediaType, l);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

