/*
 * Decompiled with CFR 0.152.
 */
package okcronet.http;

import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import okcronet.DirectExecutor;
import okcronet.UploadDataHelper;
import okcronet.http.Cookie;
import okcronet.http.RequestBody;
import okio.BufferedSource;
import okio.ByteString;
import okio.Options;
import org.chromium.net.UploadDataProvider;
import org.chromium.net.UrlRequest;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0086\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\tH\u0000\u001a)\u0010\f\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r2\u0012\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u000f\"\u00020\u0010H\u0000\u00a2\u0006\u0002\u0010\u0011\u001a\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\rH\u0000\u001a\u0018\u0010\u0015\u001a\u00020\u0016*\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018\u001a\u0015\u0010\u001a\u001a\u00020\u001b*\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001bH\u0080\u0004\u001a\u0015\u0010\u001a\u001a\u00020\t*\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\tH\u0080\u0004\u001a\u0015\u0010\u001a\u001a\u00020\u001b*\u00020\u001e2\u0006\u0010\u001d\u001a\u00020\u001bH\u0080\u0004\u001a\f\u0010\u001f\u001a\u00020\u0013*\u00020\rH\u0000\u001a\f\u0010 \u001a\u00020\u0007*\u00020!H\u0000\u001a(\u0010\"\u001a\u00020\u001b*\u00020\r2\u0006\u0010#\u001a\u00020$2\b\b\u0002\u0010%\u001a\u00020\u001b2\b\b\u0002\u0010&\u001a\u00020\u001bH\u0000\u001a(\u0010\"\u001a\u00020\u001b*\u00020\r2\u0006\u0010'\u001a\u00020\r2\b\b\u0002\u0010%\u001a\u00020\u001b2\b\b\u0002\u0010&\u001a\u00020\u001bH\u0000\u001a\f\u0010(\u001a\u00020\u001b*\u00020\rH\u0000\u001a \u0010)\u001a\u00020\u001b*\u00020\r2\b\b\u0002\u0010%\u001a\u00020\u001b2\b\b\u0002\u0010&\u001a\u00020\u001bH\u0000\u001a \u0010*\u001a\u00020\u001b*\u00020\r2\b\b\u0002\u0010%\u001a\u00020\u001b2\b\b\u0002\u0010&\u001a\u00020\u001bH\u0000\u001a\f\u0010+\u001a\u00020\u001b*\u00020$H\u0000\u001a\u0014\u0010,\u001a\u00020-*\u00020.2\u0006\u0010/\u001a\u00020-H\u0000\u001a\u001c\u00100\u001a\u00020\u0016*\u00020\u00162\u0006\u00101\u001a\u0002022\b\b\u0002\u00103\u001a\u00020\t\u001a\u0014\u00104\u001a\u000205*\u0002022\b\b\u0002\u00103\u001a\u00020\t\u001a \u00106\u001a\u00020\r*\u00020\r2\b\b\u0002\u0010%\u001a\u00020\u001b2\b\b\u0002\u0010&\u001a\u00020\u001bH\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0002\u001a\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u00067"}, d2={"UNICODE_BOMS", "Lokio/Options;", "VERIFY_AS_IP_ADDRESS", "Lkotlin/text/Regex;", "getVERIFY_AS_IP_ADDRESS", "()Lkotlin/text/Regex;", "checkOffsetAndCount", "", "arrayLength", "", "offset", "count", "format", "", "args", "", "", "(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", "isSensitiveHeader", "", "name", "addCookie", "Lorg/chromium/net/UrlRequest$Builder;", "cookies", "", "Lokcronet/http/Cookie;", "and", "", "", "mask", "", "canParseAsIpAddress", "closeQuietly", "Ljava/io/Closeable;", "delimiterOffset", "delimiter", "", "startIndex", "endIndex", "delimiters", "indexOfControlOrNonAscii", "indexOfFirstNonAsciiWhitespace", "indexOfLastNonAsciiWhitespace", "parseHexDigit", "readBomAsCharset", "Ljava/nio/charset/Charset;", "Lokio/BufferedSource;", "default", "setRequestBody", "body", "Lokcronet/http/RequestBody;", "writeTimeoutMillis", "toUploadDataProvider", "Lorg/chromium/net/UploadDataProvider;", "trimSubstring", "okcronet_release"})
public final class UtilKt {
    @NotNull
    private static final Options UNICODE_BOMS;

    private static final Regex getVERIFY_AS_IP_ADDRESS() {
        return new Regex("([0-9a-fA-F]*:[0-9a-fA-F:.]*)|([\\d.]+)");
    }

    public static final void checkOffsetAndCount(long arrayLength, long offset, long count) {
        if ((offset | count) < 0L || offset > arrayLength || arrayLength - offset < count) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    public static final int delimiterOffset(@NotNull String $this$delimiterOffset, @NotNull String delimiters, int startIndex, int endIndex) {
        Intrinsics.checkNotNullParameter((Object)$this$delimiterOffset, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)delimiters, (String)"delimiters");
        for (int i = startIndex; i < endIndex; ++i) {
            if (!StringsKt.contains$default((CharSequence)delimiters, (char)$this$delimiterOffset.charAt(i), (boolean)false, (int)2, null)) continue;
            return i;
        }
        return endIndex;
    }

    public static /* synthetic */ int delimiterOffset$default(String string, String string2, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = string.length();
        }
        return UtilKt.delimiterOffset(string, string2, n, n2);
    }

    public static final int delimiterOffset(@NotNull String $this$delimiterOffset, char delimiter, int startIndex, int endIndex) {
        Intrinsics.checkNotNullParameter((Object)$this$delimiterOffset, (String)"<this>");
        for (int i = startIndex; i < endIndex; ++i) {
            if ($this$delimiterOffset.charAt(i) != delimiter) continue;
            return i;
        }
        return endIndex;
    }

    public static /* synthetic */ int delimiterOffset$default(String string, char c, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = string.length();
        }
        return UtilKt.delimiterOffset(string, c, n, n2);
    }

    public static final int indexOfControlOrNonAscii(@NotNull String $this$indexOfControlOrNonAscii) {
        Intrinsics.checkNotNullParameter((Object)$this$indexOfControlOrNonAscii, (String)"<this>");
        int n = $this$indexOfControlOrNonAscii.length();
        for (int i = 0; i < n; ++i) {
            char c = $this$indexOfControlOrNonAscii.charAt(i);
            if (Intrinsics.compare((int)c, (int)31) > 0 && Intrinsics.compare((int)c, (int)127) < 0) continue;
            return i;
        }
        return -1;
    }

    public static final boolean canParseAsIpAddress(@NotNull String $this$canParseAsIpAddress) {
        Intrinsics.checkNotNullParameter((Object)$this$canParseAsIpAddress, (String)"<this>");
        return UtilKt.getVERIFY_AS_IP_ADDRESS().matches((CharSequence)$this$canParseAsIpAddress);
    }

    public static final int indexOfFirstNonAsciiWhitespace(@NotNull String $this$indexOfFirstNonAsciiWhitespace, int startIndex, int endIndex) {
        Intrinsics.checkNotNullParameter((Object)$this$indexOfFirstNonAsciiWhitespace, (String)"<this>");
        for (int i = startIndex; i < endIndex; ++i) {
            char c = $this$indexOfFirstNonAsciiWhitespace.charAt(i);
            if ((((c == '\t' ? true : c == '\n') ? true : c == '\f') ? true : c == '\r') ? true : c == ' ') continue;
            return i;
        }
        return endIndex;
    }

    public static /* synthetic */ int indexOfFirstNonAsciiWhitespace$default(String string, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = 0;
        }
        if ((n3 & 2) != 0) {
            n2 = string.length();
        }
        return UtilKt.indexOfFirstNonAsciiWhitespace(string, n, n2);
    }

    public static final int indexOfLastNonAsciiWhitespace(@NotNull String $this$indexOfLastNonAsciiWhitespace, int startIndex, int endIndex) {
        Intrinsics.checkNotNullParameter((Object)$this$indexOfLastNonAsciiWhitespace, (String)"<this>");
        int i = endIndex - 1;
        if (startIndex <= i) {
            while (true) {
                char c;
                if (!(((((c = $this$indexOfLastNonAsciiWhitespace.charAt(i)) == '\t' ? true : c == '\n') ? true : c == '\f') ? true : c == '\r') ? true : c == ' ')) {
                    return i + 1;
                }
                if (i == startIndex) break;
                --i;
            }
        }
        return startIndex;
    }

    public static /* synthetic */ int indexOfLastNonAsciiWhitespace$default(String string, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = 0;
        }
        if ((n3 & 2) != 0) {
            n2 = string.length();
        }
        return UtilKt.indexOfLastNonAsciiWhitespace(string, n, n2);
    }

    public static final int parseHexDigit(char $this$parseHexDigit) {
        int n;
        block1: {
            char c;
            block0: {
                c = $this$parseHexDigit;
                boolean bl = '0' <= c ? c < ':' : false;
                if (!bl) break block0;
                n = $this$parseHexDigit - 48;
                break block1;
            }
            n = ('a' <= c ? c < 'g' : false) ? $this$parseHexDigit - 97 + 10 : (('A' <= c ? c < 'G' : false) ? $this$parseHexDigit - 65 + 10 : -1);
        }
        return n;
    }

    public static final int and(byte $this$and, int mask) {
        return $this$and & mask;
    }

    public static final int and(short $this$and, int mask) {
        return $this$and & mask;
    }

    public static final long and(int $this$and, long mask) {
        return (long)$this$and & mask;
    }

    @NotNull
    public static final String trimSubstring(@NotNull String $this$trimSubstring, int startIndex, int endIndex) {
        Intrinsics.checkNotNullParameter((Object)$this$trimSubstring, (String)"<this>");
        int start = UtilKt.indexOfFirstNonAsciiWhitespace($this$trimSubstring, startIndex, endIndex);
        int end = UtilKt.indexOfLastNonAsciiWhitespace($this$trimSubstring, start, endIndex);
        String string = $this$trimSubstring.substring(start, end);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return string;
    }

    public static /* synthetic */ String trimSubstring$default(String string, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = 0;
        }
        if ((n3 & 2) != 0) {
            n2 = string.length();
        }
        return UtilKt.trimSubstring(string, n, n2);
    }

    public static final boolean isSensitiveHeader(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return StringsKt.equals((String)name, (String)"Authorization", (boolean)true) || StringsKt.equals((String)name, (String)"Cookie", (boolean)true) || StringsKt.equals((String)name, (String)"Proxy-Authorization", (boolean)true) || StringsKt.equals((String)name, (String)"Set-Cookie", (boolean)true);
    }

    @NotNull
    public static final String format(@NotNull String format, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Locale locale = Locale.US;
        Object[] objectArray = Arrays.copyOf(args, args.length);
        String string = String.format(locale, format, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }

    @NotNull
    public static final Charset readBomAsCharset(@NotNull BufferedSource $this$readBomAsCharset, @NotNull Charset charset) throws IOException {
        Charset charset2;
        Intrinsics.checkNotNullParameter((Object)$this$readBomAsCharset, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"default");
        switch ($this$readBomAsCharset.select(UNICODE_BOMS)) {
            case 0: {
                Charset charset3 = StandardCharsets.UTF_8;
                charset2 = charset3;
                Intrinsics.checkNotNullExpressionValue((Object)charset3, (String)"UTF_8");
                break;
            }
            case 1: {
                Charset charset4 = StandardCharsets.UTF_16BE;
                charset2 = charset4;
                Intrinsics.checkNotNullExpressionValue((Object)charset4, (String)"UTF_16BE");
                break;
            }
            case 2: {
                Charset charset5 = StandardCharsets.UTF_16LE;
                charset2 = charset5;
                Intrinsics.checkNotNullExpressionValue((Object)charset5, (String)"UTF_16LE");
                break;
            }
            case 3: {
                charset2 = Charsets.INSTANCE.UTF32_BE();
                break;
            }
            case 4: {
                charset2 = Charsets.INSTANCE.UTF32_LE();
                break;
            }
            case -1: {
                charset2 = charset;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return charset2;
    }

    public static final void closeQuietly(@NotNull Closeable $this$closeQuietly) {
        Intrinsics.checkNotNullParameter((Object)$this$closeQuietly, (String)"<this>");
        try {
            $this$closeQuietly.close();
        }
        catch (RuntimeException rethrown) {
            throw rethrown;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @NotNull
    public static final UrlRequest.Builder addCookie(@NotNull UrlRequest.Builder $this$addCookie, @NotNull List<Cookie> cookies) {
        Intrinsics.checkNotNullParameter((Object)$this$addCookie, (String)"<this>");
        Intrinsics.checkNotNullParameter(cookies, (String)"cookies");
        if (!((Collection)cookies).isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            for (Cookie cookie : cookies) {
                stringBuilder.append(cookie.toString()).append(";");
            }
            if (((CharSequence)stringBuilder).length() > 0) {
                $this$addCookie.addHeader("Cookie", stringBuilder.toString());
            }
        }
        return $this$addCookie;
    }

    @NotNull
    public static final UrlRequest.Builder setRequestBody(@NotNull UrlRequest.Builder $this$setRequestBody, @NotNull RequestBody body, long writeTimeoutMillis) {
        Intrinsics.checkNotNullParameter((Object)$this$setRequestBody, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        UrlRequest.Builder builder = $this$setRequestBody.setUploadDataProvider(UtilKt.toUploadDataProvider(body, writeTimeoutMillis), (Executor)DirectExecutor.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"setUploadDataProvider(...)");
        return builder;
    }

    public static /* synthetic */ UrlRequest.Builder setRequestBody$default(UrlRequest.Builder builder, RequestBody requestBody, long l, int n, Object object) {
        if ((n & 2) != 0) {
            l = 20000L;
        }
        return UtilKt.setRequestBody(builder, requestBody, l);
    }

    @NotNull
    public static final UploadDataProvider toUploadDataProvider(@NotNull RequestBody $this$toUploadDataProvider, long writeTimeoutMillis) {
        Intrinsics.checkNotNullParameter((Object)$this$toUploadDataProvider, (String)"<this>");
        return UploadDataHelper.Companion.getUploadDataProvider($this$toUploadDataProvider, writeTimeoutMillis);
    }

    public static /* synthetic */ UploadDataProvider toUploadDataProvider$default(RequestBody requestBody, long l, int n, Object object) {
        if ((n & 1) != 0) {
            l = 20000L;
        }
        return UtilKt.toUploadDataProvider(requestBody, l);
    }

    static {
        ByteString[] byteStringArray = new ByteString[]{ByteString.Companion.decodeHex("efbbbf"), ByteString.Companion.decodeHex("feff"), ByteString.Companion.decodeHex("fffe"), ByteString.Companion.decodeHex("0000ffff"), ByteString.Companion.decodeHex("ffff0000")};
        UNICODE_BOMS = Options.Companion.of(byteStringArray);
    }
}

