/*
 * Decompiled with CFR 0.152.
 */
package okcronet;

import java.io.IOException;
import java.net.ProtocolException;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okcronet.SourceCallback;
import okcronet.http.CookieJar;
import okcronet.http.MediaType;
import okcronet.http.Request;
import okcronet.http.Response;
import okcronet.http.ResponseBody;
import okio.Okio;
import okio.Source;
import org.chromium.net.UrlResponseInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ \u0010\u0010\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u001a\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lokcronet/ResponseCallback;", "Lokcronet/SourceCallback;", "request", "Lokcronet/http/Request;", "readTimeoutMillis", "", "cookieJar", "Lokcronet/http/CookieJar;", "isFollowRedirect", "", "<init>", "(Lokcronet/http/Request;JLokcronet/http/CookieJar;Z)V", "response", "Lokcronet/http/Response;", "getResponse", "()Lokcronet/http/Response;", "createResponse", "cronetResponseInfo", "Lorg/chromium/net/UrlResponseInfo;", "bodySource", "Lokio/Source;", "createResponseBody", "Lokcronet/http/ResponseBody;", "getLastHeaderValue", "", "name", "responseInfo", "okcronet_release"})
public final class ResponseCallback
extends SourceCallback {
    @NotNull
    private final Request request;

    public ResponseCallback(@NotNull Request request, long readTimeoutMillis, @Nullable CookieJar cookieJar, boolean isFollowRedirect) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        super(readTimeoutMillis, cookieJar, isFollowRedirect);
        this.request = request;
    }

    public /* synthetic */ ResponseCallback(Request request, long l, CookieJar cookieJar, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            cookieJar = null;
        }
        this(request, l, cookieJar, bl);
    }

    @NotNull
    public final Response getResponse() throws IOException {
        return this.createResponse(this.request, this.getUrlResponseInfo(), this.getSource());
    }

    private final Response createResponse(Request request, UrlResponseInfo cronetResponseInfo, Source bodySource) throws IOException {
        Response.Builder responseBuilder = new Response.Builder().urlResponseInfo(cronetResponseInfo).requestParameter(request);
        ResponseBody responseBody = this.createResponseBody(cronetResponseInfo, bodySource);
        return responseBuilder.body(responseBody).build();
    }

    private final ResponseBody createResponseBody(UrlResponseInfo cronetResponseInfo, Source bodySource) throws IOException {
        long l;
        String contentType = this.getLastHeaderValue("Content-Type", cronetResponseInfo);
        String contentLengthString = this.getLastHeaderValue("Content-Length", cronetResponseInfo);
        try {
            String string = contentLengthString;
            l = string != null ? Long.parseLong(string) : -1L;
        }
        catch (NumberFormatException numberFormatException) {
            l = -1L;
        }
        long contentLength = l;
        int httpStatusCode = cronetResponseInfo.getHttpStatusCode();
        if ((httpStatusCode == 204 || httpStatusCode == 205) && contentLength > 0L) {
            throw new ProtocolException("HTTP " + httpStatusCode + " had non-zero Content-Length: " + contentLengthString);
        }
        String string = contentType;
        return ResponseBody.Companion.asResponseBody(Okio.buffer((Source)bodySource), string != null ? MediaType.Companion.toMediaTypeOrNull(string) : null, contentLength);
    }

    private final String getLastHeaderValue(String name, UrlResponseInfo responseInfo) {
        List list = (List)responseInfo.getAllHeaders().get(name);
        return list != null ? (String)CollectionsKt.lastOrNull((List)list) : null;
    }
}

