/*
 * Decompiled with CFR 0.152.
 */
package okcronet;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okcronet.CompletableFutureCompat;
import okio.Buffer;
import okio.Sink;
import okio.Timeout;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\"B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\u00102\u0006\u0010\u0011\u001a\u00020\u0007J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000eJ\u0006\u0010\u0015\u001a\u00020\u0013J\u0018\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001e\u001a\u00020\u0013H\u0016J\b\u0010\u001f\u001a\u00020\u0013H\u0016J\b\u0010 \u001a\u00020!H\u0016R&\u0010\u0004\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u001b\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006#"}, d2={"Lokcronet/UploadBodyDataSink;", "Lokio/Sink;", "<init>", "()V", "pendingRead", "Ljava/util/concurrent/BlockingQueue;", "Lkotlin/Pair;", "Ljava/nio/ByteBuffer;", "Lokcronet/CompletableFutureCompat;", "Lokcronet/UploadBodyDataSink$ReadResult;", "isClosed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "backgroundReadThrowable", "Ljava/util/concurrent/atomic/AtomicReference;", "", "enqueueBodyRead", "Ljava/util/concurrent/Future;", "readBuffer", "setBackgroundReadError", "", "t", "handleEndOfStreamSignal", "write", "source", "Lokio/Buffer;", "byteCount", "", "pendingCronetRead", "getPendingCronetRead", "()Lkotlin/Pair;", "close", "flush", "timeout", "Lokio/Timeout;", "ReadResult", "okcronet_release"})
@SourceDebugExtension(value={"SMAP\nUploadBodyDataSink.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UploadBodyDataSink.kt\nokcronet/UploadBodyDataSink\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,175:1\n1#2:176\n*E\n"})
public final class UploadBodyDataSink
implements Sink {
    @NotNull
    private final BlockingQueue<Pair<ByteBuffer, CompletableFutureCompat<ReadResult>>> pendingRead = new ArrayBlockingQueue(1);
    @NotNull
    private final AtomicBoolean isClosed = new AtomicBoolean();
    @NotNull
    private final AtomicReference<Throwable> backgroundReadThrowable = new AtomicReference();

    @NotNull
    public final Future<ReadResult> enqueueBodyRead(@NotNull ByteBuffer readBuffer) {
        Throwable throwable;
        Intrinsics.checkNotNullParameter((Object)readBuffer, (String)"readBuffer");
        Throwable backgroundThrowable = null;
        backgroundThrowable = this.backgroundReadThrowable.get();
        if (backgroundThrowable != null) {
            CompletableFutureCompat future = new CompletableFutureCompat();
            future.completeExceptionally(backgroundThrowable);
            return future;
        }
        CompletableFutureCompat future = new CompletableFutureCompat();
        this.pendingRead.add((Pair<ByteBuffer, CompletableFutureCompat<ReadResult>>)new Pair((Object)readBuffer, future));
        Throwable it = throwable = this.backgroundReadThrowable.get();
        boolean bl = false;
        backgroundThrowable = it;
        if (throwable != null) {
            Throwable throwable2 = backgroundThrowable;
            Intrinsics.checkNotNull((Object)throwable2);
            future.completeExceptionally(throwable2);
        }
        return future;
    }

    public final void setBackgroundReadError(@NotNull Throwable t) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            this.backgroundReadThrowable.set(t);
            Pair read = (Pair)this.pendingRead.poll();
            Object object = read;
            if (object == null || (object = (CompletableFutureCompat)object.getSecond()) == null) break block0;
            ((CompletableFutureCompat)object).completeExceptionally(t);
        }
    }

    public final void handleEndOfStreamSignal() throws IOException {
        if (!(!this.isClosed.getAndSet(true))) {
            boolean bl = false;
            String string = "Already closed";
            throw new IllegalStateException(string.toString());
        }
        ((CompletableFutureCompat)this.getPendingCronetRead().getSecond()).complete(ReadResult.END_OF_BODY);
    }

    public void write(@NotNull Buffer source, long byteCount) throws IOException {
        long bytesRead;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (!(!this.isClosed.get())) {
            throw new IllegalStateException("Check failed.");
        }
        for (long bytesRemaining = byteCount; bytesRemaining != 0L; bytesRemaining -= bytesRead) {
            Pair<ByteBuffer, CompletableFutureCompat<ReadResult>> payload = this.getPendingCronetRead();
            ByteBuffer readBuffer = (ByteBuffer)payload.getFirst();
            CompletableFutureCompat future = (CompletableFutureCompat)payload.getSecond();
            int originalBufferLimit = readBuffer.limit();
            int bytesToDrain = (int)Math.min((long)originalBufferLimit, bytesRemaining);
            readBuffer.limit(bytesToDrain);
            try {
                bytesRead = source.read(readBuffer);
                if (bytesRead == -1L) {
                    IOException e = new IOException("The source has been exhausted but we expected more!");
                    future.completeExceptionally(e);
                    throw e;
                }
                readBuffer.limit(originalBufferLimit);
                future.complete(ReadResult.SUCCESS);
                continue;
            }
            catch (IOException e) {
                future.completeExceptionally(e);
                throw e;
            }
        }
    }

    private final Pair<ByteBuffer, CompletableFutureCompat<ReadResult>> getPendingCronetRead() throws IOException {
        Pair<ByteBuffer, CompletableFutureCompat<ReadResult>> pair;
        try {
            pair = this.pendingRead.take();
            Intrinsics.checkNotNull(pair);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException("Interrupted while waiting for a read to finish!");
        }
        return pair;
    }

    public void close() {
        this.isClosed.set(true);
    }

    public void flush() {
    }

    @NotNull
    public Timeout timeout() {
        return Timeout.NONE;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0080\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lokcronet/UploadBodyDataSink$ReadResult;", "", "<init>", "(Ljava/lang/String;I)V", "SUCCESS", "END_OF_BODY", "okcronet_release"})
    public static final class ReadResult
    extends Enum<ReadResult> {
        public static final /* enum */ ReadResult SUCCESS = new ReadResult();
        public static final /* enum */ ReadResult END_OF_BODY = new ReadResult();
        private static final /* synthetic */ ReadResult[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ReadResult[] values() {
            return (ReadResult[])$VALUES.clone();
        }

        public static ReadResult valueOf(String value) {
            return Enum.valueOf(ReadResult.class, value);
        }

        @NotNull
        public static EnumEntries<ReadResult> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = readResultArray = new ReadResult[]{ReadResult.SUCCESS, ReadResult.END_OF_BODY};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

