/*
 * Decompiled with CFR 0.152.
 */
package okcronet;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okcronet.UploadBodyDataSink;
import okcronet.UtilKt;
import okcronet.http.RequestBody;
import okio.Buffer;
import okio.BufferedSink;
import okio.Okio;
import okio.Sink;
import org.chromium.net.UploadDataProvider;
import org.chromium.net.UploadDataSink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lokcronet/UploadDataHelper;", "", "<init>", "()V", "Companion", "okcronet_release"})
public final class UploadDataHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final long IN_MEMORY_BODY_LENGTH_THRESHOLD_BYTES = 0x100000L;

    private UploadDataHelper() {
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0002\u000f\u0010B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lokcronet/UploadDataHelper$Companion;", "", "<init>", "()V", "IN_MEMORY_BODY_LENGTH_THRESHOLD_BYTES", "", "getUploadDataProvider", "Lorg/chromium/net/UploadDataProvider;", "requestBody", "Lokcronet/http/RequestBody;", "writeTimeoutMillis", "prepareBodyTooLongException", "Ljava/io/IOException;", "expectedLength", "minActualLength", "StreamingUploadDataProvider", "InMemoryRequestBodyConverter", "okcronet_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final UploadDataProvider getUploadDataProvider(@NotNull RequestBody requestBody, long writeTimeoutMillis) {
            Intrinsics.checkNotNullParameter((Object)requestBody, (String)"requestBody");
            long contentLength = requestBody.length();
            return contentLength == -1L || contentLength > 0x100000L ? (UploadDataProvider)new StreamingUploadDataProvider(requestBody, new UploadBodyDataSink(), writeTimeoutMillis, null, 8, null) : (UploadDataProvider)new InMemoryRequestBodyConverter(requestBody);
        }

        private final IOException prepareBodyTooLongException(long expectedLength, long minActualLength) {
            return new IOException("Expected " + expectedLength + " bytes but got at least " + minActualLength);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lokcronet/UploadDataHelper$Companion$InMemoryRequestBodyConverter;", "Lorg/chromium/net/UploadDataProvider;", "requestBody", "Lokcronet/http/RequestBody;", "<init>", "(Lokcronet/http/RequestBody;)V", "isMaterialized", "", "materializedBody", "Lokio/Buffer;", "getLength", "", "read", "", "uploadDataSink", "Lorg/chromium/net/UploadDataSink;", "byteBuffer", "Ljava/nio/ByteBuffer;", "rewind", "okcronet_release"})
        private static final class InMemoryRequestBodyConverter
        extends UploadDataProvider {
            @NotNull
            private final RequestBody requestBody;
            private volatile boolean isMaterialized;
            @NotNull
            private final Buffer materializedBody;

            public InMemoryRequestBodyConverter(@NotNull RequestBody requestBody) {
                Intrinsics.checkNotNullParameter((Object)requestBody, (String)"requestBody");
                this.requestBody = requestBody;
                this.materializedBody = new Buffer();
            }

            public long getLength() {
                return this.requestBody.length();
            }

            public void read(@NotNull UploadDataSink uploadDataSink, @NotNull ByteBuffer byteBuffer) throws IOException {
                Intrinsics.checkNotNullParameter((Object)uploadDataSink, (String)"uploadDataSink");
                Intrinsics.checkNotNullParameter((Object)byteBuffer, (String)"byteBuffer");
                if (!this.isMaterialized) {
                    this.requestBody.writeTo((BufferedSink)this.materializedBody);
                    this.materializedBody.flush();
                    this.isMaterialized = true;
                    long reportedLength = this.getLength();
                    long actualLength = this.materializedBody.size();
                    if (actualLength != reportedLength) {
                        uploadDataSink.onReadError((Exception)new IOException("Expected " + reportedLength + " bytes but got " + actualLength));
                        return;
                    }
                }
                if (!(this.materializedBody.read(byteBuffer) != -1)) {
                    boolean bl = false;
                    String string = "The source has been exhausted but we expected more!";
                    throw new IllegalStateException(string.toString());
                }
                uploadDataSink.onReadSucceeded(false);
            }

            public void rewind(@NotNull UploadDataSink uploadDataSink) {
                Intrinsics.checkNotNullParameter((Object)uploadDataSink, (String)"uploadDataSink");
                this.isMaterialized = false;
                this.materializedBody.clear();
                uploadDataSink.onRewindSucceeded();
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u000f\u001a\u00020\u0007H\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0015H\u0002J\u0018\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010\u001a\u001a\u00020\u0011H\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lokcronet/UploadDataHelper$Companion$StreamingUploadDataProvider;", "Lorg/chromium/net/UploadDataProvider;", "requestBody", "Lokcronet/http/RequestBody;", "sink", "Lokcronet/UploadBodyDataSink;", "writeTimeoutMillis", "", "readTaskExecutor", "Ljava/util/concurrent/ExecutorService;", "<init>", "(Lokcronet/http/RequestBody;Lokcronet/UploadBodyDataSink;JLjava/util/concurrent/ExecutorService;)V", "readTaskFuture", "Ljava/util/concurrent/Future;", "totalBytesReadFromHttp", "getLength", "read", "", "uploadDataSink", "Lorg/chromium/net/UploadDataSink;", "byteBuffer", "Ljava/nio/ByteBuffer;", "readKnownBodyLength", "handleLastBodyRead", "filledByteBuffer", "readUnknownBodyLength", "ensureReadTaskStarted", "readFromByteBuffer", "Lokcronet/UploadBodyDataSink$ReadResult;", "rewind", "okcronet_release"})
        private static final class StreamingUploadDataProvider
        extends UploadDataProvider {
            @NotNull
            private final RequestBody requestBody;
            @NotNull
            private final UploadBodyDataSink sink;
            @NotNull
            private final ExecutorService readTaskExecutor;
            private final long writeTimeoutMillis;
            @Nullable
            private volatile Future<?> readTaskFuture;
            private long totalBytesReadFromHttp;

            public StreamingUploadDataProvider(@NotNull RequestBody requestBody, @NotNull UploadBodyDataSink sink, long writeTimeoutMillis, @NotNull ExecutorService readTaskExecutor) {
                Intrinsics.checkNotNullParameter((Object)requestBody, (String)"requestBody");
                Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
                Intrinsics.checkNotNullParameter((Object)readTaskExecutor, (String)"readTaskExecutor");
                this.requestBody = requestBody;
                this.sink = sink;
                this.readTaskExecutor = readTaskExecutor;
                this.writeTimeoutMillis = writeTimeoutMillis == 0L ? Integer.MAX_VALUE : writeTimeoutMillis;
            }

            public /* synthetic */ StreamingUploadDataProvider(RequestBody requestBody, UploadBodyDataSink uploadBodyDataSink, long l, ExecutorService executorService, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 8) != 0) {
                    executorService = Executors.newSingleThreadExecutor();
                }
                this(requestBody, uploadBodyDataSink, l, executorService);
            }

            public long getLength() throws IOException {
                return this.requestBody.length();
            }

            public void read(@NotNull UploadDataSink uploadDataSink, @NotNull ByteBuffer byteBuffer) throws IOException {
                Intrinsics.checkNotNullParameter((Object)uploadDataSink, (String)"uploadDataSink");
                Intrinsics.checkNotNullParameter((Object)byteBuffer, (String)"byteBuffer");
                this.ensureReadTaskStarted();
                if (this.getLength() == -1L) {
                    this.readUnknownBodyLength(uploadDataSink, byteBuffer);
                } else {
                    this.readKnownBodyLength(uploadDataSink, byteBuffer);
                }
            }

            private final void readKnownBodyLength(UploadDataSink uploadDataSink, ByteBuffer byteBuffer) throws IOException {
                try {
                    UploadBodyDataSink.ReadResult readResult = this.readFromByteBuffer(byteBuffer);
                    if (this.totalBytesReadFromHttp > this.getLength()) {
                        throw Companion.prepareBodyTooLongException(this.getLength(), this.totalBytesReadFromHttp);
                    }
                    if (this.totalBytesReadFromHttp < this.getLength()) {
                        switch (WhenMappings.$EnumSwitchMapping$0[readResult.ordinal()]) {
                            case 1: {
                                uploadDataSink.onReadSucceeded(false);
                                break;
                            }
                            case 2: {
                                throw new IOException("The source has been exhausted but we expected more data!");
                            }
                            default: {
                                throw new NoWhenBranchMatchedException();
                            }
                        }
                        return;
                    }
                    this.handleLastBodyRead(uploadDataSink, byteBuffer);
                }
                catch (TimeoutException e) {
                    Future<?> future = this.readTaskFuture;
                    if (future != null) {
                        future.cancel(true);
                    }
                    uploadDataSink.onReadError((Exception)new IOException(e));
                }
                catch (ExecutionException e) {
                    Future<?> future = this.readTaskFuture;
                    if (future != null) {
                        future.cancel(true);
                    }
                    uploadDataSink.onReadError((Exception)new IOException(e));
                }
            }

            private final void handleLastBodyRead(UploadDataSink uploadDataSink, ByteBuffer filledByteBuffer) throws IOException, TimeoutException, ExecutionException {
                int bufferPosition = filledByteBuffer.position();
                filledByteBuffer.position(0);
                if (this.readFromByteBuffer(filledByteBuffer) != UploadBodyDataSink.ReadResult.END_OF_BODY) {
                    throw Companion.prepareBodyTooLongException(this.getLength(), this.totalBytesReadFromHttp);
                }
                if (!(filledByteBuffer.position() == 0)) {
                    boolean bl = false;
                    String string = "END_OF_BODY reads shouldn't write anything to the buffer";
                    throw new IllegalStateException(string.toString());
                }
                filledByteBuffer.position(bufferPosition);
                uploadDataSink.onReadSucceeded(false);
            }

            private final void readUnknownBodyLength(UploadDataSink uploadDataSink, ByteBuffer byteBuffer) {
                try {
                    UploadBodyDataSink.ReadResult readResult = this.readFromByteBuffer(byteBuffer);
                    uploadDataSink.onReadSucceeded(readResult == UploadBodyDataSink.ReadResult.END_OF_BODY);
                }
                catch (TimeoutException e) {
                    Future<?> future = this.readTaskFuture;
                    if (future != null) {
                        future.cancel(true);
                    }
                    uploadDataSink.onReadError((Exception)new IOException(e));
                }
                catch (ExecutionException e) {
                    Future<?> future = this.readTaskFuture;
                    if (future != null) {
                        future.cancel(true);
                    }
                    uploadDataSink.onReadError((Exception)new IOException(e));
                }
            }

            private final void ensureReadTaskStarted() {
                if (this.readTaskFuture == null) {
                    this.readTaskFuture = this.readTaskExecutor.submit(() -> StreamingUploadDataProvider.ensureReadTaskStarted$lambda$1(this));
                }
            }

            private final UploadBodyDataSink.ReadResult readFromByteBuffer(ByteBuffer byteBuffer) throws TimeoutException, ExecutionException {
                int positionBeforeRead = byteBuffer.position();
                UploadBodyDataSink.ReadResult readResult = UtilKt.getUninterruptibly(this.sink.enqueueBodyRead(byteBuffer), this.writeTimeoutMillis, TimeUnit.MILLISECONDS);
                int bytesRead = byteBuffer.position() - positionBeforeRead;
                this.totalBytesReadFromHttp += (long)bytesRead;
                return readResult;
            }

            public void rewind(@NotNull UploadDataSink uploadDataSink) {
                Intrinsics.checkNotNullParameter((Object)uploadDataSink, (String)"uploadDataSink");
                uploadDataSink.onRewindError((Exception)new UnsupportedOperationException("Rewind is not supported!"));
            }

            private static final void ensureReadTaskStarted$lambda$1(StreamingUploadDataProvider this$0) {
                try {
                    BufferedSink bufferedSink = Okio.buffer((Sink)this$0.sink);
                    this$0.requestBody.writeTo(bufferedSink);
                    bufferedSink.flush();
                    this$0.sink.handleEndOfStreamSignal();
                }
                catch (Throwable e) {
                    this$0.sink.setBackgroundReadError(e);
                }
            }

            @Metadata(mv={2, 1, 0}, k=3, xi=48)
            public final class WhenMappings {
                public static final /* synthetic */ int[] $EnumSwitchMapping$0;

                static {
                    int[] nArray = new int[UploadBodyDataSink.ReadResult.values().length];
                    try {
                        nArray[UploadBodyDataSink.ReadResult.SUCCESS.ordinal()] = 1;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[UploadBodyDataSink.ReadResult.END_OF_BODY.ordinal()] = 2;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    $EnumSwitchMapping$0 = nArray;
                }
            }
        }
    }
}

