/*
 * Decompiled with CFR 0.152.
 */
package okcronet.http;

import android.os.ParcelFileDescriptor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import okcronet.http.FileRequestBody;
import okcronet.http.MediaType;
import okcronet.http.UtilKt;
import okio.BufferedSink;
import okio.ByteString;
import okio.Okio;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\u0004\u001a\u0004\u0018\u00010\u0005H&J\b\u0010\u0006\u001a\u00020\u0007H&J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH&\u00a8\u0006\r"}, d2={"Lokcronet/http/RequestBody;", "", "<init>", "()V", "contentType", "Lokcronet/http/MediaType;", "length", "", "writeTo", "", "sink", "Lokio/BufferedSink;", "Companion", "okcronet_release"})
public abstract class RequestBody {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final RequestBody EMPTY_REQUEST_BODY = okcronet.http.RequestBody$Companion.toRequestBody$default(Companion, new byte[0], null, 0, 0, 7, null);

    @Nullable
    public abstract MediaType contentType();

    public abstract long length() throws IOException;

    public abstract void writeTo(@NotNull BufferedSink var1) throws IOException;

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\b\u001a\u00020\u0005*\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000bJ\u0016\u0010\b\u001a\u00020\u0005*\u00020\f2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000bJ\u0016\u0010\b\u001a\u00020\u0005*\u00020\r2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000bJ\u0016\u0010\b\u001a\u00020\u0005*\u00020\u000e2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000bJ*\u0010\b\u001a\u00020\u0005*\u00020\u000f2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\b\u0002\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lokcronet/http/RequestBody$Companion;", "", "<init>", "()V", "EMPTY_REQUEST_BODY", "Lokcronet/http/RequestBody;", "getEMPTY_REQUEST_BODY", "()Lokcronet/http/RequestBody;", "toRequestBody", "Ljava/io/File;", "contentType", "Lokcronet/http/MediaType;", "Landroid/os/ParcelFileDescriptor;", "", "Lokio/ByteString;", "", "offset", "", "byteCount", "okcronet_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RequestBody getEMPTY_REQUEST_BODY() {
            return EMPTY_REQUEST_BODY;
        }

        @NotNull
        public final RequestBody toRequestBody(@NotNull File $this$toRequestBody, @Nullable MediaType contentType) {
            Intrinsics.checkNotNullParameter((Object)$this$toRequestBody, (String)"<this>");
            return new FileRequestBody($this$toRequestBody, contentType);
        }

        public static /* synthetic */ RequestBody toRequestBody$default(Companion companion, File file, MediaType mediaType, int n, Object object) {
            if ((n & 1) != 0) {
                mediaType = null;
            }
            return companion.toRequestBody(file, mediaType);
        }

        @NotNull
        public final RequestBody toRequestBody(@NotNull ParcelFileDescriptor $this$toRequestBody, @Nullable MediaType contentType) {
            Intrinsics.checkNotNullParameter((Object)$this$toRequestBody, (String)"<this>");
            ParcelFileDescriptor.AutoCloseInputStream inputStream = new ParcelFileDescriptor.AutoCloseInputStream($this$toRequestBody);
            return new RequestBody(contentType, $this$toRequestBody, inputStream){
                final /* synthetic */ MediaType $contentType;
                final /* synthetic */ ParcelFileDescriptor $this_toRequestBody;
                final /* synthetic */ ParcelFileDescriptor.AutoCloseInputStream $inputStream;
                {
                    this.$contentType = $contentType;
                    this.$this_toRequestBody = $receiver;
                    this.$inputStream = $inputStream;
                }

                public MediaType contentType() {
                    return this.$contentType;
                }

                public long length() {
                    return this.$this_toRequestBody.getStatSize();
                }

                public void writeTo(BufferedSink sink) {
                    Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
                    sink.writeAll(Okio.source((InputStream)((InputStream)this.$inputStream)));
                }
            };
        }

        public static /* synthetic */ RequestBody toRequestBody$default(Companion companion, ParcelFileDescriptor parcelFileDescriptor, MediaType mediaType, int n, Object object) {
            if ((n & 1) != 0) {
                mediaType = null;
            }
            return companion.toRequestBody(parcelFileDescriptor, mediaType);
        }

        @NotNull
        public final RequestBody toRequestBody(@NotNull String $this$toRequestBody, @Nullable MediaType contentType) {
            Intrinsics.checkNotNullParameter((Object)$this$toRequestBody, (String)"<this>");
            Charset charset = Charsets.UTF_8;
            MediaType finalContentType = contentType;
            if (contentType != null) {
                Charset resolvedCharset = MediaType.charset$default(contentType, null, 1, null);
                if (resolvedCharset == null) {
                    charset = Charsets.UTF_8;
                    finalContentType = MediaType.Companion.toMediaTypeOrNull(contentType + "; charset=utf-8");
                } else {
                    charset = resolvedCharset;
                }
            }
            byte[] byArray = $this$toRequestBody.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            byte[] bytes = byArray;
            return this.toRequestBody(bytes, finalContentType, 0, bytes.length);
        }

        public static /* synthetic */ RequestBody toRequestBody$default(Companion companion, String string, MediaType mediaType, int n, Object object) {
            if ((n & 1) != 0) {
                mediaType = null;
            }
            return companion.toRequestBody(string, mediaType);
        }

        @NotNull
        public final RequestBody toRequestBody(@NotNull ByteString $this$toRequestBody, @Nullable MediaType contentType) {
            Intrinsics.checkNotNullParameter((Object)$this$toRequestBody, (String)"<this>");
            return new RequestBody(contentType, $this$toRequestBody){
                final /* synthetic */ MediaType $contentType;
                final /* synthetic */ ByteString $this_toRequestBody;
                {
                    this.$contentType = $contentType;
                    this.$this_toRequestBody = $receiver;
                }

                public MediaType contentType() {
                    return this.$contentType;
                }

                public long length() {
                    return this.$this_toRequestBody.size();
                }

                public void writeTo(BufferedSink sink) {
                    Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
                    sink.write(this.$this_toRequestBody);
                }
            };
        }

        public static /* synthetic */ RequestBody toRequestBody$default(Companion companion, ByteString byteString, MediaType mediaType, int n, Object object) {
            if ((n & 1) != 0) {
                mediaType = null;
            }
            return companion.toRequestBody(byteString, mediaType);
        }

        @NotNull
        public final RequestBody toRequestBody(@NotNull byte[] $this$toRequestBody, @Nullable MediaType contentType, int offset, int byteCount) {
            Intrinsics.checkNotNullParameter((Object)$this$toRequestBody, (String)"<this>");
            UtilKt.checkOffsetAndCount($this$toRequestBody.length, offset, byteCount);
            return new RequestBody(contentType, byteCount, $this$toRequestBody, offset){
                final /* synthetic */ MediaType $contentType;
                final /* synthetic */ int $byteCount;
                final /* synthetic */ byte[] $this_toRequestBody;
                final /* synthetic */ int $offset;
                {
                    this.$contentType = $contentType;
                    this.$byteCount = $byteCount;
                    this.$this_toRequestBody = $receiver;
                    this.$offset = $offset;
                }

                public MediaType contentType() {
                    return this.$contentType;
                }

                public long length() {
                    return this.$byteCount;
                }

                public void writeTo(BufferedSink sink) {
                    Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
                    sink.write(this.$this_toRequestBody, this.$offset, this.$byteCount);
                }
            };
        }

        public static /* synthetic */ RequestBody toRequestBody$default(Companion companion, byte[] byArray, MediaType mediaType, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                mediaType = null;
            }
            if ((n3 & 2) != 0) {
                n = 0;
            }
            if ((n3 & 4) != 0) {
                n2 = byArray.length;
            }
            return companion.toRequestBody(byArray, mediaType, n, n2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

