/*
 * Decompiled with CFR 0.152.
 */
package okcronet.http;

import androidx.annotation.RequiresApi;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.internal.ProgressionUtilKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.text.StringsKt;
import okcronet.http.DatesKt;
import okcronet.http.UtilKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\"\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010(\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0003\u0018\u0000 (2\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00020\u0001:\u0002'(B\u0017\b\u0002\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0013\u0010\t\u001a\u0004\u0018\u00010\u00032\u0006\u0010\n\u001a\u00020\u0003H\u0086\u0002J\u0010\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\n\u001a\u00020\u0003J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\n\u001a\u00020\u0003H\u0007J\u000e\u0010\n\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0010J\u000e\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0010J\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00030\u0016J\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00030\u00182\u0006\u0010\n\u001a\u00020\u0003J\u0006\u0010\u0019\u001a\u00020\u001aJ\u001b\u0010\u001b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00020\u001cH\u0096\u0002J\u0006\u0010\u001d\u001a\u00020\u001eJ\u0013\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0096\u0002J\b\u0010#\u001a\u00020\u0010H\u0016J\b\u0010$\u001a\u00020\u0003H\u0016J\u0018\u0010%\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00180&R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006)"}, d2={"Lokcronet/http/Headers;", "", "Lkotlin/Pair;", "", "namesAndValues", "", "<init>", "([Ljava/lang/String;)V", "[Ljava/lang/String;", "get", "name", "getDate", "Ljava/util/Date;", "getInstant", "Ljava/time/Instant;", "size", "", "getSize", "()I", "index", "value", "names", "", "values", "", "byteCount", "", "iterator", "", "newBuilder", "Lokcronet/http/Headers$Builder;", "equals", "", "other", "", "hashCode", "toString", "toMultimap", "", "Builder", "Companion", "okcronet_release"})
public final class Headers
implements Iterable<Pair<? extends String, ? extends String>>,
KMappedMarker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String[] namesAndValues;

    private Headers(String[] namesAndValues) {
        this.namesAndValues = namesAndValues;
    }

    @Nullable
    public final String get(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return Headers.Companion.get(this.namesAndValues, name);
    }

    @Nullable
    public final Date getDate(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String string = this.get(name);
        return string != null ? DatesKt.toHttpDateOrNull(string) : null;
    }

    @RequiresApi(value=26)
    @Nullable
    public final Instant getInstant(@NotNull String name) {
        Date value;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Date date = value = this.getDate(name);
        return date != null ? date.toInstant() : null;
    }

    public final int getSize() {
        return this.namesAndValues.length / 2;
    }

    @NotNull
    public final String name(int index) {
        return this.namesAndValues[index * 2];
    }

    @NotNull
    public final String value(int index) {
        return this.namesAndValues[index * 2 + 1];
    }

    @NotNull
    public final Set<String> names() {
        TreeSet<String> result = new TreeSet<String>(StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE));
        int n = this.getSize();
        for (int i = 0; i < n; ++i) {
            result.add(this.name(i));
        }
        Set<String> set = Collections.unmodifiableSet((Set)result);
        Intrinsics.checkNotNullExpressionValue(set, (String)"unmodifiableSet(...)");
        return set;
    }

    @NotNull
    public final List<String> values(@NotNull String name) {
        List list;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        List result = null;
        int n = this.getSize();
        for (int i = 0; i < n; ++i) {
            if (!StringsKt.equals((String)name, (String)this.name(i), (boolean)true)) continue;
            if (result == null) {
                result = new ArrayList(2);
            }
            result.add(this.value(i));
        }
        if (result != null) {
            List list2 = Collections.unmodifiableList(result);
            Intrinsics.checkNotNull(list2);
            list = list2;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    public final long byteCount() {
        long result = this.namesAndValues.length * 2;
        for (String element : this.namesAndValues) {
            result += (long)element.length();
        }
        return result;
    }

    @Override
    @NotNull
    public Iterator<Pair<String, String>> iterator() {
        int n = 0;
        int n2 = this.getSize();
        Object[] objectArray = new Pair[n2];
        while (n < n2) {
            int n3 = n++;
            objectArray[n3] = TuplesKt.to((Object)this.name(n3), (Object)this.value(n3));
        }
        return ArrayIteratorKt.iterator((Object[])objectArray);
    }

    @NotNull
    public final Builder newBuilder() {
        Builder result = new Builder();
        CollectionsKt.addAll((Collection)result.getNamesAndValues$okcronet_release(), (Object[])this.namesAndValues);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof Headers && Arrays.equals(this.namesAndValues, ((Headers)other).namesAndValues);
    }

    public int hashCode() {
        return Arrays.hashCode(this.namesAndValues);
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        int n = this.getSize();
        for (int i = 0; i < n; ++i) {
            String name = this.name(i);
            String value = this.value(i);
            $this$toString_u24lambda_u240.append(name);
            $this$toString_u24lambda_u240.append(": ");
            $this$toString_u24lambda_u240.append(UtilKt.isSensitiveHeader(name) ? "\u2588\u2588" : value);
            $this$toString_u24lambda_u240.append("\n");
        }
        return stringBuilder.toString();
    }

    @NotNull
    public final Map<String, List<String>> toMultimap() {
        TreeMap result = new TreeMap(StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE));
        int n = this.getSize();
        for (int i = 0; i < n; ++i) {
            String name;
            String string = this.name(i);
            Locale locale = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
            Intrinsics.checkNotNullExpressionValue((Object)string.toLowerCase(locale), (String)"toLowerCase(...)");
            List values = (List)result.get(name);
            if (values == null) {
                values = new ArrayList(2);
                ((Map)result).put(name, values);
            }
            values.add(this.value(i));
        }
        return result;
    }

    @JvmStatic
    @NotNull
    public static final Headers headersOf(String ... namesAndValues) {
        return Companion.headersOf(namesAndValues);
    }

    @JvmStatic
    @NotNull
    public static final Headers toHeaders(@NotNull Map<String, String> $this$toHeaders) {
        return Companion.toHeaders($this$toHeaders);
    }

    public /* synthetic */ Headers(String[] namesAndValues, DefaultConstructorMarker $constructor_marker) {
        this(namesAndValues);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\t\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u000bJ\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u0006J\u0016\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0006J\u0016\u0010\u000f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0006J\u000e\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0012J\u0016\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0013J\u0018\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0014H\u0007J\u0019\u0010\u0015\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0013H\u0086\u0002J\u0019\u0010\u0015\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0014H\u0087\u0002J\u0018\u0010\t\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0006H\u0002J\u000e\u0010\u0016\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u0006J\u0019\u0010\u0015\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0006H\u0086\u0002J\u0013\u0010\u0017\u001a\u0004\u0018\u00010\u00062\u0006\u0010\r\u001a\u00020\u0006H\u0086\u0002J\u0006\u0010\u0018\u001a\u00020\u0012R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0019"}, d2={"Lokcronet/http/Headers$Builder;", "", "<init>", "()V", "namesAndValues", "", "", "getNamesAndValues$okcronet_release", "()Ljava/util/List;", "addLenient", "line", "addLenient$okcronet_release", "add", "name", "value", "addUnsafeNonAscii", "addAll", "headers", "Lokcronet/http/Headers;", "Ljava/util/Date;", "Ljava/time/Instant;", "set", "removeAll", "get", "build", "okcronet_release"})
    @SourceDebugExtension(value={"SMAP\nHeaders.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Headers.kt\nokcronet/http/Headers$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,420:1\n1#2:421\n37#3:422\n36#3,3:423\n*S KotlinDebug\n*F\n+ 1 Headers.kt\nokcronet/http/Headers$Builder\n*L\n341#1:422\n341#1:423,3\n*E\n"})
    public static final class Builder {
        @NotNull
        private final List<String> namesAndValues = new ArrayList(20);

        @NotNull
        public final List<String> getNamesAndValues$okcronet_release() {
            return this.namesAndValues;
        }

        @NotNull
        public final Builder addLenient$okcronet_release(@NotNull String line) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)line, (String)"line");
            Builder $this$addLenient_u24lambda_u240 = builder = this;
            boolean bl = false;
            int index = StringsKt.indexOf$default((CharSequence)line, (char)':', (int)1, (boolean)false, (int)4, null);
            if (index != -1) {
                String string = line.substring(0, index);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                String string2 = line.substring(index + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                v2 = $this$addLenient_u24lambda_u240.addLenient(string, string2);
            } else if (line.charAt(0) == ':') {
                String string = line.substring(1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                v2 = $this$addLenient_u24lambda_u240.addLenient("", string);
            } else {
                v2 = $this$addLenient_u24lambda_u240.addLenient("", line);
            }
            return builder;
        }

        @NotNull
        public final Builder add(@NotNull String line) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)line, (String)"line");
            Builder $this$add_u24lambda_u242 = builder = this;
            boolean bl = false;
            int index = StringsKt.indexOf$default((CharSequence)line, (char)':', (int)0, (boolean)false, (int)6, null);
            if (!(index != -1)) {
                boolean bl2 = false;
                String string = "Unexpected header: " + line;
                throw new IllegalArgumentException(string.toString());
            }
            String string = line.substring(0, index);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String string2 = ((Object)StringsKt.trim((CharSequence)string)).toString();
            String string3 = line.substring(index + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            $this$add_u24lambda_u242.add(string2, string3);
            return builder;
        }

        @NotNull
        public final Builder add(@NotNull String name, @NotNull String value) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Builder $this$add_u24lambda_u243 = builder = this;
            boolean bl = false;
            Companion.checkName(name);
            Companion.checkValue(value, name);
            $this$add_u24lambda_u243.addLenient(name, value);
            return builder;
        }

        @NotNull
        public final Builder addUnsafeNonAscii(@NotNull String name, @NotNull String value) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Builder $this$addUnsafeNonAscii_u24lambda_u244 = builder = this;
            boolean bl = false;
            Companion.checkName(name);
            $this$addUnsafeNonAscii_u24lambda_u244.addLenient(name, value);
            return builder;
        }

        @NotNull
        public final Builder addAll(@NotNull Headers headers) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
            Builder $this$addAll_u24lambda_u245 = builder = this;
            boolean bl = false;
            int n = headers.getSize();
            for (int i = 0; i < n; ++i) {
                $this$addAll_u24lambda_u245.addLenient(headers.name(i), headers.value(i));
            }
            return builder;
        }

        @NotNull
        public final Builder add(@NotNull String name, @NotNull Date value) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Builder $this$add_u24lambda_u246 = builder = this;
            boolean bl = false;
            $this$add_u24lambda_u246.add(name, DatesKt.toHttpDateString(value));
            return builder;
        }

        @RequiresApi(value=26)
        @NotNull
        public final Builder add(@NotNull String name, @NotNull Instant value) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Builder $this$add_u24lambda_u247 = builder = this;
            boolean bl = false;
            $this$add_u24lambda_u247.add(name, new Date(value.toEpochMilli()));
            return builder;
        }

        @NotNull
        public final Builder set(@NotNull String name, @NotNull Date value) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Builder $this$set_u24lambda_u248 = builder = this;
            boolean bl = false;
            $this$set_u24lambda_u248.set(name, DatesKt.toHttpDateString(value));
            return builder;
        }

        @RequiresApi(value=26)
        @NotNull
        public final Builder set(@NotNull String name, @NotNull Instant value) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Builder $this$set_u24lambda_u249 = this;
            boolean bl = false;
            return $this$set_u24lambda_u249.set(name, new Date(value.toEpochMilli()));
        }

        private final Builder addLenient(String name, String value) {
            Builder builder;
            Builder $this$addLenient_u24lambda_u2410 = builder = this;
            boolean bl = false;
            $this$addLenient_u24lambda_u2410.namesAndValues.add(name);
            $this$addLenient_u24lambda_u2410.namesAndValues.add(((Object)StringsKt.trim((CharSequence)value)).toString());
            return builder;
        }

        @NotNull
        public final Builder removeAll(@NotNull String name) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Builder $this$removeAll_u24lambda_u2411 = builder = this;
            boolean bl = false;
            for (int i = 0; i < $this$removeAll_u24lambda_u2411.namesAndValues.size(); i += 2) {
                if (!StringsKt.equals((String)name, (String)$this$removeAll_u24lambda_u2411.namesAndValues.get(i), (boolean)true)) continue;
                $this$removeAll_u24lambda_u2411.namesAndValues.remove(i);
                $this$removeAll_u24lambda_u2411.namesAndValues.remove(i);
                i -= 2;
            }
            return builder;
        }

        @NotNull
        public final Builder set(@NotNull String name, @NotNull String value) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Builder $this$set_u24lambda_u2412 = builder = this;
            boolean bl = false;
            Companion.checkName(name);
            Companion.checkValue(value, name);
            $this$set_u24lambda_u2412.removeAll(name);
            $this$set_u24lambda_u2412.addLenient(name, value);
            return builder;
        }

        @Nullable
        public final String get(@NotNull String name) {
            int n;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            int i = n = this.namesAndValues.size() - 2;
            int n2 = ProgressionUtilKt.getProgressionLastElement((int)n, (int)0, (int)-2);
            if (n2 <= i) {
                while (true) {
                    if (StringsKt.equals((String)name, (String)this.namesAndValues.get(i), (boolean)true)) {
                        return this.namesAndValues.get(i + 1);
                    }
                    if (i == n2) break;
                    i -= 2;
                }
            }
            return null;
        }

        @NotNull
        public final Headers build() {
            Collection $this$toTypedArray$iv = this.namesAndValues;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            return new Headers(thisCollection$iv.toArray(new String[0]), null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J%\u0010\u0004\u001a\u0004\u0018\u00010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0002\u00a2\u0006\u0002\u0010\tJ!\u0010\n\u001a\u00020\u000b2\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0007\"\u00020\u0005H\u0007\u00a2\u0006\u0002\u0010\fJ\u0018\u0010\r\u001a\u00020\u000b*\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u000eH\u0007J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\u0005H\u0002J\u0018\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005H\u0002\u00a8\u0006\u0013"}, d2={"Lokcronet/http/Headers$Companion;", "", "<init>", "()V", "get", "", "namesAndValues", "", "name", "([Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;", "headersOf", "Lokcronet/http/Headers;", "([Ljava/lang/String;)Lokcronet/http/Headers;", "toHeaders", "", "checkName", "", "checkValue", "value", "okcronet_release"})
    @SourceDebugExtension(value={"SMAP\nHeaders.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Headers.kt\nokcronet/http/Headers$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,420:1\n1#2:421\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final String get(String[] namesAndValues, String name) {
            int n;
            int i = n = namesAndValues.length - 2;
            int n2 = ProgressionUtilKt.getProgressionLastElement((int)n, (int)0, (int)-2);
            if (n2 <= i) {
                while (true) {
                    if (StringsKt.equals((String)name, (String)namesAndValues[i], (boolean)true)) {
                        return namesAndValues[i + 1];
                    }
                    if (i == n2) break;
                    i -= 2;
                }
            }
            return null;
        }

        @JvmStatic
        @NotNull
        public final Headers headersOf(String ... namesAndValues) {
            Intrinsics.checkNotNullParameter((Object)namesAndValues, (String)"namesAndValues");
            if (!(namesAndValues.length % 2 == 0)) {
                boolean $i$a$-require-Headers$Companion$headersOf$22 = false;
                String $i$a$-require-Headers$Companion$headersOf$22 = "Expected alternating header names and values";
                throw new IllegalArgumentException($i$a$-require-Headers$Companion$headersOf$22.toString());
            }
            String[] cloneNamesAndValues = (String[])namesAndValues.clone();
            int n = cloneNamesAndValues.length;
            for (int i = 0; i < n; ++i) {
                cloneNamesAndValues[i] = ((Object)StringsKt.trim((CharSequence)cloneNamesAndValues[i])).toString();
            }
            int i = 0;
            int n2 = cloneNamesAndValues.length + -1;
            int n3 = ProgressionUtilKt.getProgressionLastElement((int)0, (int)n2, (int)2);
            if (i <= n3) {
                while (true) {
                    String name = cloneNamesAndValues[i];
                    String value = cloneNamesAndValues[i + 1];
                    this.checkName(name);
                    this.checkValue(value, name);
                    if (i == n3) break;
                    i += 2;
                }
            }
            return new Headers(cloneNamesAndValues, null);
        }

        @JvmStatic
        @NotNull
        public final Headers toHeaders(@NotNull Map<String, String> $this$toHeaders) {
            Intrinsics.checkNotNullParameter($this$toHeaders, (String)"<this>");
            String[] namesAndValues = new String[$this$toHeaders.size() * 2];
            int i = 0;
            for (Map.Entry<String, String> entry : $this$toHeaders.entrySet()) {
                String k = entry.getKey();
                String v = entry.getValue();
                String name = ((Object)StringsKt.trim((CharSequence)k)).toString();
                String value = ((Object)StringsKt.trim((CharSequence)v)).toString();
                this.checkName(name);
                this.checkValue(value, name);
                namesAndValues[i] = name;
                namesAndValues[i + 1] = value;
                i += 2;
            }
            return new Headers(namesAndValues, null);
        }

        private final void checkName(String name) {
            if (!(((CharSequence)name).length() > 0)) {
                boolean bl = false;
                String string = "name is empty";
                throw new IllegalArgumentException(string.toString());
            }
            int n = ((CharSequence)name).length();
            for (int i = 0; i < n; ++i) {
                char c = name.charAt(i);
                if ('!' <= c ? c < '\u007f' : false) continue;
                boolean bl = false;
                Object[] objectArray = new Object[]{(int)c, i, name};
                String string = UtilKt.format("Unexpected char %#04x at %d in header name: %s", objectArray);
                throw new IllegalArgumentException(string.toString());
            }
        }

        /*
         * Unable to fully structure code
         */
        private final void checkValue(String value, String name) {
            var4_4 = ((CharSequence)value).length();
            for (i = 0; i < var4_4; ++i) {
                c = value.charAt(i);
                if (c == '\t') ** GOTO lbl-1000
                v0 = ' ' <= c ? c < '\u007f' : false;
                if (v0) lbl-1000:
                // 2 sources

                {
                    v1 = true;
                } else {
                    v1 = false;
                }
                if (v1) continue;
                $i$a$-require-Headers$Companion$checkValue$1 = false;
                var7_8 = new Object[]{(int)c, i, name};
                var6_7 = UtilKt.format("Unexpected char %#04x at %d in %s value", var7_8) + (String)(UtilKt.isSensitiveHeader(name) != false ? "" : ": " + value);
                throw new IllegalArgumentException(var6_7.toString());
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

