/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.align;

import jebl.evolution.align.AlignRepeat;
import jebl.evolution.align.Output;
import jebl.evolution.align.Traceback;
import jebl.evolution.align.TracebackAffine;
import jebl.evolution.align.scores.Scores;

abstract class AlignRepeatAffine
extends AlignRepeat {
    float[][][] F = null;
    TracebackAffine[][][] B;
    float maxScore;
    float e;

    public AlignRepeatAffine(Scores sub, float d, float e, int T) {
        super(sub, d, T);
        this.setGapExtend(e);
    }

    @Override
    public abstract void doAlignment(String var1, String var2);

    @Override
    public void prepareAlignment(String sq1, String sq2) {
        if (this.F == null) {
            this.n = sq1.length();
            this.m = sq2.length();
            this.seq1 = this.strip(sq1);
            this.seq2 = this.strip(sq2);
            this.F = new float[3][this.n + 1][this.m + 1];
            this.B = new TracebackAffine[3][this.n + 1][this.m + 1];
            for (int k = 0; k < 3; ++k) {
                for (int i = 0; i < this.n + 1; ++i) {
                    for (int j = 0; j < this.m + 1; ++j) {
                        this.B[k][i][j] = new TracebackAffine(0, 0, 0);
                    }
                }
            }
        } else if (this.seq1.length() <= this.n && this.seq2.length() <= this.m) {
            this.n = sq1.length();
            this.m = sq2.length();
            this.seq1 = this.strip(sq1);
            this.seq2 = this.strip(sq2);
        } else {
            this.n = sq1.length();
            this.m = sq2.length();
            this.seq1 = this.strip(sq1);
            this.seq2 = this.strip(sq2);
            this.F = new float[3][this.n + 1][this.m + 1];
            this.B = new TracebackAffine[3][this.n + 1][this.m + 1];
            for (int k = 0; k < 3; ++k) {
                for (int i = 0; i < this.n + 1; ++i) {
                    for (int j = 0; j < this.m + 1; ++j) {
                        this.B[k][i][j] = new TracebackAffine(0, 0, 0);
                    }
                }
            }
        }
    }

    public void setGapExtend(float e) {
        this.e = e;
    }

    @Override
    public Traceback next(Traceback tb) {
        TracebackAffine tb3 = (TracebackAffine)tb;
        if (tb3.i + tb3.j + this.B[tb3.k][tb3.i][tb3.j].i + this.B[tb3.k][tb3.i][tb3.j].j == 0) {
            return null;
        }
        return this.B[tb3.k][tb3.i][tb3.j];
    }

    @Override
    public float getScore() {
        return this.F[((TracebackAffine)this.B0).k][this.B0.i][this.B0.j];
    }

    @Override
    public void printf(Output out) {
        for (int k = 0; k < 3; ++k) {
            out.println("F[" + k + "]:");
            for (int j = 0; j <= this.m; ++j) {
                for (int i = 0; i < this.F[k].length; ++i) {
                    out.print(AlignRepeatAffine.padLeft(this.formatScore(this.F[k][i][j]), 5));
                }
                out.println();
            }
        }
    }
}

