/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.align;

import jebl.evolution.align.AlignSimple;
import jebl.evolution.align.TracebackSimple;
import jebl.evolution.align.scores.Scores;

public class OverlapAlign
extends AlignSimple {
    public OverlapAlign(Scores sub, float d) {
        super(sub, d);
    }

    @Override
    public void doAlignment(String sq1, String sq2) {
        super.prepareAlignment(sq1, sq2);
        int n = this.n;
        int m = this.m;
        float[][] score = this.sub.score;
        for (int i = 1; i <= n; ++i) {
            for (int j = 1; j <= m; ++j) {
                float val;
                float s = score[this.seq1.charAt(i - 1)][this.seq2.charAt(j - 1)];
                this.F[i][j] = val = OverlapAlign.max(this.F[i - 1][j - 1] + s, this.F[i - 1][j] - this.d, this.F[i][j - 1] - this.d);
                if (val == this.F[i - 1][j - 1] + s) {
                    this.B[i][j].setTraceback(i - 1, j - 1);
                    continue;
                }
                if (val == this.F[i - 1][j] - this.d) {
                    this.B[i][j].setTraceback(i - 1, j);
                    continue;
                }
                if (val == this.F[i][j - 1] - this.d) {
                    this.B[i][j].setTraceback(i, j - 1);
                    continue;
                }
                throw new Error("RM 1");
            }
        }
        int maxi = -1;
        int maxj = -1;
        float maxval = Float.NEGATIVE_INFINITY;
        for (int i = 0; i <= n; ++i) {
            if (!(maxval < this.F[i][m])) continue;
            maxi = i;
            maxval = this.F[i][m];
        }
        for (int j = 0; j <= m; ++j) {
            if (!(maxval < this.F[n][j])) continue;
            maxj = j;
            maxval = this.F[n][j];
        }
        this.B0 = maxj != -1 ? new TracebackSimple(n, maxj) : new TracebackSimple(maxi, m);
    }
}

