/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.characters;

import java.util.HashSet;
import java.util.Set;
import jebl.evolution.characters.Character;
import jebl.evolution.characters.CharacterType;
import jebl.evolution.taxa.Taxon;

public class ContinuousCharacter
implements Character {
    private String desc;
    private String name;
    private CharacterType charType;
    private Set<Taxon> taxa;

    public ContinuousCharacter(String name, String desc) {
        this.name = name;
        this.charType = CharacterType.CONTINUOUS;
        this.desc = desc;
        this.taxa = new HashSet<Taxon>();
    }

    public ContinuousCharacter(String name, String desc, Set<Taxon> taxa) {
        this.name = name;
        this.charType = CharacterType.CONTINUOUS;
        this.desc = desc;
        this.taxa = taxa;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setDesc(String desc) {
        this.desc = desc;
    }

    @Override
    public String getDesc() {
        return this.desc;
    }

    @Override
    public CharacterType getType() {
        return this.charType;
    }

    public void addTaxa(Set<Taxon> taxa) {
        this.taxa = taxa;
    }

    @Override
    public void addTaxon(Taxon taxon) {
        this.taxa.add(taxon);
    }

    @Override
    public Object getValue(Taxon taxon) {
        double value = (Double)taxon.getAttribute(this.name);
        return value;
    }

    public double getSE(Taxon taxon) {
        double value = 0.0;
        if (taxon.getAttribute(this.name + "SE") != null) {
            value = (Double)taxon.getAttribute(this.name + "SE");
        }
        return value;
    }

    @Override
    public Set<Taxon> getTaxa() {
        return this.taxa;
    }
}

