/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.coalescent;

import jebl.evolution.coalescent.ExponentialGrowth;

public class CataclysmicDemographic
extends ExponentialGrowth {
    private double d;
    private double catTime;

    public CataclysmicDemographic() {
    }

    public CataclysmicDemographic(double N0, double r, double d, double t) {
        super(N0, r);
        this.d = d;
        this.catTime = t;
    }

    public final double getDeclineRate() {
        return this.d;
    }

    public void setDeclineRate(double d) {
        if (d <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.d = d;
    }

    public final double getCataclysmTime() {
        return this.catTime;
    }

    public final void setCataclysmTime(double t) {
        if (t <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.catTime = t;
    }

    public final void setSpikeFactor(double f) {
        this.setDeclineRate(Math.log(f) / this.catTime);
    }

    @Override
    public double getDemographic(double t) {
        double d = this.getDeclineRate();
        if (t < this.catTime) {
            return this.getN0() * Math.exp(t * d);
        }
        double spikeHeight = this.getN0() * Math.exp(this.catTime * d);
        t -= this.catTime;
        double r = this.getGrowthRate();
        if (r == 0.0) {
            return spikeHeight;
        }
        return spikeHeight * Math.exp(-t * r);
    }

    @Override
    public double getIntensity(double t) {
        double d = this.getDeclineRate();
        double r = this.getGrowthRate();
        if (t < this.catTime) {
            return (Math.exp(t * -d) - 1.0) / this.getN0() / -d;
        }
        double intensityUpToSpike = (Math.exp(this.catTime * -d) - 1.0) / this.getN0() / -d;
        double spikeHeight = this.getN0() * Math.exp(this.catTime * d);
        t -= this.catTime;
        if (r == 0.0) {
            return t / spikeHeight + intensityUpToSpike;
        }
        return (Math.exp(t * r) - 1.0) / spikeHeight / r + intensityUpToSpike;
    }

    @Override
    public double getInverseIntensity(double x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasIntegral() {
        return false;
    }
}

