/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.coalescent;

import jebl.evolution.coalescent.ExponentialGrowth;

public class ConstExponential
extends ExponentialGrowth {
    private double N1 = 0.0;

    public ConstExponential() {
    }

    public ConstExponential(double N0, double r, double N1) {
        super(N0, r);
        this.N1 = N1;
    }

    public double getN1() {
        return this.N1;
    }

    public void setN1(double N1) {
        this.N1 = N1;
    }

    public void setProportion(double p) {
        this.N1 = this.getN0() * p;
    }

    @Override
    public double getDemographic(double t) {
        double N0 = this.getN0();
        double N1 = this.getN1();
        double r = this.getGrowthRate();
        double time = Math.log(N0 / N1) / r;
        if (t < time) {
            return N0 * Math.exp(-r * t);
        }
        return N1;
    }

    @Override
    public double getIntensity(double t) {
        double r = this.getGrowthRate();
        double time = Math.log(this.getN0() / this.getN1()) / r;
        if (r == 0.0) {
            return t / this.getN0();
        }
        if (t < time) {
            return super.getIntensity(t);
        }
        return super.getIntensity(time) + (t - time) / this.getN1();
    }

    @Override
    public double getInverseIntensity(double x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasIntegral() {
        return false;
    }

    @Override
    public double getIntegral(double start, double finish) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getArgumentCount() {
        return 3;
    }

    @Override
    public String getArgumentName(int n) {
        switch (n) {
            case 0: {
                return "N0";
            }
            case 1: {
                return "r";
            }
            case 2: {
                return "N1";
            }
        }
        throw new IllegalArgumentException("Argument " + n + " does not exist");
    }

    @Override
    public double getArgument(int n) {
        switch (n) {
            case 0: {
                return this.getN0();
            }
            case 1: {
                return this.getGrowthRate();
            }
            case 2: {
                return this.getN1();
            }
        }
        throw new IllegalArgumentException("Argument " + n + " does not exist");
    }

    @Override
    public void setArgument(int n, double value) {
        switch (n) {
            case 0: {
                this.setN0(value);
                break;
            }
            case 1: {
                this.setGrowthRate(value);
                break;
            }
            case 2: {
                this.setN1(value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Argument " + n + " does not exist");
            }
        }
    }

    @Override
    public double getLowerBound(int n) {
        return 0.0;
    }

    @Override
    public double getUpperBound(int n) {
        return Double.POSITIVE_INFINITY;
    }
}

