/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.coalescent;

import jebl.evolution.coalescent.LogisticGrowth;

public class ConstLogistic
extends LogisticGrowth {
    private double N1 = 0.0;

    public ConstLogistic() {
    }

    public ConstLogistic(double N0, double r, double c, double N1) {
        super(N0, r, c);
        this.N1 = N1;
    }

    public double getN1() {
        return this.N1;
    }

    public void setN1(double N1) {
        this.N1 = N1;
    }

    @Override
    public double getDemographic(double t) {
        double nZero = this.getN0();
        double nOne = this.getN1();
        double r = this.getGrowthRate();
        double c = this.getShape();
        double common = Math.exp(-r * t);
        return nOne + (nZero - nOne) * (1.0 + c) * common / (c + common);
    }

    @Override
    public double getIntensity(double t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getInverseIntensity(double x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasIntegral() {
        return false;
    }

    @Override
    public double getIntegral(double start, double finish) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getArgumentCount() {
        return 4;
    }

    @Override
    public String getArgumentName(int n) {
        switch (n) {
            case 0: {
                return "N0";
            }
            case 1: {
                return "r";
            }
            case 2: {
                return "c";
            }
            case 3: {
                return "N1";
            }
        }
        throw new IllegalArgumentException("Argument " + n + " does not exist");
    }

    @Override
    public double getArgument(int n) {
        switch (n) {
            case 0: {
                return this.getN0();
            }
            case 1: {
                return this.getGrowthRate();
            }
            case 2: {
                return this.getShape();
            }
            case 3: {
                return this.getN1();
            }
        }
        throw new IllegalArgumentException("Argument " + n + " does not exist");
    }

    @Override
    public void setArgument(int n, double value) {
        switch (n) {
            case 0: {
                this.setN0(value);
                break;
            }
            case 1: {
                this.setGrowthRate(value);
                break;
            }
            case 2: {
                this.setShape(value);
                break;
            }
            case 3: {
                this.setN1(value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Argument " + n + " does not exist");
            }
        }
    }

    @Override
    public double getLowerBound(int n) {
        return 0.0;
    }

    @Override
    public double getUpperBound(int n) {
        return Double.POSITIVE_INFINITY;
    }
}

