/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.coalescent;

import jebl.evolution.coalescent.DemographicFunction;

public class EmpiricalDemographicFunction
implements DemographicFunction {
    private final double[] populationSizes;
    private final double[] times;
    private final boolean stepwise;

    public EmpiricalDemographicFunction(double[] populationSizes, double[] times, boolean stepwise) {
        this.populationSizes = populationSizes;
        this.times = times;
        this.stepwise = stepwise;
    }

    @Override
    public double getDemographic(double t) {
        assert (t >= 0.0);
        if (t > this.times[this.times.length - 1]) {
            return this.populationSizes[this.populationSizes.length - 1];
        }
        if (this.stepwise) {
            for (int i = 0; i < this.times.length; ++i) {
                if (!(this.times[i] >= t)) continue;
                return this.populationSizes[i];
            }
        } else {
            for (int i = 0; i < this.times.length; ++i) {
                if (this.times[i] == t) {
                    return this.populationSizes[i];
                }
                if (!(this.times[i] > t)) continue;
                double proportion = (t - this.times[i - 1]) / (this.times[i] - this.times[i - 1]);
                double popSize = this.populationSizes[i - 1] + proportion * (this.populationSizes[i] - this.populationSizes[i - 1]);
                return popSize;
            }
        }
        throw new RuntimeException("Error in jebl.evolution.treesimulation.EmpiricalDemographicFunction.getDemographic: went off the end of the array");
    }

    @Override
    public double getIntensity(double t) {
        throw new UnsupportedOperationException("getIntensity is not implemented in jebl.evolution.treesimulation.EmpiricalDemographicFunction");
    }

    @Override
    public double getInverseIntensity(double x) {
        throw new UnsupportedOperationException("getInverseIntensity is not implemented in jebl.evolution.treesimulation.EmpiricalDemographicFunction");
    }

    @Override
    public boolean hasIntegral() {
        return false;
    }

    @Override
    public double getIntegral(double start, double finish) {
        return 0.0;
    }

    @Override
    public int getArgumentCount() {
        return 0;
    }

    @Override
    public String getArgumentName(int n) {
        return null;
    }

    @Override
    public double getArgument(int n) {
        return 0.0;
    }

    @Override
    public void setArgument(int n, double value) {
    }

    @Override
    public double getLowerBound(int n) {
        return 0.0;
    }

    @Override
    public double getUpperBound(int n) {
        return 0.0;
    }
}

