/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.distances;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jebl.evolution.distances.CannotBuildDistanceMatrixException;
import jebl.evolution.distances.DistanceMatrix;
import jebl.evolution.taxa.Taxon;
import jebl.util.ProgressListener;

public class BasicDistanceMatrix
implements DistanceMatrix {
    private final List<Taxon> taxa;
    private final double[][] distances;

    public BasicDistanceMatrix(Collection<Taxon> taxa, double[][] distances) {
        if (distances == null || distances.length == 0) {
            throw new IllegalArgumentException("Source distance matrix is null or empty");
        }
        if (distances.length != distances[0].length) {
            throw new IllegalArgumentException("Source distance matrix is not square");
        }
        if (distances.length != taxa.size()) {
            throw new IllegalArgumentException("Source distance matrix dimensions do not match the number of taxa");
        }
        this.taxa = new ArrayList<Taxon>(taxa);
        this.distances = distances;
    }

    @Override
    public int getSize() {
        return this.distances.length;
    }

    @Override
    public List<Taxon> getTaxa() {
        return this.taxa;
    }

    @Override
    public double getDistance(int row, int column) {
        return this.distances[row][column];
    }

    @Override
    public double getDistance(Taxon taxonRow, Taxon taxonColumn) {
        int row = this.taxa.indexOf(taxonRow);
        if (row == -1) {
            throw new IllegalArgumentException("The row taxon, " + taxonRow.getName() + " is not found in this matrix");
        }
        int column = this.taxa.indexOf(taxonColumn);
        if (column == -1) {
            throw new IllegalArgumentException("The column taxon, " + taxonColumn.getName() + " is not found in this matrix");
        }
        return this.getDistance(row, column);
    }

    @Override
    public DistanceMatrix getSubmatrix(Collection<Taxon> taxonSubset) {
        double[][] newDistances = new double[taxonSubset.size()][taxonSubset.size()];
        int i = 0;
        for (Taxon taxonRow : taxonSubset) {
            int row = this.taxa.indexOf(taxonRow);
            if (row == -1) {
                throw new IllegalArgumentException("The taxon, " + taxonRow.getName() + " is not found in this matrix");
            }
            int j = 0;
            for (Taxon taxonColumn : taxonSubset) {
                int column = this.taxa.indexOf(taxonColumn);
                if (column == -1) {
                    throw new IllegalArgumentException("The taxon, " + taxonColumn.getName() + " is not found in this matrix");
                }
                newDistances[i][j] = this.getDistance(row, column);
            }
            ++i;
        }
        return new BasicDistanceMatrix(taxonSubset, newDistances);
    }

    @Override
    public double[][] getDistances() {
        return this.distances;
    }

    protected static double[][] buildDistancesMatrix(PairwiseDistanceCalculator pairwiseDistanceCalculator, int dimension, boolean useTwiceMaximumDistanceWhenPairwiseDistanceNotCalculatable, ProgressListener progress) throws CannotBuildDistanceMatrixException {
        int j;
        int i;
        double[][] distances = new double[dimension][dimension];
        float tot = dimension * (dimension - 1) / 2;
        int done = 0;
        double noDistance = -1.0;
        double maxDistance = -1.0;
        for (i = 0; i < dimension; ++i) {
            for (j = i + 1; j < dimension; ++j) {
                try {
                    distances[i][j] = pairwiseDistanceCalculator.calculatePairwiseDistance(i, j);
                    maxDistance = Math.max(distances[i][j], maxDistance);
                }
                catch (CannotBuildDistanceMatrixException e) {
                    if (!useTwiceMaximumDistanceWhenPairwiseDistanceNotCalculatable) {
                        throw e;
                    }
                    distances[i][j] = -1.0;
                }
                distances[j][i] = distances[i][j];
                if (progress == null) continue;
                progress.setProgress((float)(++done) / tot);
            }
        }
        if (maxDistance < 0.0) {
            throw new CannotBuildDistanceMatrixException("It is not possible to compute the Tamura-Nei genetic distance for these sequences because no pair of sequences overlap in the alignment.");
        }
        for (i = 0; i < dimension; ++i) {
            for (j = i + 1; j < dimension; ++j) {
                if (distances[i][j] != -1.0) continue;
                double d = maxDistance * 2.0;
                distances[j][i] = d;
                distances[i][j] = d;
            }
        }
        return distances;
    }

    protected static interface PairwiseDistanceCalculator {
        public double calculatePairwiseDistance(int var1, int var2) throws CannotBuildDistanceMatrixException;
    }
}

