/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.distances;

import java.util.List;
import jebl.evolution.alignments.Alignment;
import jebl.evolution.sequences.Nucleotides;
import jebl.evolution.sequences.Sequence;
import jebl.evolution.sequences.SequenceType;

public class ModelBasedDistanceMatrix {
    protected static final double MAX_DISTANCE = 1000.0;
    protected double freqR;
    protected double freqY;

    private int[] countStates(List<Sequence> sequences) {
        if (sequences.isEmpty()) {
            throw new IllegalArgumentException("No sequences passed in - unable to determine sequence type");
        }
        SequenceType sequenceType = sequences.get(0).getSequenceType();
        int canonicalStateCount = sequenceType.getCanonicalStateCount();
        int[] counts = new int[canonicalStateCount];
        for (Sequence sequence : sequences) {
            if (!sequence.getSequenceType().equals(sequenceType)) {
                throw new IllegalArgumentException("Sequences of mixed type");
            }
            for (byte i : sequence.getStateIndices()) {
                if (i >= canonicalStateCount) continue;
                byte by = i;
                counts[by] = counts[by] + 1;
            }
        }
        return counts;
    }

    private int[] countStatesSafe(List<Sequence> sequences) {
        int i;
        int[] counts = this.countStates(sequences);
        int numSequences = counts.length;
        boolean anyZero = false;
        for (i = 0; i < numSequences; ++i) {
            anyZero |= counts[i] == 0;
        }
        if (anyZero) {
            i = 0;
            while (i < numSequences) {
                int n = i++;
                counts[n] = counts[n] + 1;
            }
        }
        return counts;
    }

    private double[] getFrequenciesMaybeSafe(List<Sequence> sequences, boolean safe) {
        int i;
        SequenceType sequenceType = sequences.get(0).getSequenceType();
        int[] counts = safe ? this.countStatesSafe(sequences) : this.countStates(sequences);
        int canonicalStateCount = counts.length;
        double[] freqs = new double[canonicalStateCount];
        long count = 0L;
        for (i = 0; i < canonicalStateCount; ++i) {
            count += (long)counts[i];
        }
        for (i = 0; i < canonicalStateCount; ++i) {
            freqs[i] = (double)counts[i] / (double)count;
        }
        if (sequenceType.equals(SequenceType.NUCLEOTIDE)) {
            this.freqR = freqs[Nucleotides.A_STATE.getIndex()] + freqs[Nucleotides.G_STATE.getIndex()];
            this.freqY = freqs[Nucleotides.C_STATE.getIndex()] + freqs[Nucleotides.T_STATE.getIndex()];
        }
        return freqs;
    }

    protected double[] getFrequenciesSafe(List<Sequence> sequences) {
        return this.getFrequenciesMaybeSafe(sequences, true);
    }

    protected double[] getFrequenciesSafe(Alignment alignment) {
        return this.getFrequenciesSafe(alignment.getSequenceList());
    }

    protected double[] getFrequencies(List<Sequence> sequences) {
        return this.getFrequenciesMaybeSafe(sequences, false);
    }

    protected double[] getFrequencies(Alignment alignment) {
        return this.getFrequencies(alignment.getSequenceList());
    }
}

