/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.io;

import java.io.IOException;
import java.util.logging.Logger;

public class ByteBuilder
implements CharSequence,
Appendable {
    private static final Logger logger = Logger.getLogger(ByteBuilder.class.getName());
    final int maxCapacity;
    int current = 0;
    byte[] data;

    void ensureCapacity(int cap) {
        if (cap > this.maxCapacity) {
            throw new IllegalArgumentException("requested capacity " + cap + " is > the allowed maximum capacity " + this.maxCapacity + " for this ByteBuilder");
        }
        if (cap > this.data.length) {
            int newLen = 2 * (cap + 1);
            if (newLen <= 0) {
                newLen += 256;
            }
            if (newLen > this.maxCapacity) {
                newLen = this.maxCapacity;
            }
            if (newLen < cap) {
                newLen = cap;
            }
            byte[] d = new byte[newLen];
            System.arraycopy(this.data, 0, d, 0, this.data.length);
            this.data = d;
        }
    }

    public ByteBuilder(int maxCapacity) {
        this.maxCapacity = maxCapacity;
        if (maxCapacity < 0) {
            throw new IllegalArgumentException("maxCapacity must be positive, but got " + maxCapacity);
        }
        this.data = new byte[16];
        if (maxCapacity < this.data.length) {
            logger.warning("ByteBuilder with a very small maxCapacity constructed: " + maxCapacity);
        }
    }

    public static boolean isCharacterAscii(char c) {
        return c < '\u0080';
    }

    @Override
    public ByteBuilder append(char c) {
        if (this.current + 1 > this.data.length) {
            this.ensureCapacity(this.current + 1);
        }
        if (!ByteBuilder.isCharacterAscii(c)) {
            throw new IllegalArgumentException("Can't append multi-byte character #" + c + " to a ByteBuilder: " + c);
        }
        this.data[this.current] = (byte)c;
        ++this.current;
        return this;
    }

    @Override
    public ByteBuilder append(CharSequence charSequence) throws IOException {
        return this.append(charSequence, 0, charSequence.length());
    }

    @Override
    public ByteBuilder append(CharSequence csq, int start, int end) throws IOException {
        for (int i = start; i < end; ++i) {
            this.append(csq.charAt(i));
        }
        return this;
    }

    @Override
    public int length() {
        return this.current;
    }

    @Override
    public char charAt(int index) {
        return (char)this.data[index];
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return new String(this.data, start, end - start);
    }

    @Override
    public String toString() {
        return new String(this.data, 0, this.current);
    }
}

