/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.io;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Collection;
import jebl.evolution.io.SequenceExporter;
import jebl.evolution.sequences.Sequence;
import jebl.evolution.taxa.Taxon;

public class FastaExporter
implements SequenceExporter {
    private final PrintWriter writer;

    public FastaExporter(Writer writer) {
        this.writer = new PrintWriter(writer);
    }

    @Override
    public void exportSequences(Collection<? extends Sequence> sequences) throws IOException {
        for (Sequence sequence : sequences) {
            this.exportSequence(sequence);
        }
    }

    public void exportSequence(Sequence sequence) throws IOException {
        Taxon taxon = sequence.getTaxon();
        String desc = (String)sequence.getAttribute("description");
        if (desc == null) {
            desc = (String)taxon.getAttribute("description");
        }
        this.writer.println(">" + taxon.getName().replace(' ', '_') + (String)(desc != null ? " " + desc : ""));
        this.writer.println(sequence.getString());
    }
}

