/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.io;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.List;
import jebl.evolution.alignments.Alignment;
import jebl.evolution.io.AlignmentExporter;
import jebl.evolution.sequences.Sequence;
import jebl.evolution.sequences.SequenceType;

public class MEGAExporter
implements AlignmentExporter {
    private PrintWriter writer;

    public MEGAExporter(Writer writer, String comment) {
        this.writer = new PrintWriter(writer);
        this.writer.println("#mega");
        if (comment != null) {
            this.writer.println("!" + comment);
        }
    }

    public void exportAlignment(Alignment alignment, String name) throws IOException {
        this.writer.print("!Title ");
        this.writer.print(name);
        this.writer.println(";");
        this.writer.print("!Format DataType=");
        String dataType = alignment.getSequenceType() == SequenceType.NUCLEOTIDE ? "nucleotide" : "protein";
        this.writer.println(dataType + ";");
        this.exportAlignment(alignment);
    }

    @Override
    public void exportAlignment(Alignment alignment) throws IOException {
        List<Sequence> seqs = alignment.getSequenceList();
        for (Sequence seq : seqs) {
            this.writer.println();
            this.writer.println("#" + seq.getTaxon().getName().replaceAll(" ", "_"));
            this.writer.println(seq.getString());
        }
    }
}

