/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import jebl.evolution.graphs.Node;
import jebl.evolution.io.ImportException;
import jebl.evolution.io.ImportHelper;
import jebl.evolution.io.NexusImporter;
import jebl.evolution.io.TreeImporter;
import jebl.evolution.taxa.Taxon;
import jebl.evolution.trees.RootedTree;
import jebl.evolution.trees.SimpleRootedTree;
import jebl.evolution.trees.Tree;

public class NewickImporter
implements TreeImporter {
    private final ImportHelper helper;
    private boolean unquotedLabels;

    public NewickImporter(Reader reader, boolean unquotedLabels) {
        this.helper = new ImportHelper(reader);
        this.unquotedLabels = unquotedLabels;
    }

    @Override
    public Iterator<Tree> iterator() {
        return new Iterator<Tree>(){

            @Override
            public boolean hasNext() {
                boolean hasNext = false;
                try {
                    hasNext = NewickImporter.this.hasTree();
                }
                catch (IOException iOException) {
                }
                catch (ImportException importException) {
                    // empty catch block
                }
                return hasNext;
            }

            @Override
            public Tree next() {
                Tree tree = null;
                try {
                    tree = NewickImporter.this.importNextTree();
                }
                catch (IOException iOException) {
                }
                catch (ImportException importException) {
                    // empty catch block
                }
                if (tree == null) {
                    throw new NoSuchElementException("No more trees in this file");
                }
                return tree;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("operation is not supported by this Iterator");
            }
        };
    }

    @Override
    public boolean hasTree() throws IOException, ImportException {
        try {
            this.helper.skipUntil("(");
            this.helper.unreadCharacter('(');
        }
        catch (EOFException e) {
            return false;
        }
        return true;
    }

    @Override
    public Tree importNextTree() throws IOException, ImportException {
        try {
            this.helper.skipUntil("(");
            this.helper.unreadCharacter('(');
            return this.readTree();
        }
        catch (EOFException e) {
            throw new ImportException("error");
        }
    }

    @Override
    public List<Tree> importTrees() throws IOException, ImportException {
        ArrayList<Tree> trees = new ArrayList<Tree>();
        while (this.hasTree()) {
            Tree t = this.importNextTree();
            if (t == null) continue;
            trees.add(t);
        }
        return trees;
    }

    private RootedTree readTree() throws IOException, ImportException {
        SimpleRootedTree tree = new SimpleRootedTree();
        this.readInternalNode(tree);
        return tree;
    }

    private Node readBranch(SimpleRootedTree tree) throws IOException, ImportException {
        Node branch = this.helper.nextCharacter() == '(' ? this.readInternalNode(tree) : this.readExternalNode(tree);
        if (this.helper.getLastDelimiter() == 58) {
            double length = this.helper.readDouble(",():;");
            tree.setLength(branch, length);
        } else {
            tree.setLength(branch, 1.0);
        }
        return branch;
    }

    private Node readInternalNode(SimpleRootedTree tree) throws IOException, ImportException {
        ArrayList<Node> children = new ArrayList<Node>();
        this.helper.readCharacter();
        children.add(this.readBranch(tree));
        while (this.helper.getLastDelimiter() == 44) {
            children.add(this.readBranch(tree));
        }
        if (this.helper.getLastDelimiter() != 41) {
            throw new ImportException.BadFormatException("Missing closing ')' in tree");
        }
        SimpleRootedTree.SimpleRootedNode node = tree.createInternalNode(children);
        try {
            String token = this.helper.readToken(":(),;");
            if (token.length() > 0) {
                node.setAttribute("label", NexusImporter.parseValue(token));
            }
            NexusImporter.parseAndClearMetaComments(node, this.helper);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return node;
    }

    private Node readExternalNode(SimpleRootedTree tree) throws IOException, ImportException {
        Object label = this.helper.readToken(":(),;");
        while (this.unquotedLabels && this.helper.getLastDelimiter() == 32) {
            label = (String)label + " " + this.helper.readToken(":(),;");
        }
        if ("".equals(label)) {
            throw new ImportException.UnknownTaxonException("Emtpy node names are not allowed.");
        }
        try {
            return tree.createExternalNode(Taxon.getTaxon((String)label));
        }
        catch (IllegalArgumentException e) {
            throw new ImportException.DuplicateTaxaException(e.getMessage());
        }
    }
}

