/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import jebl.evolution.distances.BasicDistanceMatrix;
import jebl.evolution.distances.DistanceMatrix;
import jebl.evolution.io.DistanceMatrixImporter;
import jebl.evolution.io.ImportException;
import jebl.evolution.io.ImportHelper;
import jebl.evolution.taxa.Taxon;

public class TabDelimitedImporter
implements DistanceMatrixImporter {
    private final ImportHelper helper;
    private final DistanceMatrixImporter.Triangle triangle;
    private final boolean diagonal;
    private final boolean rowLabels;
    private final boolean columnLabels;

    public TabDelimitedImporter(Reader reader, DistanceMatrixImporter.Triangle triangle, boolean diagonal, boolean rowLabels, boolean columnLabels) {
        this.helper = new ImportHelper(reader);
        this.triangle = triangle;
        this.diagonal = diagonal;
        this.rowLabels = rowLabels;
        this.columnLabels = columnLabels;
        if (!rowLabels && !columnLabels) {
            throw new IllegalArgumentException("The matrix must have either row labels or column labels (or both)");
        }
    }

    @Override
    public List<DistanceMatrix> importDistanceMatrices() throws IOException, ImportException {
        int j;
        String line;
        ArrayList<Taxon> taxa = new ArrayList<Taxon>();
        ArrayList rows = new ArrayList();
        boolean done = false;
        if (this.columnLabels) {
            String[] labels;
            line = this.helper.readLine();
            for (String label : labels = line.split("\t")) {
                Taxon taxon = Taxon.getTaxon(label);
                if (taxa.contains(taxon)) {
                    throw new ImportException.BadFormatException("The taxon label, " + taxon.getName() + ", appears more than once in the matrix");
                }
                taxa.add(taxon);
            }
        }
        do {
            try {
                this.helper.skipWhile(" ");
                line = this.helper.readLine();
                String[] tokens = line.split("\t");
                int i = 0;
                if (this.rowLabels) {
                    Taxon taxon = Taxon.getTaxon(tokens[0]);
                    ++i;
                    if (this.columnLabels) {
                        int index = taxa.indexOf(taxon);
                        if (index != i) {
                            throw new ImportException.BadFormatException("The row label, " + taxon.getName() + ", is missing or in a different order from the column labels");
                        }
                    } else {
                        if (taxa.contains(taxon)) {
                            throw new ImportException.BadFormatException("The taxon label, " + taxon.getName() + ", appears more than once in the matrix");
                        }
                        taxa.add(taxon);
                    }
                }
                ArrayList<Double> arrayList = new ArrayList<Double>();
                for (j = i; j < tokens.length; ++j) {
                    arrayList.add(Double.parseDouble(tokens[j]));
                }
                rows.add(arrayList);
            }
            catch (EOFException eofe) {
                done = true;
            }
        } while (!done);
        double[][] distances = new double[rows.size()][rows.size()];
        int i = 0;
        for (List list : rows) {
            if (i >= distances.length) {
                throw new ImportException.BadFormatException("Too many rows in matrix");
            }
            if (this.triangle == DistanceMatrixImporter.Triangle.LOWER) {
                j = 0;
                for (Double distance : list) {
                    if (j >= distances[i].length) {
                        throw new ImportException.BadFormatException("Too many values in row " + Integer.toString(i + 1) + " of matrix");
                    }
                    if (i != j) {
                        distances[i][j] = distance;
                        distances[j][i] = distance;
                    } else if (this.diagonal) {
                        distances[i][j] = distance;
                    }
                    ++j;
                }
            } else if (this.triangle == DistanceMatrixImporter.Triangle.UPPER) {
                j = i;
                for (Double distance : list) {
                    if (j >= distances[i].length) {
                        throw new ImportException.BadFormatException("Too many values in row " + Integer.toString(i + 1) + " of matrix");
                    }
                    if (i != j) {
                        distances[i][j] = distance;
                        distances[j][i] = distance;
                    } else if (this.diagonal) {
                        distances[i][j] = this.helper.readDouble();
                    }
                    ++j;
                }
            } else {
                j = 0;
                for (Double distance : list) {
                    if (j >= distances[i].length) {
                        throw new ImportException.BadFormatException("Too many values in row " + Integer.toString(i + 1) + " of matrix");
                    }
                    distances[i][j] = i != j || this.diagonal ? distance : 0.0;
                    ++j;
                }
            }
            ++i;
        }
        ArrayList<DistanceMatrix> matrices = new ArrayList<DistanceMatrix>();
        matrices.add(new BasicDistanceMatrix(taxa, distances));
        return matrices;
    }
}

